/*!
    \file    gd32a508_libopt.h
    \brief   library optional for gd32a508

    \version 2025-08-19, V1.3.0, demo for GD32A508
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32A508_LIBOPT_H
#define GD32A508_LIBOPT_H


#include "gd32a508_adc.h"
#include "gd32a508_bkp.h"
#include "gd32a508_can.h"
#include "gd32a508_crc.h"
#include "gd32a508_ctc.h"
#include "gd32a508_dac.h"
#include "gd32a508_dbg.h"
#include "gd32a508_dma.h"
#include "gd32a508_exmc.h"
#include "gd32a508_exti.h"
#include "gd32a508_fmc.h"
#include "gd32a508_fwdgt.h"
#include "gd32a508_gpio.h"
#include "gd32a508_shrtimer.h"
#include "gd32a508_i2c.h"
#include "gd32a508_misc.h"
#include "gd32a508_pmu.h"
#include "gd32a508_rcu.h"
#include "gd32a508_rtc.h"
#include "gd32a508_spi.h"
#include "gd32a508_timer.h"
#include "gd32a508_usart.h"
#include "gd32a508_wwdgt.h"
#include "gd32a508_sqpi.h"
#include "gd32a508_enet.h"
#include "gd32a508_tmu.h"
#include "gd32a508_cmp.h"

#endif /* GD32A508_LIBOPT_H */
