/*!
    /file    usbd_conf.h
    /brief   USB device driver basic configuration

    \version 2025-08-08, V1.3.0, firmware for GD32E51x
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef __USBD_CONF_H
#define __USBD_CONF_H

#include "gd32e51x.h"
#include "gd32e513z_eval.h"
#include "dfu_mem.h"
#include "exmc_nandflash.h"
#include "nor_flash_if.h"
#include "nand_flash_if.h"
#include "inter_flash_if.h"

#define USBD_CFG_MAX_NUM                  1U
#define USBD_ITF_MAX_NUM                  1U
#define USB_STR_DESC_MAX_SIZE         64U

#define DFU_MAX_ALT_ITF_NUM           3
#define STR_IDX_ALT_ITF0              5
#define STR_IDX_ALT_ITF1              6
#define STR_IDX_ALT_ITF2              7

#define USBD_DFU_INTERFACE                0U

/* USB feature -- Self Powered */
/* #define USBD_SELF_POWERED */

/* USB user string supported */
#define USB_SUPPORT_USER_STRING_DESC

#define MAX_USED_MEMORY_MEDIA             3U

/* DFU maximum data packet size */
#define TRANSFER_SIZE                     2048U

/* memory address from where user application will be loaded, which represents 
   the dfu code protected against write and erase operations.*/
#define APP_LOADED_ADDR                   0x08008000U

/* Make sure the corresponding memory where the DFU code should not be loaded
   cannot be erased or overwritten by DFU application. */
#define IS_PROTECTED_AREA(addr)  (uint8_t)((((addr) >= 0x08000000) && ((addr) < (APP_LOADED_ADDR)))? 1 : 0)

/* DFU endpoint define */
#define DFU_IN_EP                          EP_IN(0)
#define DFU_OUT_EP                         EP_OUT(0)

#define EP0_TX_ADDR                        0x10U
#define EP0_RX_ADDR                        0x50U

/* endpoint count used by the DFU device */
#define EP_COUNT                           (1U)

/* base address of the allocation buffer, used for buffer descriptor table and packet memory */
#define BTABLE_OFFSET                      (0x0000U)

#define USB_STRING_COUNT                   0x08U

#define USB_PULLUP                         GPIOD
#define USB_PULLUP_PIN                     GPIO_PIN_2
#define RCU_AHBPeriph_GPIO_PULLUP          RCU_GPIOD

#endif /* __USBD_CONF_H */
