/*********************************************************************
 *                SEGGER MICROCONTROLLER SYSTEME GmbH                *
 *        Solutions for real time microcontroller applications       *
 *********************************************************************
 *                                                                   *
 *      (C) 2005- 2007 SEGGER Microcontroller Systeme GmbH           *
 *                  www.segger.com                                   *
 *                                                                   *
 *********************************************************************

 ---------------------------------------------------------------------
 File   : STR912_Startup.s
 Purpose: Startup file for embOS and GNU

 -------- END-OF-HEADER ----------------------------------------------
 

 ********************************************************************/

        ARM_MODE_USER  = 0x10      /* Normal User Mode                             */ 
        ARM_MODE_FIQ   = 0x11      /* FIQ Fast Interrupts Mode                     */
        ARM_MODE_IRQ   = 0x12      /* IRQ Standard Interrupts Mode                 */
        ARM_MODE_SVC   = 0x13      /* Supervisor Interrupts Mode                   */
        ARM_MODE_ABORT = 0x17      /* Abort Processing memory Faults Mode          */
        ARM_MODE_UNDEF = 0x1B      /* Undefined Instructions Mode                  */
        ARM_MODE_SYS   = 0x1F      /* System Running in Priviledged Operating Mode */
        ARM_MODE_MASK  = 0x1F
       
        I_BIT          = 0x80      /* disable IRQ when I bit is set */
        F_BIT          = 0x40      /* disable IRQ when I bit is set */

.equ    SCRO_AHB_UNB,    0x5C002034

        .text
        .global  __vector
        .extern  IRQ_Handler
        .extern  Reset_Handler
         
        .arm
        .section .vectors, "ax" 
                        
__vector:
                ldr     pc,Reset_Addr       /* RESET vector                 */
                ldr     pc,Undef_Addr		/* Undefined instruction vector */
                ldr     pc,SWI_Addr		    /* Software interrupt vector    */
                ldr     pc,PAbt_Addr		/* Prefetch abort vector        */
                ldr     pc,DAbt_Addr
                nop                         /* Reserved Vector              */
                ldr     pc,IRQ_Addr
                ldr     pc,FIQ_Addr

Reset_Addr:     .word   Reset_Handler
Undef_Addr:     .word   Undef_Handler
SWI_Addr:       .word   SWI_Handler
PAbt_Addr:      .word   PAbt_Handler
DAbt_Addr:      .word   DAbt_Handler
IRQ_Addr:       .word   IRQ_Handler
FIQ_Addr:       .word   FIQ_Handler

Undef_Handler:  b       Undef_Handler
SWI_Handler:    b       SWI_Handler
PAbt_Handler:   b       PAbt_Handler
DAbt_Handler:   b       DAbt_Handler
FIQ_Handler:    b       FIQ_Handler 
__vector_end:

/* --------------------------------------------------
   ?cstartup -- low-level system initialization code.

   After a reser execution starts here, the mode is ARM, supervisor
   with interrupts disabled. */
        .extern  _main
        .global  Reset_Handler
        .arm
        .section .text, "ax"  

/**********************************************************************
* ?CSTARTUP
*
* Execution starts here.
* After a reset, the mode is ARM, Supervisor, interrupts disabled.
*/
Reset_Handler:
        ldr     pc,=NextInst

NextInst:
        nop  /* execute some instructions to access CPU registers after wake */
        nop  /* up from Reset, while waiting for OSC stabilization           */
        nop
        nop
        nop
        nop
        nop
        nop
        nop


/* -- Remap Flash Bank 0 at address 0x0 and Bank 1 at address 0x80000,
      when the bank 0 is the boot bank, then enable the Bank 1. */

        ldr r6, =0x54000000    /* BOOT BANK Size = 512KB */
        ldr r7, =0x4           /* (2^4) * 32 = 512KB     */
        str r7, [r6]

        ldr r6, =0x54000004    /* NON BOOT BANK Size = 32KB */
        ldr r7, =0x2           /* (2^2) * 8 = 32KB          */
        str r7, [r6]

        ldr r6, =0x5400000C    /* BOOT BANK Address = 0x0 */
        ldr r7, =0x0
        str r7, [r6]

        ldr r6, =0x54000010    /* NON BOOT BANK Address = 0x80000                           */
        ldr r7, =0x20000       /* need to put 0x20000 because FMI bus on A[25:2] of CPU bus */
        str r7, [r6]

        ldr r6, =0x54000018    /* Enable CS on both banks */
        ldr r7, =0x18
        str r7, [r6]

/* -- Enable 96K RAM */

        ldr r0, = SCRO_AHB_UNB
        ldr r1, = 0x0191       /* PFQBC enabled / DTCM & AHB wait-states disabled */
        str r1, [r0]

       /*
        * Setup a stack for each mode
        */    
        msr   CPSR_c, #ARM_MODE_UNDEF | I_BIT | F_BIT   /* Undefined Instruction Mode */     
        ldr   sp, =__stack_und_end__
       
        msr   CPSR_c, #ARM_MODE_ABORT | I_BIT | F_BIT   /* Abort Mode */
        ldr   sp, =__stack_abt_end__
       
        msr   CPSR_c, #ARM_MODE_FIQ | I_BIT | F_BIT     /* FIQ Mode */   
        ldr   sp, =__stack_fiq_end__
       
        msr   CPSR_c, #ARM_MODE_IRQ | I_BIT | F_BIT     /* IRQ Mode */   
        ldr   sp, =__stack_irq_end__
       
        msr   CPSR_c, #ARM_MODE_SVC | I_BIT | F_BIT     /* Supervisor Mode */
        ldr   sp, =__stack_svc_end__

/* -- Set bits 17-18 (DTCM/ITCM order bits) of the Core Configuration Control Register */

        mov   r0, #0x60000
        mcr   p15, 0x1, r0, c15, c1, 0

        ldr   r2, =_main
        mov   lr, pc
        bx    r2     /* And jump... */


       .end

/***** EOF ***********************************************************/
