/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External Includes*/
/* user code [External Includes] begin */
#include <stdio.h>

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
__IO FlagStatus g_tamperbutton_flag = RESET;
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
static ErrStatus trng_configuration(void);
static ErrStatus trng_ready_check(void);

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint32_t random_data = 0, random_lastdata = 0;
    uint8_t retry = 0;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_trng_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    printf("============ Gigadevice TRNG LFSR mode demo ============ \r\n");

    /* configure TRNG module */
    while((ERROR == trng_configuration()) && retry < 3) {
        printf("TRNG init fail and retry %d\r\n", retry + 1);
        retry++;
    }

    if(retry >= 3U) {
        printf("TRNG init fail! Please reboot!\r\n");
        while(1);
    }

    printf("TRNG init successful \r\n");
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */
        if(SET == g_tamperbutton_flag) {
            g_tamperbutton_flag = RESET;

            /* enable TRNG module */
            trng_enable();
            /* check whether the random data is valid and get it */
            if(SUCCESS == trng_ready_check()) {
                random_data = trng_get_true_random_data();
                if(random_data != random_lastdata) {
                    random_lastdata = random_data;
                    printf("Get random number: 0x%08x \r\n", random_data);
                } else {
                    /* the random data is invalid */
                    printf("Error: Get the the same random number! \r\n");
                }
            }
            /* disable TRNG module */
            trng_disable();
        }
        /* user code [local 3] end */
    }
}

/* user code [Public Functions Implementations] begin */


/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      check whether TRNG is ready or not
    \param[in]  none
    \param[out] none
    \retval     SUCCESS: TRNG is ready
                ERROR: TRNG is not ready
*/
static ErrStatus trng_ready_check(void)
{
    uint32_t timeout     = 0;
    FlagStatus trng_flag = RESET;

    /* check whether the random data is valid */
    do {
        timeout++;
        trng_flag = trng_flag_get(TRNG_FLAG_DRDY);
    } while((RESET == trng_flag) && (0xFFFF > timeout));

    if(SET == trng_flag) {
        if(RESET == trng_interrupt_flag_get(TRNG_INT_FLAG_CEIF)) {
            if(RESET == trng_interrupt_flag_get(TRNG_INT_FLAG_SEIF)) {
                if(RESET == trng_flag_get(TRNG_FLAG_CECS)) {
                    if(RESET == trng_flag_get(TRNG_FLAG_SECS)) {
                        return SUCCESS;
                    }
                }
            }
        }
    }

    printf("error occurred! : %x \r\n", TRNG_STAT);
    /* return check status */
    return ERROR;
}

/*!
    \brief      configure TRNG module
    \param[in]  none
    \param[out] none
    \retval     SUCCESS: TRNG module configuration is successful
                ERROR: TRNG module configuration is failed
*/
static ErrStatus trng_configuration(void)
{
    ErrStatus reval = SUCCESS;
    while(SET != rcu_flag_get(RCU_FLAG_PLLSTB));
    msd_trng_init();

    /* enable TRNG module */
    trng_enable();
    /* check TRNG work status */
    reval = trng_ready_check();

    /* disable TRNG module */
    trng_disable();
    return reval;
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in] ch: The character to be transmitted via USART.
    \param[in] f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval ch: The character that was transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
