/*
    \file  gd32g5x3_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3_init.h"

/* user code [global 0] begin */

/* user code [global 0] end */

/* External includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
volatile static uint32_t delay;

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
uint32_t adc_value[4];

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);
    nvic_priority_group_set(NVIC_PRIGROUP_PRE0_SUB4);
    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);
    nvic_exception_irq_enable(MemoryManagement_IRQn, 0, 0);
    nvic_exception_irq_enable(BusFault_IRQn, 0, 0);
    nvic_exception_irq_enable(UsageFault_IRQn, 0, 0);
    nvic_exception_irq_enable(SVCall_IRQn, 0, 0);
    nvic_exception_irq_enable(DebugMonitor_IRQn, 0, 0);
    nvic_exception_irq_enable(PendSV_IRQn, 0, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);

    rcu_pll_source_config(RCU_PLLSRC_HXTAL);
    rcu_pll_config((2U), (108U), (2U), (2U), (2U));
    rcu_pll_clock_output_enable(RCU_PLLP);
    fmc_wscnt_set(FMC_WAIT_STATE_7);
    rcu_system_clock_source_config(RCU_CKSYSSRC_PLLP);
    rcu_osci_on(RCU_PLL_CK);
    while(rcu_osci_stab_wait(RCU_PLL_CK) != SUCCESS);

    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb1_clock_config(RCU_APB1_CKAHB_DIV1);
    rcu_apb2_clock_config(RCU_APB2_CKAHB_DIV1);
    rcu_apb3_clock_config(RCU_APB3_CKAHB_DIV1);

    rcu_adc_clock_config(IDX_ADC0, RCU_ADCSRC_CKSYS);
    rcu_usart_clock_config(IDX_USART0, RCU_USARTSRC_APB);

    rcu_osci_bypass_mode_disable(RCU_HXTAL);
    rcu_osci_bypass_mode_disable(RCU_LXTAL);
    rcu_hxtal_clock_monitor_disable();
    rcu_lxtal_clock_monitor_disable();

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if(SysTick_Config(SystemCoreClock / 1000U)) {
        /* capture error */
        while(1);
    }

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      DMA initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_dma_init(void)
{
    /* user code [dma_init local 0] begin */

    /* user code [dma_init local 0] end */

    rcu_periph_clock_enable(RCU_DMA0);
    rcu_periph_clock_enable(RCU_DMAMUX);

    /* user code [dma_init local 1] begin */

    /* user code [dma_init local 1] end */
}

/*!
    \brief      DMA deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_dma_deinit(void)
{
    /* user code [dma_deinit local 0] begin */

    /* user code [dma_deinit local 0] end */

    rcu_periph_clock_disable(RCU_DMA0);
    rcu_periph_clock_disable(RCU_DMAMUX);

    /* user code [dma_deinit local 1] begin */

    /* user code [dma_deinit local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOC);
    rcu_periph_clock_enable(RCU_GPIOA);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOC);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      ADC0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_adc0_init(void)
{
    /* user code [adc0_init local 0] begin */

    /* user code [adc0_init local 0] end */

    dma_parameter_struct dma_adc0_init_p;
    dmamux_sync_parameter_struct adc0_dmamux_sync_parameter;

    rcu_periph_clock_enable(RCU_ADC0);

    gpio_mode_set(GPIOA, GPIO_MODE_ANALOG, GPIO_PUPD_NONE, GPIO_PIN_2);

    gpio_mode_set(GPIOA, GPIO_MODE_ANALOG, GPIO_PUPD_NONE, GPIO_PIN_3);

    gpio_mode_set(GPIOC, GPIO_MODE_ANALOG, GPIO_PUPD_NONE, GPIO_PIN_0);

    gpio_mode_set(GPIOC, GPIO_MODE_ANALOG, GPIO_PUPD_NONE, GPIO_PIN_1);

    adc_channel_differential_mode_config(ADC0, ADC_DIFFERENTIAL_MODE_CHANNEL_2, DISABLE);
    adc_channel_differential_mode_config(ADC0, ADC_DIFFERENTIAL_MODE_CHANNEL_3, DISABLE);
    adc_channel_differential_mode_config(ADC0, ADC_DIFFERENTIAL_MODE_CHANNEL_5, DISABLE);
    adc_channel_differential_mode_config(ADC0, ADC_DIFFERENTIAL_MODE_CHANNEL_6, DISABLE);
    adc_sync_mode_config(ADC_SYNC_MODE_INDEPENDENT);
    adc_clock_config(ADC0, ADC_CLK_SYNC_HCLK_DIV6);
    adc_data_alignment_config(ADC0, ADC_DATAALIGN_RIGHT);
    adc_resolution_config(ADC0, ADC_RESOLUTION_12B);
    adc_channel_length_config(ADC0, ADC_ROUTINE_CHANNEL, 4);
    adc_special_function_config(ADC0, ADC_CONTINUOUS_MODE, ENABLE);
    adc_special_function_config(ADC0, ADC_SCAN_MODE, ENABLE);
    adc_external_trigger_config(ADC0, ADC_ROUTINE_CHANNEL, EXTERNAL_TRIGGER_RISING);
    adc_routine_channel_config(ADC0, 0, ADC_CHANNEL_2, 24);
    adc_routine_channel_config(ADC0, 1, ADC_CHANNEL_3, 24);
    adc_routine_channel_config(ADC0, 2, ADC_CHANNEL_5, 24);
    adc_routine_channel_config(ADC0, 3, ADC_CHANNEL_6, 24);
    adc_dma_request_after_last_enable(ADC0);
    adc_calibration_mode_config(ADC0, ADC_CALIBRATION_OFFSET_MISMATCH);
    adc_calibration_number(ADC0, ADC_CALIBRATION_NUM1);

    dma_struct_para_init(&dma_adc0_init_p);
    dmamux_sync_struct_para_init(&adc0_dmamux_sync_parameter);

    dma_adc0_init_p.periph_addr  = 0x00000000;
    dma_adc0_init_p.periph_width = DMA_PERIPHERAL_WIDTH_32BIT;
    dma_adc0_init_p.memory_addr  = 0x00000000;
    dma_adc0_init_p.memory_width = DMA_MEMORY_WIDTH_32BIT;
    dma_adc0_init_p.number       = 4;
    dma_adc0_init_p.priority     = DMA_PRIORITY_HIGH;
    dma_adc0_init_p.periph_inc   = DMA_PERIPH_INCREASE_DISABLE;
    dma_adc0_init_p.memory_inc   = DMA_MEMORY_INCREASE_ENABLE;
    dma_adc0_init_p.direction    = DMA_PERIPHERAL_TO_MEMORY;
    dma_adc0_init_p.request      = DMA_REQUEST_ADC0;
    dma_init(DMA0, DMA_CH0, &dma_adc0_init_p);
    dma_circulation_enable(DMA0, DMA_CH0);
    dma_memory_to_memory_disable(DMA0, DMA_CH0);

    adc0_dmamux_sync_parameter.sync_id        = DMAMUX_SYNC_EXTI0;
    adc0_dmamux_sync_parameter.sync_polarity  = DMAMUX_SYNC_NO_EVENT;
    adc0_dmamux_sync_parameter.request_number = 1;
    dmamux_synchronization_init(DMAMUX_MULTIPLEXER_CH0, &adc0_dmamux_sync_parameter);
    dmamux_synchronization_disable(DMAMUX_MULTIPLEXER_CH0);
    dmamux_event_generation_disable(DMAMUX_MULTIPLEXER_CH0);

    /* user code [adc0_init local 1] begin */
    dma_transfer_number_config(DMA0, DMA_CH0, 4);
    dma_periph_address_config(DMA0, DMA_CH0, (uint32_t)(&ADC_RDATA(ADC0)));
    dma_memory_address_config(DMA0, DMA_CH0, (uint32_t)(&adc_value));
    dma_channel_enable(DMA0, DMA_CH0);
    adc_dma_mode_enable(ADC0);

    /* user code [adc0_init local 1] end */
}

/*!
    \brief      ADC0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_adc0_deinit(void)
{
    /* user code [adc0_deinit local 0] begin */

    /* user code [adc0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_ADC0);

    adc_deinit(ADC0);

    dma_deinit(DMA0, DMA_CH0);

    /* user code [adc0_deinit local 1] begin */

    /* user code [adc0_deinit local 1] end */
}

/*!
    \brief      TIMER0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer0_init(void)
{
    /* user code [timer0_init local 0] begin */

    /* user code [timer0_init local 0] end */

    timer_parameter_struct timer0_parameter;
    timer_oc_parameter_struct timer0_oc_parameter;
    timer_free_complementary_parameter_struct timer0_free_complementary_parameter;
    timer_break_parameter_struct timer0_break_parameter;

    rcu_periph_clock_enable(RCU_TIMER0);

    gpio_af_set(GPIOC, GPIO_AF_2, GPIO_PIN_2);
    gpio_mode_set(GPIOC, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_2);
    gpio_output_options_set(GPIOC, GPIO_OTYPE_PP, GPIO_OSPEED_60MHZ, GPIO_PIN_2);
    gpio_input_filter_set(GPIOC, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_2);

    timer_struct_para_init(&timer0_parameter);
    timer_channel_output_struct_para_init(&timer0_oc_parameter);
    timer_free_complementary_struct_para_init(&timer0_free_complementary_parameter);
    timer_break_struct_para_init(&timer0_break_parameter);

    timer_adjustment_mode_config(TIMER0, DISABLE);
    timer_auto_reload_shadow_enable(TIMER0);
    timer_counter_initial_register_config(TIMER0, DISABLE);
    timer_upif_backup_config(TIMER0, DISABLE);
    timer_master_slave_mode_config(TIMER0, TIMER_MASTER_SLAVE_MODE_DISABLE);
    timer_master_output0_trigger_source_select(TIMER0, TIMER_TRI_OUT0_SRC_RESET);
    timer_master_output1_trigger_source_select(TIMER0, TIMER_TRI_OUT1_SRC_RESET);
    timer0_parameter.prescaler         = 299;
    timer0_parameter.alignedmode       = TIMER_COUNTER_EDGE;
    timer0_parameter.counterdirection  = TIMER_COUNTER_UP;
    timer0_parameter.period            = 9999;
    timer0_parameter.repetitioncounter = 0xFFFFFFFF;
    timer0_parameter.clockdivision     = TIMER_CKDIV_DIV1;
    timer_init(TIMER0, &timer0_parameter);

    timer0_oc_parameter.outputstate  = TIMER_CCX_ENABLE;
    timer0_oc_parameter.outputnstate = TIMER_CCXN_DISABLE;
    timer0_oc_parameter.ocpolarity   = TIMER_OC_POLARITY_HIGH;
    timer0_oc_parameter.ocidlestate  = TIMER_OC_IDLE_STATE_LOW;
    timer_channel_output_config(TIMER0, TIMER_CH_2, &timer0_oc_parameter);

    timer_channel_output_mode_config(TIMER0, TIMER_CH_2, TIMER_OC_MODE_PWM0);
    timer_channel_output_pulse_value_config(TIMER0, TIMER_CH_2, 3999);
    timer_channel_output_shadow_config(TIMER0, TIMER_CH_2, TIMER_OC_SHADOW_DISABLE);
    timer_channel_output_clear_config(TIMER0, TIMER_CH_2, TIMER_OC_CLEAR_DISABLE);
    timer_channel_output_compare_fast_config(TIMER0, TIMER_CH_2, TIMER_OC_FAST_DISABLE);
    timer0_free_complementary_parameter.freecomstate = TIMER_FCCHP_STATE_DISABLE;
    timer_channel_free_complementary_config(TIMER0, TIMER_CH_2, &timer0_free_complementary_parameter);

    timer_channel_composite_pwm_mode_config(TIMER0, TIMER_CH_2, DISABLE);
    timer_output_match_pulse_select(TIMER0, TIMER_CH_2, TIMER_PULSE_OUTPUT_NORMAL);
    timer_multi_mode_channel_mode_config(TIMER0, TIMER_MCH_2, TIMER_MCH_MODE_COMPLEMENTARY);
    timer0_break_parameter.runoffstate     = TIMER_ROS_STATE_DISABLE;
    timer0_break_parameter.ideloffstate    = TIMER_IOS_STATE_DISABLE;
    timer0_break_parameter.deadtime        = 0;
    timer0_break_parameter.outputautostate = TIMER_OUTAUTO_DISABLE;
    timer0_break_parameter.protectmode     = TIMER_CCHP0_PROT_OFF;
    timer0_break_parameter.break0release   = TIMER_BREAK0_UNRELEASE;
    timer0_break_parameter.break1release   = TIMER_BREAK1_UNRELEASE;
    timer_break_config(TIMER0, &timer0_break_parameter);

    /* user code [timer0_init local 1] begin */
    timer_primary_output_config(TIMER0, ENABLE);
    timer_enable(TIMER0);

    /* user code [timer0_init local 1] end */
}

/*!
    \brief      TIMER0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer0_deinit(void)
{
    /* user code [timer0_deinit local 0] begin */

    /* user code [timer0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TIMER0);

    timer_deinit(TIMER0);

    /* user code [timer0_deinit local 1] begin */

    /* user code [timer0_deinit local 1] end */
}

/*!
    \brief      TRIGSEL initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_trigsel_init(void)
{
    /* user code [trigsel_init local 0] begin */

    /* user code [trigsel_init local 0] end */

    rcu_periph_clock_enable(RCU_TRIGSEL);

    trigsel_init(TRIGSEL_OUTPUT_ADC0_ROUTRG, TRIGSEL_INPUT_TIMER0_CH2);

    /* user code [trigsel_init local 1] begin */
    trigsel_register_lock_set(TRIGSEL_OUTPUT_ADC0_ROUTRG);

    /* user code [trigsel_init local 1] end */
}

/*!
    \brief      TRIGSEL deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_trigsel_deinit(void)
{
    /* user code [trigsel_deinit local 0] begin */

    /* user code [trigsel_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TRIGSEL);

    trigsel_deinit();

    /* user code [trigsel_deinit local 1] begin */

    /* user code [trigsel_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_10);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_9);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_receiver_timeout_disable(USART0);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_fifo_disable(USART0);
    usart_overrun_disable(USART0);
    usart_reception_error_dma_disable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_USART0);

    usart_deinit(USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */
/*!
    \brief      delay a time in milliseconds
    \param[in]  count: count in milliseconds
    \param[out] none
    \retval     none
*/
void delay_1ms(uint32_t count)
{
    delay = count;
    while(0U != delay) {}
}

/*!
    \brief      delay decrement
    \param[in]  none
    \param[out] none
    \retval     none
*/
void delay_decrement(void)
{
    if(0U != delay) {
        delay--;
    }
}

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
