/*
    \file  gd32g5x3_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3_init.h"

/* user code [global 0] begin */

/* user code [global 0] end */

/* External includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
uint32_t g_cmp0to7_rcu_enable_flag = 0;

/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);
    nvic_priority_group_set(NVIC_PRIGROUP_PRE0_SUB4);
    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);
    nvic_exception_irq_enable(MemoryManagement_IRQn, 0, 0);
    nvic_exception_irq_enable(BusFault_IRQn, 0, 0);
    nvic_exception_irq_enable(UsageFault_IRQn, 0, 0);
    nvic_exception_irq_enable(SVCall_IRQn, 0, 0);
    nvic_exception_irq_enable(DebugMonitor_IRQn, 0, 0);
    nvic_exception_irq_enable(PendSV_IRQn, 0, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);

    rcu_pll_source_config(RCU_PLLSRC_HXTAL);
    rcu_pll_config((2U), (108U), (2U), (2U), (2U));
    rcu_pll_clock_output_enable(RCU_PLLP);
    fmc_wscnt_set(FMC_WAIT_STATE_7);
    rcu_system_clock_source_config(RCU_CKSYSSRC_PLLP);
    rcu_osci_on(RCU_PLL_CK);
    while(rcu_osci_stab_wait(RCU_PLL_CK) != SUCCESS);

    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb1_clock_config(RCU_APB1_CKAHB_DIV1);
    rcu_apb2_clock_config(RCU_APB2_CKAHB_DIV1);
    rcu_apb3_clock_config(RCU_APB3_CKAHB_DIV1);

    rcu_usart_clock_config(IDX_USART0, RCU_USARTSRC_APB);

    rcu_osci_bypass_mode_disable(RCU_HXTAL);
    rcu_osci_bypass_mode_disable(RCU_LXTAL);
    rcu_hxtal_clock_monitor_disable();
    rcu_lxtal_clock_monitor_disable();

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if(SysTick_Config(SystemCoreClock / 1000U)) {
        /* capture error */
        while(1);
    }

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOA);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      CMP0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_cmp0_init(void)
{
    /* user code [cmp0_init local 0] begin */

    /* user code [cmp0_init local 0] end */

    g_cmp0to7_rcu_enable_flag++;
    if(1 == g_cmp0to7_rcu_enable_flag) {
        rcu_periph_clock_enable(RCU_CMP);
    }

    gpio_mode_set(GPIOA, GPIO_MODE_ANALOG, GPIO_PUPD_NONE, GPIO_PIN_1);

    cmp_voltage_scaler_enable(CMP0);
    cmp_scaler_bridge_enable(CMP0);
    cmp_noninverting_input_select(CMP0, CMP0_NONINVERTING_INPUT_PA1);
    cmp_mode_init(CMP0, CMPX_INVERTING_INPUT_VREFINT, CMP_HYSTERESIS_NO);
    cmp_output_init(CMP0, CMP_OUTPUT_POLARITY_NONINVERTED);
    cmp_blanking_init(CMP0, CMPX_BLANKING_NONE);
    cmp_reset_persist_mode_disable(CMP0);

    /* user code [cmp0_init local 1] begin */
    cmp_enable(CMP0);

    /* user code [cmp0_init local 1] end */
}

/*!
    \brief      CMP0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_cmp0_deinit(void)
{
    /* user code [cmp0_deinit local 0] begin */

    /* user code [cmp0_deinit local 0] end */

    if(0 != g_cmp0to7_rcu_enable_flag) {
        g_cmp0to7_rcu_enable_flag--;
    }

    if(0 == g_cmp0to7_rcu_enable_flag) {
        rcu_periph_clock_disable(RCU_CMP);
    }

    /* user code [cmp0_deinit local 1] begin */

    /* user code [cmp0_deinit local 1] end */
}

/*!
    \brief      TRIGSEL initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_trigsel_init(void)
{
    /* user code [trigsel_init local 0] begin */

    /* user code [trigsel_init local 0] end */

    rcu_periph_clock_enable(RCU_TRIGSEL);

    gpio_af_set(GPIOA, GPIO_AF_12, GPIO_PIN_15);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_15);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_60MHZ, GPIO_PIN_15);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_15);

    trigsel_init(TRIGSEL_OUTPUT_TRIGSEL_OUT0, TRIGSEL_INPUT_CMP0_OUT);

    /* user code [trigsel_init local 1] begin */
    trigsel_register_lock_set(TRIGSEL_OUTPUT_TRIGSEL_OUT0);

    /* user code [trigsel_init local 1] end */
}

/*!
    \brief      TRIGSEL deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_trigsel_deinit(void)
{
    /* user code [trigsel_deinit local 0] begin */

    /* user code [trigsel_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TRIGSEL);

    trigsel_deinit();

    /* user code [trigsel_deinit local 1] begin */

    /* user code [trigsel_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_10);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_9);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_receiver_timeout_disable(USART0);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_fifo_disable(USART0);
    usart_overrun_disable(USART0);
    usart_reception_error_dma_disable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_USART0);

    usart_deinit(USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
