/*
    \file  gd32g5x3_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3_init.h"

/* user code [global 0] begin */

/* user code [global 0] end */

/* External includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);
    nvic_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);
    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);
    nvic_exception_irq_enable(MemoryManagement_IRQn, 0, 0);
    nvic_exception_irq_enable(BusFault_IRQn, 0, 0);
    nvic_exception_irq_enable(UsageFault_IRQn, 0, 0);
    nvic_exception_irq_enable(SVCall_IRQn, 0, 0);
    nvic_exception_irq_enable(DebugMonitor_IRQn, 0, 0);
    nvic_exception_irq_enable(PendSV_IRQn, 0, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);

    rcu_pll_source_config(RCU_PLLSRC_HXTAL);
    rcu_pll_config((2U), (108U), (2U), (2U), (2U));
    rcu_pll_clock_output_enable(RCU_PLLP);
    fmc_wscnt_set(FMC_WAIT_STATE_7);
    rcu_system_clock_source_config(RCU_CKSYSSRC_PLLP);
    rcu_osci_on(RCU_PLL_CK);
    while(rcu_osci_stab_wait(RCU_PLL_CK) != SUCCESS);

    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb1_clock_config(RCU_APB1_CKAHB_DIV1);
    rcu_apb2_clock_config(RCU_APB2_CKAHB_DIV1);
    rcu_apb3_clock_config(RCU_APB3_CKAHB_DIV1);

    rcu_usart_clock_config(IDX_USART0, RCU_USARTSRC_APB);
    rcu_hrtimer_clock_config(RCU_HRTIMERSRC_CKSYS);

    rcu_osci_bypass_mode_disable(RCU_HXTAL);
    rcu_osci_bypass_mode_disable(RCU_LXTAL);
    rcu_hxtal_clock_monitor_disable();
    rcu_lxtal_clock_monitor_disable();

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if(SysTick_Config(SystemCoreClock / 1000U)) {
        /* capture error */
        while(1);
    }

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOB);
    rcu_periph_clock_enable(RCU_GPIOA);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOB);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      HRTIMER initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_hrtimer_init(void)
{
    /* user code [hrtimer_init local 0] begin */

    /* user code [hrtimer_init local 0] end */

    hrtimer_baseinit_parameter_struct baseinit_para;
    hrtimer_timerinit_parameter_struct timerinit_para;
    hrtimer_timercfg_parameter_struct timercfg_para;
    hrtimer_comparecfg_parameter_struct comparecfg_para;
    hrtimer_channel_outputcfg_parameter_struct outcfg_para;

    rcu_periph_clock_enable(RCU_HRTIMER);

    gpio_af_set(GPIOA, GPIO_AF_13, GPIO_PIN_8);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_8);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_8);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_8);

    gpio_af_set(GPIOA, GPIO_AF_13, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_9);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_9);

    hrtimer_baseinit_struct_para_init(&baseinit_para);
    hrtimer_timerinit_struct_para_init(&timerinit_para);
    hrtimer_timercfg_struct_para_init(&timercfg_para);
    hrtimer_comparecfg_struct_para_init(&comparecfg_para);
    hrtimer_channel_outputcfg_struct_para_init(&outcfg_para);

    hrtimer_dll_calibration_start(HRTIMER0, HRTIMER_CALIBRATION_ONCE);
    while(RESET == hrtimer_common_flag_get(HRTIMER0, HRTIMER_FLAG_DLLCAL));
    hrtimer_bunchmode_disable(HRTIMER0);
    baseinit_para.period            = 0x1B00;
    baseinit_para.repetitioncounter = 0;
    baseinit_para.prescaler         = HRTIMER_PRESCALER_MUL32;
    baseinit_para.counterdirection  = HRTIMER_COUNTER_UP;
    baseinit_para.counter_mode      = HRTIMER_COUNTER_MODE_CONTINOUS;
    hrtimer_timers_base_init(HRTIMER0, HRTIMER_SLAVE_TIMER0, &baseinit_para);

    timerinit_para.half_mode             = HRTIMER_HALFMODE_DISABLED;
    timerinit_para.alternate_mode        = HRTIMER_ALTERNATE_MODE_DISABLED;
    timerinit_para.resynchronized_update = HRTIMER_RSYUPD_DISABLED;
    timerinit_para.dac_trigger           = HRTIMER_DAC_TRIGGER_NONE;
    timerinit_para.shadow                = HRTIMER_SHADOW_DISABLED;
    timerinit_para.update_selection      = HRTIMER_MT_ST_UPDATE_SELECTION_INDEPENDENT;
    timerinit_para.repetition_update     = HRTIMER_UPDATEONREPETITION_DISABLED;
    hrtimer_timers_waveform_init(HRTIMER0, HRTIMER_SLAVE_TIMER0, &timerinit_para);

    timercfg_para.balanced_mode   = HRTIMER_STXBALANCEDMODE_ENABLED;
    timercfg_para.deadtime_enable = HRTIMER_STXDEADTIME_DISABLED;
    timercfg_para.delayed_idle    = HRTIMER_STXDELAYED_IDLE_DISABLED;
    timercfg_para.reset_update    = HRTIMER_STXUPDATEONRESET_DISABLED;
    hrtimer_slavetimer_waveform_config(HRTIMER0, HRTIMER_SLAVE_TIMER0, &timercfg_para);

    comparecfg_para.compare_value           = 0x3E8;
    comparecfg_para.immediately_update_cmp0 = HRTIMER_IMMEDIATELY_UPDATE_CMP0_DISABLE;
    hrtimer_slavetimer_waveform_compare_config(HRTIMER0, HRTIMER_SLAVE_TIMER0, HRTIMER_COMPARE0, &comparecfg_para);

    comparecfg_para.compare_value = 0xFA0;
    comparecfg_para.delayed_mode  = HRTIMER_DELAYEDMODE_DISABLE;
    comparecfg_para.trigger_half  = HRTIMER_TRGHALFM_DISABLE;
    hrtimer_slavetimer_waveform_compare_config(HRTIMER0, HRTIMER_SLAVE_TIMER0, HRTIMER_COMPARE1, &comparecfg_para);

    outcfg_para.polarity      = HRTIMER_CHANNEL_POLARITY_HIGH;
    outcfg_para.idle_state    = HRTIMER_CHANNEL_IDLESTATE_INACTIVE;
    outcfg_para.fault_state   = HRTIMER_CHANNEL_FAULTSTATE_NONE;
    outcfg_para.carrier_mode  = HRTIMER_CHANNEL_CARRIER_DISABLED;
    outcfg_para.set_request   = HRTIMER_CHANNEL_SET_CMP0;
    outcfg_para.reset_request = HRTIMER_CHANNEL_RESET_CMP1;
    hrtimer_slavetimer_waveform_channel_config(HRTIMER0, HRTIMER_SLAVE_TIMER0, HRTIMER_ST0_CH0, &outcfg_para);

    outcfg_para.polarity      = HRTIMER_CHANNEL_POLARITY_HIGH;
    outcfg_para.idle_state    = HRTIMER_CHANNEL_IDLESTATE_INACTIVE;
    outcfg_para.fault_state   = HRTIMER_CHANNEL_FAULTSTATE_NONE;
    outcfg_para.carrier_mode  = HRTIMER_CHANNEL_CARRIER_DISABLED;
    outcfg_para.set_request   = HRTIMER_CHANNEL_SET_CMP0;
    outcfg_para.reset_request = HRTIMER_CHANNEL_RESET_CMP1;
    hrtimer_slavetimer_waveform_channel_config(HRTIMER0, HRTIMER_SLAVE_TIMER0, HRTIMER_ST0_CH1, &outcfg_para);

    hrtimer_exeventx_counter_disable(HRTIMER0, HRTIMER_SLAVE_TIMER0);
    hrtimer_output_channel_enable(HRTIMER0, HRTIMER_ST0_CH0);
    hrtimer_output_channel_enable(HRTIMER0, HRTIMER_ST0_CH1);

    /* user code [hrtimer_init local 1] begin */
    /* enable a counter */
    hrtimer_timers_counter_enable(HRTIMER0, HRTIMER_ST0_COUNTER);

    /* user code [hrtimer_init local 1] end */
}

/*!
    \brief      HRTIMER deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_hrtimer_deinit(void)
{
    /* user code [hrtimer_deinit local 0] begin */

    /* user code [hrtimer_deinit local 0] end */

    rcu_periph_clock_disable(RCU_HRTIMER);

    hrtimer_deinit(HRTIMER0);

    /* user code [hrtimer_deinit local 1] begin */

    /* user code [hrtimer_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_10);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_10);

    gpio_af_set(GPIOB, GPIO_AF_7, GPIO_PIN_6);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_6);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_6);
    gpio_input_filter_set(GPIOB, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_6);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_receiver_timeout_disable(USART0);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_fifo_disable(USART0);
    usart_overrun_disable(USART0);
    usart_reception_error_dma_disable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_USART0);

    usart_deinit(USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
