/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include <stdio.h>
#include <string.h>

/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif

/* limit the range of data */
#define FLT_OVER_SAMPLE_32  32
#define FLT_ORDER           FLT_SINC3
#define HPDF_OUTPUT_BUFFER  2
#define HPDF_INPUT_BUFFER   ((((FLT_ORDER >> 29) * (FLT_OVER_SAMPLE_32)) + 5) * (HPDF_OUTPUT_BUFFER))

#define DATA_LIMIT(N, L, H) (((N) < (L)) ? (L) : (((N) > (H)) ? (H) : (N)))

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
__attribute__((aligned(32))) int16_t internal_data[HPDF_INPUT_BUFFER]    = {0};
__attribute__((aligned(32))) int16_t final_data[HPDF_OUTPUT_BUFFER]      = {0};
__attribute__((aligned(32))) int32_t conversion_data[HPDF_OUTPUT_BUFFER] = {0};

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint32_t i = 0;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */
    for(i = 0; i < (HPDF_INPUT_BUFFER / 2); i++) {
        internal_data[i] = -1;
    }

    for(i = (HPDF_INPUT_BUFFER / 2); i < HPDF_INPUT_BUFFER; i++) {
        internal_data[i] = 1;
    }
    /* user code [local 1] end */

    msd_gpio_init();
    msd_dma_init();
    msd_hpdf_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    printf("The HPDF test:\r\n ");

    dma_transfer_number_config(DMA0, DMA_CH0, 2);
    dma_periph_address_config(DMA0, DMA_CH0, (int32_t)&HPDF_FLTYIDATA(FLT0));
    dma_memory_address_config(DMA0, DMA_CH0, (uint32_t)conversion_data);
    dma_channel_enable(DMA0, DMA_CH0);

    for(i = 0; i < HPDF_INPUT_BUFFER; i++) {
        if(i <= (HPDF_INPUT_BUFFER / 2)) {
            hpdf_write_parallel_data_standard_mode(CHANNEL0, internal_data[i]);
        } else {
            hpdf_write_parallel_data_standard_mode(CHANNEL1, internal_data[i]);
        }
    }

    /* wait for the DMA transmit complete */
    while(RESET == dma_flag_get(DMA0, DMA_CH0, DMA_FLAG_FTF));
    printf("The range of maximum output resolution:\r\n ");

    /* get the PCM stereo data */
    for(i = 0; i < HPDF_OUTPUT_BUFFER; i++) {
        final_data[i] = DATA_LIMIT((conversion_data[i] >> 8), -32768, 32767);
        printf("%d \r\n", final_data[i]);
    }
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief retarget the C library printf function to the USART
    \param[in]  ch: The character to be transmitted via USART.
    \param[in]  f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval     The character to be transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
