/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include <stdio.h>
/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif

#define ADD_SIZE 50
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
/*
    array of input values in -32767~32768
    the data is calculated by using 'x[i]=25000*(sin(2*pi*500/16000*i)+0.2*sin(2*pi*5*500/16000*i));
    i goes from 51 to 100 the useful signal frequency is 500Hz, and the noise signal frequency is 2500Hz
*/
__attribute__((aligned(32))) __IO int16_t add_data[ADD_SIZE] = {
    -14865, -14142, -15883, -21184, -27297, -30000, -27297,
    -21184, -15883, -14142, -14865, -14186, -9035,
    0,      9035,   14186,  14865,  14142,  15883,  21184,
    27297,  30000,  27297,  21184,  15883,  14142,
    14865,  14186,  9035,   0,      -9035,  -14186,
    -14865, -14142, -15883, -21184, -27297, -30000, -27297,
    -21184, -15883, -14142, -14865, -14186, -9035,
    0,      9035,   14186,  14865,  14142,
};

/* array of calculated filtered data by mcu */
/* size = INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1 */
__attribute__((aligned(32))) __IO int16_t calculated_data[INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1] = {0};

/* array of calculated filtered data by mcu */
/* size = INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1 */
const int16_t reference_data[80] = {
    17055,  14502,  11381,  7827,   3984,   0,      -3984,  -7827,
    -11381, -14502, -17055, -18938, -20089, -20475,
    -20089, -18938, -17055, -14502, -11381, -7827,  -3984,  0,
    3984,   7827,   11381,  14502,  17055,  18938,
    20089,  20475,  20089,  18938,  17055,  14502,  11381,  7827,
    3984,   0,      -3984,  -7827,  -11381, -14502,
    -17055, -18938, -20089, -20475, -20089, -18938, -17055, -14502,
    -11381, -7827,  -3984,  0,      3984,   7827,
    11381,  14502,  17055,  18938,  20089,  20475,  20089,  18938,
    17055,  14502,  11381,  7827,   3984,   0,
    -3984,  -7827,  -11381, -14502, -17055, -18938, -20089, -20475, -20089, -18938,
};

/* array of calculated filtered data by computer */
/* size = INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1 */
__IO int16_t error[INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1];

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
static void dma_channel_address_size_config(uint32_t dma_periph, dma_channel_enum channelx, uint32_t periph_addr, \
                                            uint32_t memory_addr, uint32_t size);

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint16_t i;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_dma_init();
    msd_fac_init();
    msd_usart0_init();

    /* user code [local 2] begin */

    dma_channel_address_size_config(DMA0, DMA_CH1, (uint32_t)(&FAC_WDATA), (uint32_t)add_data, ADD_SIZE);
    dma_channel_address_size_config(DMA0, DMA_CH2, (uint32_t)(&FAC_RDATA), (uint32_t)calculated_data, 80);

    /* enable fac interrupt */
    fac_dma_enable(FAC_DMA_WRITE);
    fac_dma_enable(FAC_DMA_READ);

    /* start filter calculation */
    fac_start();

    while(RESET == dma_flag_get(DMA0, DMA_CH2, DMA_FLAG_FTF));
    /* stop calculation */
    fac_finish_calculate();

    dma_flag_clear(DMA0, DMA_CH1, DMA_FLAG_FTF);
    dma_flag_clear(DMA0, DMA_CH2, DMA_FLAG_FTF);

    /* finish calculation */
    fac_finish_calculate();
    for(i = 0; i < 80; i++) {
        error[i] = reference_data[i] - calculated_data[i];
        printf("%d\r\n", calculated_data[i]);
    }
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      configure dma info
    \param[in]  dma_periph: DMA peripheral
    \param[in]  channelx: DMA channel
    \param[in]  periph_addr: specify which DMA channel to set peripheral base address
    \param[in]  memory_addr: specify which DMA channel to set memory base address
    \param[in]  size: the size of remaining data to be transferred by the DMA
    \param[out] none
    \retval     ErrStatus : ERROR or SUCCESS
*/
static void dma_channel_address_size_config(uint32_t dma_periph, dma_channel_enum channelx, \
                                            uint32_t periph_addr, uint32_t memory_addr, uint32_t size)
{
    /* disable dma channel */
    dma_channel_disable(dma_periph, channelx);
    /* configure DMA peripheral base address */
    dma_periph_address_config(dma_periph, channelx, periph_addr);
    /* configure DMA memory base address */
    dma_memory_address_config(dma_periph, channelx, memory_addr);
    /* configure the number of remaining data to be transferred by the DMA */
    dma_transfer_number_config(dma_periph, channelx, size);

    /* enable dma channel */
    dma_channel_enable(dma_periph, channelx);
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in] ch: The character to be transmitted via USART.
    \param[in] f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval ch: The character that was transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
