/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#define Host_transmit_Device_receive      1

#define Smbus_slave_ADDR                  0x62    /* smbus slave address  */

extern hal_smbus_dev_struct i2c0_smbus_info;

uint8_t bufferrx[16] = {0,0};
uint8_t buffertx[16] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16};

static void Error_Handler(void)
{
    while(1)
    {
    }
}

void Smbus_Host_Data(void)
{
#if Host_transmit_Device_receive
    /* Send Read Command */
    if (hal_smbus_master_transmit_interrupt(&i2c0_smbus_info, buffertx, 16, NULL) != HAL_ERR_NONE)
    {
        Error_Handler();
    }
    while(i2c0_smbus_info.tx_state != HAL_SMBUS_STATE_READY);
#else
    /* Retrieve Slave Data Byte */
    if (hal_smbus_master_receive_interrupt(&i2c0_smbus_info, &bufferrx[0], 16, NULL) != HAL_ERR_NONE)
    {
        Error_Handler();
    }
    while(i2c0_smbus_info.rx_state != HAL_SMBUS_STATE_READY);
#endif
}
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */
    i2c0_smbus_info.slave_address = Smbus_slave_ADDR;
    /* user code [local 1] end */
    msd_gpio_init();
    msd_i2c0_init();

    /* user code [local 2] begin */
    i2c0_smbus_info.smbus_pec_transfer = SMBUS_PECTRANS_ENABLE;

    Smbus_Host_Data();
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */
        hals_gpio_bit_toggle(GPIOC, GPIO_PIN_10);
        hals_gpio_bit_toggle(GPIOC, GPIO_PIN_11);
        hal_sys_basetick_delay_ms(1000);
    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/* user code [global 1] end */	
