/*
    \file  gd32f3x0_hal_init.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */

/* user code [global 0] end */
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */
    /* user code [system_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_CFGCMP);
    hal_nvic_irq_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);
    hal_sys_timesource_init(SYS_TIMEBASE_SOURCE_SYSTICK);

    hal_nvic_set_priority(NonMaskableInt_IRQn, 0, 0);
    hal_nvic_set_priority(SVCall_IRQn, 0, 0);
    hal_nvic_set_priority(PendSV_IRQn, 0, 0);
    hal_nvic_set_priority(SysTick_IRQn, 0, 0);
    /* user code [system_init local 1] begin */
    /* user code [system_init local 1] end */
}

void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */
    /* user code [clock_init local 0] end */
    hal_rcu_clk_struct rcu_clk_parameter;
    hal_rcu_osci_struct rcu_osci_parameter;

    hal_rcu_struct_init(HAL_RCU_CLK_STRUCT, &rcu_clk_parameter);
    hal_rcu_struct_init(HAL_RCU_OSCI_STRUCT, &rcu_osci_parameter);

    rcu_osci_parameter.irc8m.need_configure = ENABLE;
    rcu_osci_parameter.irc8m.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.adjust_value = 0;
    /*If IRC48M is selected as USB clock source, please configure CTC calibration operation*/
    rcu_osci_parameter.irc48m.need_configure = ENABLE;
    rcu_osci_parameter.irc48m.state = RCU_OSC_ON;
    if(HAL_ERR_NONE != hal_rcu_osci_config(&rcu_osci_parameter)){
        while(1);
    }

    rcu_clk_parameter.clock_type = RCU_CLKTYPE_SYSCLK | RCU_CLKTYPE_AHBCLK | RCU_CLKTYPE_APB1CLK | RCU_CLKTYPE_APB2CLK | RCU_CLKTYPE_CK48MCLK;
    rcu_clk_parameter.sysclk_source = RCU_SYSCLK_SRC_IRC8M;
    rcu_clk_parameter.ahbclk_divider = RCU_SYSCLK_AHBDIV1;
    rcu_clk_parameter.apb1clk_divider = RCU_AHBCLK_APB1DIV1;
    rcu_clk_parameter.apb2clk_divider = RCU_AHBCLK_APB2DIV1;
    rcu_clk_parameter.ck48mclk_source = RCU_USB_CK48MSRC_IRC48M;
    if(HAL_ERR_NONE != hal_rcu_clock_config(&rcu_clk_parameter)){
        while(1);
    }

    /* user code [clock_init local 1] begin */
    /* user code [clock_init local 1] end */
}

void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */
    /* user code [gpio_init local 0] end */
    /* user code [gpio_init local 1] begin */
    /* user code [gpio_init local 1] end */
}

void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */
    /* user code [gpio_deinit local 0] end */
    /* user code [gpio_deinit local 1] begin */
    /* user code [gpio_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */
