/*
    \file  gd32c2x1_it.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_it.h"
#include "gd32c2x1.h"
#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */
#include "main.h"
/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
#define SRAM_ECC_ERROR_HANDLE(s) \
    do {                          \
    } while(1)
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
extern uint8_t spi1_send_array[ARRAYSIZE];
extern uint8_t spi0_receive_array[ARRAYSIZE];
extern volatile uint32_t send_n;
extern volatile uint32_t receive_n;
/* user code [Extern Variables] end */
/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */
    if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM two bits non-correction check error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCSE)) {
        SRAM_ECC_ERROR_HANDLE("RAM single bit correction check error\r\n");
    } else {
        /* if NMI exception occurs, go to infinite loop */
        /* HXTAL clock monitor NMI error or NMI pin error */
        while(1) {
            /* user code [NMI_IRQn local 1] begin */

            /* user code [NMI_IRQn local 1] end */
        }
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
	while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
	}
}

/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */
    while(1) {
    	/* user code [SVC_IRQn local 1] begin */

    	/* user code [SVC_IRQn local 1] end */
    }
}

/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */
    while(1) {
    	/* user code [PendSV_IRQn local 1] begin */

    	/* user code [PendSV_IRQn local 1] end */
    }
}

/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */

    /* user code [SysTick_IRQn local 0] end */

    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

/*!
    \brief      SPI0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI0_IRQHandler(void)
{
    /* user code [SPI0_IRQn local 0] begin */
    /* receive data */
    if(spi_i2s_interrupt_flag_get(SPI0, SPI_I2S_INT_FLAG_RBNE) != RESET) {
        spi0_receive_array[receive_n++] = spi_i2s_data_receive(SPI0);
#if SPI_CRC_ENABLE
        if((ARRAYSIZE - 1) == receive_n) {
            /* receive the CRC value */
            spi_crc_next(SPI0);
        }
#endif /* enable CRC function */
    }
    /* user code [SPI0_IRQn local 0] end */

    /* user code [SPI0_IRQn local 1] begin */

    /* user code [SPI0_IRQn local 1] end */
}

/*!
    \brief      SPI1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI1_IRQHandler(void)
{
    /* user code [SPI1_IRQn local 0] begin */
    if(spi_i2s_interrupt_flag_get(SPI1, SPI_I2S_INT_FLAG_TBE) != RESET) {
        /* send data */
        spi_i2s_data_transmit(SPI1, spi1_send_array[send_n++]);
        if(ARRAYSIZE == send_n) {
#if SPI_CRC_ENABLE
            /* send the CRC value */
            spi_crc_next(SPI1);
#endif /* enable CRC function */
            spi_i2s_interrupt_disable(SPI1, SPI_I2S_INT_TBE);
        }
    }
    /* user code [SPI1_IRQn local 0] end */

    /* user code [SPI1_IRQn local 1] begin */

    /* user code [SPI1_IRQn local 1] end */
}


/* user code [Global Functions Implementations] begin */

/* user code [Global Functions Implementations] end */

/* user code [Static Functions Implementations] begin */

/* user code [Static Functions Implementations] end */
