/*
    \file  gd32c2x1_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
volatile static uint32_t delay;
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);

    nvic_irq_enable(NonMaskableInt_IRQn, 0);
    nvic_irq_enable(HardFault_IRQn, 0);
    nvic_irq_enable(SVCall_IRQn, 0);
    nvic_irq_enable(PendSV_IRQn, 0);
    nvic_irq_enable(SysTick_IRQn, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_IRC48M);
    while (rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
    rcu_irc48m_adjust_value_set(16);

    fmc_wscnt_set(FMC_WAIT_STATE_1);
    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb_clock_config(RCU_APB_CKAHB_DIV1);

    rcu_irc48mdiv_sys_clock_config(RCU_IRC48MDIV_SYS_1);
    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC48MDIV_SYS);
    while (RCU_SCSS_IRC48MDIV != rcu_system_clock_source_get());

    rcu_usart_clock_config(IDX_USART0, RCU_USART0SRC_CKAPB);

    rcu_osci_on(RCU_IRC32K);
    while (rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);

    rcu_periph_clock_enable(RCU_PMU);
    pmu_backup_write_enable();
    rcu_rtc_clock_config(RCU_RTCSRC_IRC32K);

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 1000U))
    {
        /* capture error */
        while (1);
    }

    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOD);
    rcu_periph_clock_enable(RCU_GPIOA);

    gpio_bit_reset(GPIOA, GPIO_PIN_15);
    gpio_mode_set(GPIOA, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_15);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_15);

    gpio_bit_reset(GPIOD, GPIO_PIN_1);
    gpio_mode_set(GPIOD, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_1);
    gpio_output_options_set(GPIOD, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_1);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOD);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      FWDGT initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_fwdgt_init(void)
{
    /* user code [fwdgt_init local 0] begin */

    /* user code [fwdgt_init local 0] end */

    fwdgt_prescaler_value_config(FWDGT_PSC_DIV256);
    fwdgt_reload_value_config(1250);
    fwdgt_window_value_config(4095);

    /* user code [fwdgt_init local 1] begin */

    /* user code [fwdgt_init local 1] end */
}

/*!
    \brief      PMU initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_pmu_init(void)
{
    /* user code [pmu_init local 0] begin */

    /* user code [pmu_init local 0] end */

    rcu_periph_clock_enable(RCU_PMU);

    pmu_backup_write_enable();
    pmu_deepsleep_voltage_select(PMU_DSV_1);
    pmu_low_power_ldo_disable();
    pmu_eflash_wakeup_time_config(200);
    pmu_deepsleep_wait_time_config(10);
    pmu_wakeup_pin_disable(PMU_WAKEUP_PIN0);
    pmu_wakeup_pin_disable(PMU_WAKEUP_PIN1);
    pmu_wakeup_pin_disable(PMU_WAKEUP_PIN2);
    pmu_wakeup_pin_disable(PMU_WAKEUP_PIN3);
    pmu_wakeup_pin_disable(PMU_WAKEUP_PIN5);

    /* user code [pmu_init local 1] begin */
    pmu_backup_write_disable();

    /* user code [pmu_init local 1] end */
}

/*!
    \brief      PMU deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_pmu_deinit(void)
{
    /* user code [pmu_deinit local 0] begin */

    /* user code [pmu_deinit local 0] end */
    pmu_deinit();

    rcu_periph_clock_disable(RCU_PMU);

    /* user code [pmu_deinit local 1] begin */

    /* user code [pmu_deinit local 1] end */
}

/*!
    \brief      RTC initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_rtc_init(void)
{
    /* user code [rtc_init local 0] begin */

    /* user code [rtc_init local 0] end */

    rtc_parameter_struct rtc_parameter;
    rtc_alarm_struct rtc_alarm_parameter;

    rcu_periph_clock_enable(RCU_RTC);

    rtc_parameter.factor_syn = 319;
    rtc_parameter.factor_asyn = 99;
    rtc_parameter.year = 0x16;
    rtc_parameter.month = RTC_APR;
    rtc_parameter.date = 0x30;
    rtc_parameter.day_of_week = RTC_SATURDAY;
    rtc_parameter.am_pm = RTC_AM;
    rtc_parameter.display_format = RTC_24HOUR;
    rtc_parameter.second = 0x0;
    rtc_parameter.hour = 0x0;
    rtc_parameter.minute = 0x0;
    rtc_init(&rtc_parameter);

    rtc_alarm_parameter.am_pm = RTC_AM;
    rtc_alarm_parameter.alarm_hour = 0x0;
    rtc_alarm_parameter.alarm_minute = 0x0;
    rtc_alarm_parameter.alarm_second = 0x0;
    rtc_alarm_parameter.weekday_or_date = RTC_ALARM_DATE_SELECTED;
    rtc_alarm_parameter.alarm_day = 0x31;
    rtc_alarm_parameter.alarm_mask = RTC_ALARM_DATE_MASK | RTC_ALARM_HOUR_MASK | RTC_ALARM_MINUTE_MASK;
    rtc_alarm_config(&rtc_alarm_parameter);

    rtc_alarm_subsecond_config(RTC_MSKSSC_0_14, 0);
    rtc_alarm_enable();
    rtc_bypass_shadow_enable();

    nvic_irq_enable(RTC_Alarm_IRQn, 2);
    exti_init(EXTI_16, EXTI_INTERRUPT, EXTI_TRIG_RISING);

    /* user code [rtc_init local 1] begin */

    /* user code [rtc_init local 1] end */
}

/*!
    \brief      RTC deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_rtc_deinit(void)
{
    /* user code [rtc_deinit local 0] begin */

    /* user code [rtc_deinit local 0] end */

    rcu_periph_clock_disable(RCU_RTC);

    /* user code [rtc_deinit local 1] begin */

    /* user code [rtc_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_overrun_enable(USART0);
    usart_reception_error_dma_enable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */
    usart_deinit(USART0);

    rcu_periph_clock_disable(RCU_USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */
/*!
    \brief      delay a time in milliseconds
    \param[in]  count: count in milliseconds
    \param[out] none
    \retval     none
*/
void delay_1ms(uint32_t count)
{
    delay = count;
    while (0U != delay) {}
}
/*!
    \brief      delay decrement
    \param[in]  none
    \param[out] none
    \retval     none
*/
void delay_decrement(void)
{
    if (0U != delay)
    {
        delay--;
    }
}
/*!
    \brief      configure RTC alarm time
    \param[in]  none
    \param[out] none
    \retval     none
*/
void rtc_alarm_time_configuration(void)
{
    rtc_alarm_struct rtc_alarm;
    rtc_parameter_struct rtc_initpara;
    /* configure current time */
    rtc_initpara.factor_asyn = 0x63;
    rtc_initpara.factor_syn = 0x13F;
    rtc_initpara.year = 0x16;
    rtc_initpara.day_of_week = RTC_SATURDAY;
    rtc_initpara.month = RTC_APR;
    rtc_initpara.date = 0x30;
    rtc_initpara.display_format = RTC_24HOUR;
    rtc_initpara.am_pm = RTC_AM;
    rtc_initpara.hour = 0x00;
    rtc_initpara.minute = 0x00;
    rtc_initpara.second = 0x00;
    rtc_init(&rtc_initpara);
    rtc_alarm_disable();
    rtc_alarm.alarm_mask = RTC_ALARM_DATE_MASK | RTC_ALARM_HOUR_MASK | RTC_ALARM_MINUTE_MASK;
    rtc_alarm.weekday_or_date = RTC_ALARM_DATE_SELECTED;
    rtc_alarm.alarm_day = 0x31;
    rtc_alarm.am_pm = RTC_AM;
    rtc_alarm.alarm_hour = 0x00;
    rtc_alarm.alarm_minute = 0x00;
    rtc_alarm.alarm_second = ALARM_TIME_INTERVAL;
    rtc_alarm_config(&rtc_alarm);
    rtc_interrupt_enable(RTC_INT_ALARM0);
    rtc_alarm_enable();
}
/* user code [Private Functions Implementations] end */
