/*
    \file  gd32c2x1_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
volatile static uint32_t delay;
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);

    nvic_irq_enable(NonMaskableInt_IRQn, 0);
    nvic_irq_enable(HardFault_IRQn, 0);
    nvic_irq_enable(SVCall_IRQn, 0);
    nvic_irq_enable(PendSV_IRQn, 0);
    nvic_irq_enable(SysTick_IRQn, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_IRC48M);
    while (rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
    rcu_irc48m_adjust_value_set(16);

    fmc_wscnt_set(FMC_WAIT_STATE_1);
    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb_clock_config(RCU_APB_CKAHB_DIV1);

    rcu_irc48mdiv_sys_clock_config(RCU_IRC48MDIV_SYS_1);
    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC48MDIV_SYS);
    while (RCU_SCSS_IRC48MDIV != rcu_system_clock_source_get());

    rcu_usart_clock_config(IDX_USART0, RCU_USART0SRC_CKAPB);

    rcu_i2c_clock_config(IDX_I2C1, RCU_I2CSRC_CKAPB);

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 1000U))
    {
        /* capture error */
        while (1);
    }

    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      DMA initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_dma_init(void)
{
    /* user code [dma_init local 0] begin */

    /* user code [dma_init local 0] end */

    rcu_periph_clock_enable(RCU_DMA);
    rcu_periph_clock_enable(RCU_DMAMUX);

    /* user code [dma_init local 1] begin */

    /* user code [dma_init local 1] end */
}

/*!
    \brief      DMA deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_dma_deinit(void)
{
    /* user code [dma_deinit local 0] begin */

    /* user code [dma_deinit local 0] end */

    rcu_periph_clock_disable(RCU_DMA);
    rcu_periph_clock_disable(RCU_DMAMUX);

    /* user code [dma_deinit local 1] begin */

    /* user code [dma_deinit local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOD);
    rcu_periph_clock_enable(RCU_GPIOA);

    gpio_bit_reset(GPIOA, GPIO_PIN_15);
    gpio_mode_set(GPIOA, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_15);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_15);

    gpio_bit_reset(GPIOD, GPIO_PIN_1);
    gpio_mode_set(GPIOD, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_1);
    gpio_output_options_set(GPIOD, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_1);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOD);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      I2C1 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_i2c1_init(void)
{
    /* user code [i2c1_init local 0] begin */

    /* user code [i2c1_init local 0] end */

    dma_parameter_struct dma_i2c1_tx_init_p;
    dmamux_sync_parameter_struct i2c1_tx_dmamux_sync_parameter;

    rcu_periph_clock_enable(RCU_I2C1);

    gpio_af_set(GPIOA, GPIO_AF_6, GPIO_PIN_11);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_11);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_OD, GPIO_OSPEED_LEVEL_0, GPIO_PIN_11);

    gpio_af_set(GPIOA, GPIO_AF_6, GPIO_PIN_12);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_12);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_OD, GPIO_OSPEED_LEVEL_0, GPIO_PIN_12);

    i2c_digital_noise_filter_config(I2C1, FILTER_DISABLE);
    i2c_analog_noise_filter_disable(I2C1);
    i2c_timing_config(I2C1, 0x00, 0x04, 0x00);
    i2c_master_clock_config(I2C1, 0x1C, 0x55);
    i2c_stretch_scl_low_enable(I2C1);
    i2c_address_config(I2C1, 0x0, I2C_ADDFORMAT_7BITS);
    i2c_second_address_disable(I2C1);
    i2c_slave_response_to_gcall_disable(I2C1);
    i2c_enable(I2C1);

    dma_struct_para_init(&dma_i2c1_tx_init_p);
    dmamux_sync_struct_para_init(&i2c1_tx_dmamux_sync_parameter);

    dma_i2c1_tx_init_p.periph_addr = 0x00000000;
    dma_i2c1_tx_init_p.periph_width = DMA_PERIPHERAL_WIDTH_16BIT;
    dma_i2c1_tx_init_p.memory_addr = 0x00000000;
    dma_i2c1_tx_init_p.memory_width = DMA_MEMORY_WIDTH_16BIT;
    dma_i2c1_tx_init_p.number = 0;
    dma_i2c1_tx_init_p.priority = DMA_PRIORITY_HIGH;
    dma_i2c1_tx_init_p.periph_inc = DMA_PERIPH_INCREASE_DISABLE;
    dma_i2c1_tx_init_p.memory_inc = DMA_MEMORY_INCREASE_ENABLE;
    dma_i2c1_tx_init_p.direction = DMA_MEMORY_TO_PERIPHERAL;
    dma_i2c1_tx_init_p.request = DMA_REQUEST_I2C1_TX;
    dma_init(DMA_CH0, &dma_i2c1_tx_init_p);
    dma_circulation_enable(DMA_CH0);
    dma_memory_to_memory_disable(DMA_CH0);

    i2c1_tx_dmamux_sync_parameter.sync_id = DMAMUX_SYNC_EXTI0;
    i2c1_tx_dmamux_sync_parameter.sync_polarity = DMAMUX_SYNC_NO_EVENT;
    i2c1_tx_dmamux_sync_parameter.request_number = 1;
    dmamux_synchronization_init(DMAMUX_MUXCH0, &i2c1_tx_dmamux_sync_parameter);
    dmamux_synchronization_disable(DMAMUX_MUXCH0);
    dmamux_event_generation_disable(DMAMUX_MUXCH0);

    /* user code [i2c1_init local 1] begin */

    /* user code [i2c1_init local 1] end */
}

/*!
    \brief      I2C1 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_i2c1_deinit(void)
{
    /* user code [i2c1_deinit local 0] begin */

    /* user code [i2c1_deinit local 0] end */
    i2c_deinit(I2C1);

    rcu_periph_clock_disable(RCU_I2C1);

    dma_deinit(DMA_CH0);

    /* user code [i2c1_deinit local 1] begin */

    /* user code [i2c1_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    dma_parameter_struct dma_usart0_rx_init_p;
    dmamux_sync_parameter_struct usart0_rx_dmamux_sync_parameter;

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_overrun_enable(USART0);
    usart_reception_error_dma_enable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    dma_struct_para_init(&dma_usart0_rx_init_p);
    dmamux_sync_struct_para_init(&usart0_rx_dmamux_sync_parameter);

    dma_usart0_rx_init_p.periph_addr = 0x00000000;
    dma_usart0_rx_init_p.periph_width = DMA_PERIPHERAL_WIDTH_8BIT;
    dma_usart0_rx_init_p.memory_addr = 0x00000000;
    dma_usart0_rx_init_p.memory_width = DMA_MEMORY_WIDTH_8BIT;
    dma_usart0_rx_init_p.number = 0;
    dma_usart0_rx_init_p.priority = DMA_PRIORITY_HIGH;
    dma_usart0_rx_init_p.periph_inc = DMA_PERIPH_INCREASE_DISABLE;
    dma_usart0_rx_init_p.memory_inc = DMA_MEMORY_INCREASE_ENABLE;
    dma_usart0_rx_init_p.direction = DMA_PERIPHERAL_TO_MEMORY;
    dma_usart0_rx_init_p.request = DMA_REQUEST_USART0_RX;
    dma_init(DMA_CH1, &dma_usart0_rx_init_p);
    dma_circulation_enable(DMA_CH1);
    dma_memory_to_memory_disable(DMA_CH1);

    usart0_rx_dmamux_sync_parameter.sync_id = DMAMUX_SYNC_EXTI0;
    usart0_rx_dmamux_sync_parameter.sync_polarity = DMAMUX_SYNC_NO_EVENT;
    usart0_rx_dmamux_sync_parameter.request_number = 1;
    dmamux_synchronization_init(DMAMUX_MUXCH1, &usart0_rx_dmamux_sync_parameter);
    dmamux_synchronization_disable(DMAMUX_MUXCH1);
    dmamux_event_generation_disable(DMAMUX_MUXCH1);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */
    usart_deinit(USART0);

    rcu_periph_clock_disable(RCU_USART0);

    dma_deinit(DMA_CH1);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [Public Functions Implementations] begin */
/*!
    \brief      delay a time in milliseconds
    \param[in]  count: count in milliseconds
    \param[out] none
    \retval     none
*/
void delay_1ms(uint32_t count)
{
    delay = count;
    while (0U != delay) {}
}
/*!
    \brief      delay decrement
    \param[in]  none
    \param[out] none
    \retval     none
*/
void delay_decrement(void)
{
    if (0U != delay)
    {
        delay--;
    }
}
/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
