/*
    \file  gd32c2x1_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);

    nvic_irq_enable(NonMaskableInt_IRQn, 0);
    nvic_irq_enable(HardFault_IRQn, 0);
    nvic_irq_enable(SVCall_IRQn, 0);
    nvic_irq_enable(PendSV_IRQn, 0);
    nvic_irq_enable(SysTick_IRQn, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_IRC48M);
    while (rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
    rcu_irc48m_adjust_value_set(16);

    fmc_wscnt_set(FMC_WAIT_STATE_1);
    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb_clock_config(RCU_APB_CKAHB_DIV1);

    rcu_irc48mdiv_sys_clock_config(RCU_IRC48MDIV_SYS_1);
    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC48MDIV_SYS);
    while (RCU_SCSS_IRC48MDIV != rcu_system_clock_source_get());

    rcu_usart_clock_config(IDX_USART0, RCU_USART0SRC_CKAPB);

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 1000U))
    {
        /* capture error */
        while (1);
    }

    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      DMA initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_dma_init(void)
{
    /* user code [dma_init local 0] begin */

    /* user code [dma_init local 0] end */

    dma_parameter_struct dma_ch1_m2m_init_p;
    dmamux_sync_parameter_struct ch1_m2m_dmamux_sync_parameter;

    dma_parameter_struct dma_ch2_m2m_init_p;
    dmamux_sync_parameter_struct ch2_m2m_dmamux_sync_parameter;

    rcu_periph_clock_enable(RCU_DMA);
    rcu_periph_clock_enable(RCU_DMAMUX);

    dma_struct_para_init(&dma_ch1_m2m_init_p);
    dmamux_sync_struct_para_init(&ch1_m2m_dmamux_sync_parameter);

    dma_struct_para_init(&dma_ch2_m2m_init_p);
    dmamux_sync_struct_para_init(&ch2_m2m_dmamux_sync_parameter);

    dma_ch1_m2m_init_p.periph_addr = 0x00000000;
    dma_ch1_m2m_init_p.periph_width = DMA_PERIPHERAL_WIDTH_8BIT;
    dma_ch1_m2m_init_p.memory_addr = 0x00000000;
    dma_ch1_m2m_init_p.memory_width = DMA_MEMORY_WIDTH_8BIT;
    dma_ch1_m2m_init_p.number = 0;
    dma_ch1_m2m_init_p.priority = DMA_PRIORITY_ULTRA_HIGH;
    dma_ch1_m2m_init_p.periph_inc = DMA_PERIPH_INCREASE_ENABLE;
    dma_ch1_m2m_init_p.memory_inc = DMA_MEMORY_INCREASE_ENABLE;
    dma_ch1_m2m_init_p.request = DMA_REQUEST_M2M;
    dma_init(DMA_CH1, &dma_ch1_m2m_init_p);
    dma_circulation_disable(DMA_CH1);
    dma_memory_to_memory_enable(DMA_CH1);

    ch1_m2m_dmamux_sync_parameter.sync_id = DMAMUX_SYNC_EXTI0;
    ch1_m2m_dmamux_sync_parameter.sync_polarity = DMAMUX_SYNC_NO_EVENT;
    ch1_m2m_dmamux_sync_parameter.request_number = 1;
    dmamux_synchronization_init(DMAMUX_MUXCH1, &ch1_m2m_dmamux_sync_parameter);
    dmamux_synchronization_disable(DMAMUX_MUXCH1);
    dmamux_event_generation_disable(DMAMUX_MUXCH1);

    dma_ch2_m2m_init_p.periph_addr = 0x00000000;
    dma_ch2_m2m_init_p.periph_width = DMA_PERIPHERAL_WIDTH_8BIT;
    dma_ch2_m2m_init_p.memory_addr = 0x00000000;
    dma_ch2_m2m_init_p.memory_width = DMA_MEMORY_WIDTH_8BIT;
    dma_ch2_m2m_init_p.number = 0;
    dma_ch2_m2m_init_p.priority = DMA_PRIORITY_ULTRA_HIGH;
    dma_ch2_m2m_init_p.periph_inc = DMA_PERIPH_INCREASE_ENABLE;
    dma_ch2_m2m_init_p.memory_inc = DMA_MEMORY_INCREASE_ENABLE;
    dma_ch2_m2m_init_p.request = DMA_REQUEST_M2M;
    dma_init(DMA_CH2, &dma_ch2_m2m_init_p);
    dma_circulation_disable(DMA_CH2);
    dma_memory_to_memory_enable(DMA_CH2);

    ch2_m2m_dmamux_sync_parameter.sync_id = DMAMUX_SYNC_EXTI0;
    ch2_m2m_dmamux_sync_parameter.sync_polarity = DMAMUX_SYNC_NO_EVENT;
    ch2_m2m_dmamux_sync_parameter.request_number = 1;
    dmamux_synchronization_init(DMAMUX_MUXCH2, &ch2_m2m_dmamux_sync_parameter);
    dmamux_synchronization_disable(DMAMUX_MUXCH2);
    dmamux_event_generation_disable(DMAMUX_MUXCH2);

    /* user code [dma_init local 1] begin */

    /* user code [dma_init local 1] end */
}

/*!
    \brief      DMA deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_dma_deinit(void)
{
    /* user code [dma_deinit local 0] begin */

    /* user code [dma_deinit local 0] end */
    dma_deinit(DMA_CH1);

    dma_deinit(DMA_CH2);

    rcu_periph_clock_disable(RCU_DMA);
    rcu_periph_clock_disable(RCU_DMAMUX);

    /* user code [dma_deinit local 1] begin */

    /* user code [dma_deinit local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOD);
    rcu_periph_clock_enable(RCU_GPIOA);

    gpio_bit_reset(GPIOA, GPIO_PIN_15);
    gpio_mode_set(GPIOA, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_15);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_15);

    gpio_bit_reset(GPIOD, GPIO_PIN_1);
    gpio_mode_set(GPIOD, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_1);
    gpio_output_options_set(GPIOD, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_1);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOD);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */
    usart_deinit(USART0);

    rcu_periph_clock_disable(RCU_USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
