/*
    \file  gd32c2x1_it.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_it.h"
#include "gd32c2x1.h"
#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
#define SRAM_ECC_ERROR_HANDLE(s) \
    do {                          \
    } while(1)
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
extern __IO uint32_t g_transfer_complete;
/* user code [Extern Variables] end */
/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */
    if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM two bits non-correction check error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCSE)) {
        SRAM_ECC_ERROR_HANDLE("RAM single bit correction check error\r\n");
    } else {
        /* if NMI exception occurs, go to infinite loop */
        /* HXTAL clock monitor NMI error or NMI pin error */
        while(1) {
            /* user code [NMI_IRQn local 1] begin */

            /* user code [NMI_IRQn local 1] end */
        }
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
	while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
	}
}

/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */
    while(1) {
    	/* user code [SVC_IRQn local 1] begin */

    	/* user code [SVC_IRQn local 1] end */
    }
}

/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */
    while(1) {
    	/* user code [PendSV_IRQn local 1] begin */

    	/* user code [PendSV_IRQn local 1] end */
    }
}

/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */

    /* user code [SysTick_IRQn local 0] end */

    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

/*!
    \brief      EXTI0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI0_IRQHandler(void)
{
    /* user code [EXTI0_IRQn local 0] begin */
    if(RESET != exti_interrupt_flag_get(EXTI_0)) {
        exti_interrupt_flag_clear(EXTI_0);
    }
    /* user code [EXTI0_IRQn local 0] end */

    /* user code [EXTI0_IRQn local 1] begin */

    /* user code [EXTI0_IRQn local 1] end */
}

/*!
    \brief      EXTI4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI4_IRQHandler(void)
{
    /* user code [EXTI4_IRQn local 0] begin */
    if(RESET != exti_interrupt_flag_get(EXTI_4)) {
        exti_interrupt_flag_clear(EXTI_4);
    }
    /* user code [EXTI4_IRQn local 0] end */

    /* user code [EXTI4_IRQn local 1] begin */

    /* user code [EXTI4_IRQn local 1] end */
}

/*!
    \brief      DMA Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA_Channel0_IRQHandler(void)
{
    /* user code [DMA_Channel0_IRQn local 0] begin */
    if(dma_interrupt_flag_get(DMA_CH0, DMA_INT_FLAG_FTF)) {
        dma_interrupt_flag_clear(DMA_CH0, DMA_INT_FLAG_FTF);
        g_transfer_complete = 1U;
    }
    /* user code [DMA_Channel0_IRQn local 0] end */

    /* user code [DMA_Channel0_IRQn local 1] begin */

    /* user code [DMA_Channel0_IRQn local 1] end */
}

/*!
    \brief      DMAMUX Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMAMUX_IRQHandler(void)
{
    /* user code [DMAMUX_IRQn local 0] begin */
    if(dmamux_interrupt_flag_get(DMAMUX_INT_FLAG_GENCH0_TO)) {
        dmamux_interrupt_flag_clear(DMAMUX_INT_FLAG_GENCH0_TO);
    }

    if(dmamux_interrupt_flag_get(DMAMUX_INT_FLAG_MUXCH0_SO)) {
        dmamux_interrupt_flag_clear(DMAMUX_INT_FLAG_MUXCH0_SO);
    }
    /* user code [DMAMUX_IRQn local 0] end */

    /* user code [DMAMUX_IRQn local 1] begin */

    /* user code [DMAMUX_IRQn local 1] end */
}


/* user code [Global Functions Implementations] begin */

/* user code [Global Functions Implementations] end */

/* user code [Static Functions Implementations] begin */

/* user code [Static Functions Implementations] end */
