[#ftl]
/*!
    \file    hs1_usbd_conf.c
    \brief   the source file of USB device configuration

    \version 2024-09-01, V1.0.0, HAL firmware for GD32H7xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "usbd_core.h"
#include "usbd_enum.h"
#include "drv_usb_core.h"
#include "hs1_audio_core.h"

extern usb_core_driver hs1_usbd_core;

void hs1_usbd_fifo_size_init(usb_core_regs *usb_regs);
void hs1_usbd_basic_parameter_init(usb_core_basic *usb_basic);

/*!
    \brief      configure USBFS device initialization
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usbhs1_device_init(void)
{
${mwGetCode}

[#if USBHS1_USB1Type != "Disable" && GeneralConfiguration_Speed == "Full Speed"]
    hs1_usb_para_init(&hs1_usbd_core, USBHS1, USB_SPEED_FULL);
[#elseif USBHS1_USB1Type != "Disable" && GeneralConfiguration_Speed == "High Speed"]
    hs1_usb_para_init(&hs1_usbd_core, USBHS1, USB_SPEED_HIGH);
[#elseif USBHS1_USB1Type != "Disable" && GeneralConfiguration_Speed == "Low Speed"]
    hs1_usb_para_init(&hs1_usbd_core, USBHS1, USB_SPEED_LOW);
[/#if]

    hs1_usbd_basic_parameter_init(&hs1_usbd_core.bp);

    hs1_usbd_init (&hs1_usbd_core, &hs1_audio_desc, &hs1_usbd_audio_cb);

    hs1_usbd_fifo_size_init(&hs1_usbd_core.regs);
}

/*!
    \brief      configure USB basic parameter
    \param[in]  usb_basic: pointer to USB capabilities
    \param[out] none
    \retval     none
*/
void hs1_usbd_basic_parameter_init(usb_core_basic *usb_basic)
{
[#if GeneralConfiguration_Speed == "Full Speed"]
    usb_basic->core_speed = (uint8_t)USB_SPEED_FULL;
[#elseif GeneralConfiguration_Speed == "High Speed"]
    usb_basic->core_speed = (uint8_t)USB_SPEED_HIGH;
[#elseif GeneralConfiguration_Speed == "High Speed"]
    usb_basic->core_speed = (uint8_t)USB_SPEED_LOW;
[/#if]
    usb_basic->sof_enable = HS1_USB_SOF_OUTPUT;
    usb_basic->low_power = HS1_USB_LOW_POWER;
    usb_basic->lpm_enable = HS1_LPM_ENABLE;
    usb_basic->vbus_sensing_enable = HS1_VBUS_SENSING;
}

/*!
    \brief      configure  endpoint FIFO size
    \param[in]  usb_regs: USB core registers
    \param[out] none
    \retval     none
*/
void hs1_usbd_fifo_size_init(usb_core_regs *usb_regs)
{
    usb_set_rxfifo(usb_regs, HS1_RX_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 0, HS1_TX0_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 1, HS1_TX1_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 2, HS1_TX2_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 3, HS1_TX3_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 4, HS1_TX4_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 5, HS1_TX5_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 6, HS1_TX6_FIFO_SIZE);
    usb_set_txfifo(usb_regs, 7, HS1_TX7_FIFO_SIZE);
}

#ifndef HS0_DEFINITION_COMPLETE
/*!
    \brief      delay in milli seconds
    \param[in]  msec: value of delay required in milli seconds
    \param[out] none
    \retval     none
*/
void usb_mdelay(const uint32_t msec)
{
    hal_sys_basetick_delay_ms(msec);
}

#endif /* HS0_DEFINITION_COMPLETE */
