/*!
    \file    inter_flash_if.h
    \brief   USB DFU device flash interface header file

    \version 2024-09-01, V1.0.0, HAL firmware for GD32H7xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __INTER_FLASH_IF_H
#define __INTER_FLASH_IF_H

#include "dfu_mal.h"

#define HS1_FLASH_START_ADDR        0x08000000U
#define HS1_FLASH_END_ADDR          0x087FFFFFU

#define HS1_FMC_OB_START            (FMC_BASE + 0x1C)
#define HS1_FMC_OB_END              (FMC_BASE + 0x57)

#define HS1_OCRAM_START             0x24010000U
#define HS1_OCRAM_END               0x2407FFFFU

#define HS1_EFUSE_START             0x40022814U
#define HS1_EFUSE_END               0x40022843U
#define HS1_EFUSE_LEN               0x30U

#define HS1_AES_IV_START            0x52002068U
#define HS1_AES_IV_END              0x52002080U
#define HS1_AES_IV_LEN              0x18U

#define HS1_OB_RDPT0                0x1FFFC000U
#define HS1_OB_RDPT1                0x1FFEC000U

#define HS1_OB_RDPT                 0x1ffff800U

#define HS1_MAL_MASK_OB             0xFFFFFF00U

#define HS1_FLASH_IF_STRING         "@Internal Flash   /0x08000000/16*002Ka,112*002Kg"

extern dfu_mal_prop HS1_DFU_Flash_cb;

/* function declarations */
/* write the option byte */
hal_fmc_state_enum hs1_option_byte_write(uint32_t Mem_Add,uint8_t* data);

#endif /* __INTER_FLASH_IF_H */
