[#ftl]
[#-- V1.2.1 --]
/*!
    \file    lwipopts.h
    \brief   LwIP options configuration

    \version 2025-09-30, V1.0.0, HAL firmware for GD32H7xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef LWIPOPTS_H
#define LWIPOPTS_H

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Shared Macros */
[#if Peripherals?contains("ENET0") == true && Peripherals?contains("ENET1") == true]
extern struct netif *gd_ip4_route_src(const void *src, const void *dest);
#define LWIP_HOOK_IP4_ROUTE_SRC(src, dest) gd_ip4_route_src(src, dest)
[/#if]

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTimer == "Enable"]
#define TIMEOUT_CHECK_USE_LWIP
[/#if]

[#if LWIP_LWIPEnable_TRUELWIPInformation_LWIPDependencyFreeRTOS == "Disable"]
/* NO_SYS==1: provides VERY minimal functionality.Otherwise, use lwIP facilities */
#define NO_SYS                          1
[#else]
/* NO_SYS==1: provides VERY minimal functionality.Otherwise, use lwIP facilities */
#define NO_SYS                          0
[/#if]

/* SYS_LIGHTWEIGHT_PROT==1: if you want inter-task protection
   for certain critical regions during buffer allocation,
   deallocation and memory allocation and deallocation */
#define SYS_LIGHTWEIGHT_PROT            0

/*  memory parameter  */
/* should be set to the alignment of the CPU for which lwIP is compiled.
   4 byte alignment -> define MEM_ALIGNMENT to 4, 2 byte alignment -> define MEM_ALIGNMENT to 2 */
#define MEM_ALIGNMENT                   ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_LWIPMemoryAlignment}

/* the size of the heap memory, if the application will send a lot of data
   that needs to be copied, this should be set high */
#define MEM_SIZE                        ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_HeapMemorySize}

/* Relocate the LwIP RAM heap pointer */
#define LWIP_RAM_HEAP_POINTER           ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_RAMHeapPointer}

/* memory map parameter */
/* the number of memp struct pbufs. If the application sends a lot of data
   out of ROM (or other static memory), this should be set high */
#define MEMP_NUM_PBUF                   ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_NumberOfMempStructPbufs}

/* the number of struct netbufs */
#define MEMP_NUM_NETBUF                 ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_NumberOfMempStructNetbufs}
/* the number of Simultaneously active timeouts */
#define MEMP_NUM_SYS_TIMEOUT            ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_NumberOfSimultaneouslyActiveTimeouts}
/* the number of UDP protocol control blocks, one per active UDP "connection */
#define MEMP_NUM_UDP_PCB                ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_NumberOfUDPProtocolControlBlocks}

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTCP == "Enable"]
/* the number of simulatenously active TCP connections */
#define MEMP_NUM_TCP_PCB                ${LWIP_LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_NumberOfSimultaneouslyActiveTCPConnections}
[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPUDP == "Enable"]
/* the number of simultaneously queued TCP segments */
#define MEMP_NUM_TCP_SEG                ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_NumberOfSimultaneouslyQueuedTCPSegments}
[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTCP == "Enable"]
/* the number of listening TCP connections */
#define MEMP_NUM_TCP_PCB_LISTEN         ${LWIP_LWIPEnable_TRUELWIPMemoryConfiguration_NumberOfListeningTCPConnections}
[/#if]

/* Pbuf options */
/* the number of buffers in the pbuf pool */
#define PBUF_POOL_SIZE                  ${LWIP_LWIPEnable_TRUELWIPParametersConfiguration_NumberOfBuffersInPbufPool}
/* the size of each pbuf in the pbuf pool */
#define PBUF_POOL_BUFSIZE               ${LWIP_LWIPEnable_TRUELWIPParametersConfiguration_BuffersSizeInPbufPool}

/* Enable some protocols to test them */
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Enable"]
/* define to 1 if you want DHCP configuration of interfaces, DHCP is not implemented in lwIP 0.5.1.
   however, so turning this on does currently not work. */
#define LWIP_DHCP                       1
[#else]
/* define to 0 if you do not want DHCP configuration of interfaces. */
#define LWIP_DHCP                       0

[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPICMP == "Enable"]
#define LWIP_ICMP                       1
[#else]
#define LWIP_ICMP                       0
[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTCP == "Enable"]
#define LWIP_TCP                        1
[#else]
#define LWIP_TCP                        0
[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPUDP == "Enable"]
#define LWIP_UDP                        1
[#else]
#define LWIP_UDP                        0
[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDNS == "Enable"]
#define LWIP_DNS                        1
#define LWIP_RAND()                     ((u32_t)rand())
[#else]
#define LWIP_DNS                        0
[/#if]

/* tcp paramter */
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTCP == "Enable"]
/* The maximum number of network segments that an IP packet can pass through before being discarded by the router */
#define TCP_TTL                         ${LWIP_LWIPEnable_TRUETCPParameterConfiguration_TCPTimeToLive}

[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTCP == "Enable"]
[#if LWIP_LWIPEnable_TRUETCPParameterConfiguration_TCPQueueSegmentsThatArriveOutOfOrder == "Enable"]
/* controls if TCP should queue segments that arrive out of order,
   Define to 0 if your device is low on memory. */
#define TCP_QUEUE_OOSEQ                 1
[#else]
/* controls if TCP should queue segments that arrive out of order,
   Define to 0 if your device is low on memory. */
#define TCP_QUEUE_OOSEQ                 0
[/#if]
[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPUDP == "Enable"]
/* TCP Maximum segment size, TCP_MSS = (Ethernet MTU - IP header size - TCP header size) */
#define TCP_MSS                         ${LWIP_LWIPEnable_TRUETCPParameterConfiguration_TCPMaximumSegmentSize}

[/#if]
/* TCP sender buffer space (bytes) */
#define TCP_SND_BUF                     ${LWIP_LWIPEnable_TRUETCPParameterConfiguration_TCPSenderBufferSpace}

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTCP == "Enable"]
/* TCP receive window */
#define TCP_WND                         ${LWIP_LWIPEnable_TRUETCPParameterConfiguration_TCPReceiveWindow}
[/#if]

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPTCP == "Enable"]
/* TCP sender buffer space (pbufs), this must be at least as much as (2 * TCP_SND_BUF/TCP_MSS) for things to work */
#define TCP_SND_QUEUELEN                ${LWIP_LWIPEnable_TRUETCPParameterConfiguration_TCPSenderQueueLength}

[/#if]
#define LWIP_NETIF_STATUS_CALLBACK      1

/* udp parameter */
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPUDP == "Enable"]
/* The maximum number of network segments that an UDP packet can pass through before being discarded by the router */
#define UDP_TTL                         ${LWIP_LWIPEnable_TRUEUDPParameterConfiguration_UDPTimeToLive}
[/#if]

/* statistics options */
#define LWIP_STATS                      0

/* Lwip debug options */
#define LWIP_DEBUG                      1

/* sequential layer options */
[#if LWIP_LWIPEnable_TRUELWIPParametersConfiguration_UseNetconns == "Enable"]
/* set to 1 to enable netconn API (require to use api_lib.c) */
#define LWIP_NETCONN                    1
[#else]
/* set to 0 to disable netconn API (require to use api_lib.c) */
#define LWIP_NETCONN                    0
[/#if]

[#if LWIP_LWIPEnable_TRUELWIPParametersConfiguration_UseNetconns == "Enable"]
/* the number of struct netconns */
#define MEMP_NUM_NETCONN                ${LWIP_LWIPEnable_TRUELWIPParametersConfiguration_NumberOfNetconns}
[/#if]

/* socket options */
[#if LWIP_LWIPEnable_TRUELWIPParametersConfiguration_UseSOCKET == "Enable"]
/* set to 1 to enable socket API (require to use sockets.c) */
#define LWIP_SOCKET                     1
[#else]
/* set to 1 to enable socket API (require to use sockets.c) */
#define LWIP_SOCKET                     0
[/#if]
/* set to 1 to enable receive timeout for sockets/netconns and SO_RCVTIMEO processing */
#define LWIP_SO_RCVTIMEO                1

[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumByHardware == "Enable"]
/* checksum options */
/* computing and verifying the IP, UDP, TCP and ICMP checksums by hardware */
#define CHECKSUM_BY_HARDWARE

/* CHECKSUM_GEN_IP==0: generate checksums by hardware for outgoing IP packets.*/
#define CHECKSUM_GEN_IP                 0
/* CHECKSUM_GEN_UDP==0: generate checksums by hardware for outgoing UDP packets.*/
#define CHECKSUM_GEN_UDP                0
/* CHECKSUM_GEN_TCP==0: generate checksums by hardware for outgoing TCP packets.*/
#define CHECKSUM_GEN_TCP                0
/* CHECKSUM_CHECK_IP==0: check checksums by hardware for incoming IP packets.*/
#define CHECKSUM_CHECK_IP               0
/* CHECKSUM_CHECK_UDP==0: check checksums by hardware for incoming UDP packets.*/
#define CHECKSUM_CHECK_UDP              0
/* CHECKSUM_CHECK_TCP==0: check checksums by hardware for incoming TCP packets.*/
#define CHECKSUM_CHECK_TCP              0
#define CHECKSUM_GEN_ICMP               0
[#else]
/* CHECKSUM_GEN_IP==1: generate checksums in software for outgoing IP packets.*/
[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumBySoftwareForOutputIPPackets == "Enable"]
#define CHECKSUM_GEN_IP                 1
[#else]
#define CHECKSUM_GEN_IP                 0
[/#if]

/* CHECKSUM_GEN_UDP==1: generate checksums in software for outgoing UDP packets.*/
[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumBySoftwareForOutputUDPPackets == "Enable"]
#define CHECKSUM_GEN_UDP                1
[#else]
#define CHECKSUM_GEN_UDP                0
[/#if]

/* CHECKSUM_GEN_TCP==1: generate checksums in software for outgoing TCP packets.*/
[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumBySoftwareForOutputTCPPackets == "Enable"]
#define CHECKSUM_GEN_TCP                1
[#else]
#define CHECKSUM_GEN_TCP                0
[/#if]

/* CHECKSUM_CHECK_IP==1: check checksums in software for incoming IP packets.*/
[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumBySoftwareForInputIPPackets == "Enable"]
#define CHECKSUM_CHECK_IP               1
[#else]
#define CHECKSUM_CHECK_IP               0
[/#if]

/* CHECKSUM_CHECK_UDP==1: check checksums in software for incoming UDP packets.*/
[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumBySoftwareForInputUDPPackets == "Enable"]
#define CHECKSUM_CHECK_UDP              1
[#else]
#define CHECKSUM_CHECK_UDP              0
[/#if]

/* CHECKSUM_CHECK_TCP==1: check checksums in software for incoming TCP packets.*/
[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumBySoftwareForInputTCPPackets == "Enable"]
#define CHECKSUM_CHECK_TCP              1
[#else]
#define CHECKSUM_CHECK_TCP              0
[/#if]

/* CHECKSUM_GEN_ICMP==1: check checksums in software for incoming ICMP packets.*/
[#if LWIP_LWIPEnable_TRUELWIPChecksumConfiguration_ChecksumBySoftwareForOutputICMPPackets == "Enable"]
#define CHECKSUM_GEN_ICMP               1
[#else]
#define CHECKSUM_GEN_ICMP               0
[/#if]
[/#if]

/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants  */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#endif /* LWIPOPTS_H */
