[#ftl]
/*!
    \file    fs_usbh_usr.c
    \brief   some user routines

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include <string.h>
#include "fs_usbh_usr.h"
#include "drv_usb_hw.h"
#include "usbh_msc_core.h"
#include "usbh_msc_scsi.h"
#include "usbh_msc_bbb.h"
#include "ff.h"

/* External Includes*/
/* user code [External Includes] begin */
extern usb_core_driver fs_usbh_core;
extern fs_usbh_host fs_usb_host;
/* user code [External Includes] end */
/* Private Type Definitions */
/* user code [Private Type Definitions] begin */
FATFS fatfs;
FIL file;

__ALIGN_BEGIN char ReadTextBuff[100] __ALIGN_END;
__ALIGN_BEGIN char WriteTextBuff[] __ALIGN_END = "GD32 USB Host Demo application using FAT_FS   ";
uint16_t bytesWritten, bytesToWrite, bytesRead;

uint8_t line_idx;
uint8_t fs_usbh_usr_application_state = FS_USBH_USR_FS_INIT;
/* user code [Private Type Definitions] end */

/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/* user code [Private Function Declaration] begin */
/* local function prototypes ('static') */
static uint8_t explore_disk(char *path, uint8_t recu_level);
/* user code [Private Function Declaration] end */

/*  points to the USBH_USER_CB structure of current device */
usbh_user_cb fs_usr_cb =
{
    fs_usbh_user_init,
    fs_usbh_user_deinit,
    fs_usbh_user_device_connected,
    fs_usbh_user_device_reset,
    fs_usbh_user_device_disconnected,
    fs_usbh_user_over_current_detected,
    fs_usbh_user_device_speed_detected,
    fs_usbh_user_device_desc_available,
    fs_usbh_user_device_address_assigned,
    fs_usbh_user_configuration_descavailable,
    fs_usbh_user_manufacturer_string,
    fs_usbh_user_product_string,
    fs_usbh_user_serialnum_string,
    fs_usbh_user_enumeration_finish,
    fs_usbh_user_userinput,
    fs_usbh_user_msc_application,
    fs_usbh_user_device_not_supported,
    fs_usbh_user_unrecovered_error
};

const uint8_t FS_MSG_HOST_HEADER[] = "USBFS MSC Host";
const uint8_t FS_MSG_HOST_FOOTER[] = "USB Host Library v3.0.0";

/*!
    \brief      user operation for host-mode initialization
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_init(void)
{
    static uint8_t startup = 0U;
    /* user code [fs_usbh_user_init local 0] begin */

    /* user code [fs_usbh_user_init local 0] end */
    if(0U == startup) {
        startup = 1U;
        /* user code [fs_usbh_user_init local 1] begin */
        User_Debug_Log("> USB host library started \r\n");
        /* user code [fs_usbh_user_init local 1] end */
        
    }
    /* user code [fs_usbh_user_init local 2] begin */

    /* user code [fs_usbh_user_init local 2] end */
}

/*!
    \brief      deinit user state and associated variables
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_deinit(void)
{
    /* user code [fs_usbh_user_deinit local 0] begin */
    fs_usbh_usr_application_state = FS_USBH_USR_FS_INIT;
    /* user code [fs_usbh_user_deinit local 0] end */
}

/*!
    \brief      user operation for device attached
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_device_connected(void)
{
    /* user code [fs_usbh_user_device_connected local 0] begin */
    User_Debug_Log("> Device Attached.\r\n");
    /* user code [fs_usbh_user_device_connected local 0] end */
}

/*!
    \brief      user operation for unrecovered error happens
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_unrecovered_error(void)
{
    /* user code [fs_usbh_user_unrecovered_error local 0] begin */
    User_Debug_Log("> Unrecovered Error State.\r\n");
    /* user code [fs_usbh_user_unrecovered_error local 0] end */
}

/*!
    \brief      user operation for device disconnect event
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_device_disconnected(void)
{
    /* user code [fs_usbh_user_device_disconnected local 0] begin */
    User_Debug_Log("> Device Disconnected.\r\n");
    /* user code [fs_usbh_user_device_disconnected local 0] end */
}

/*!
    \brief      user operation for reset USB Device
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_device_reset(void)
{
    /* user code [fs_usbh_user_device_reset local 0] begin */
    /* users can do their application actions here for the USB-Reset */
    User_Debug_Log("> Reset the USB device.\r\n");
    /* user code [fs_usbh_user_device_reset local 0] end */
}

/*!
    \brief      user operation for detecting device speed
    \param[in]  DeviceSpeed: device speed
    \param[out] none
    \retval     none
*/
void fs_usbh_user_device_speed_detected(uint32_t device_speed)
{
    /* user code [fs_usbh_user_device_speed_detected local 0] begin */
    if (PORT_SPEED_HIGH == device_speed) {
        User_Debug_Log("> High speed device detected.\r\n");
    } else if(PORT_SPEED_FULL == device_speed) {
        User_Debug_Log("> Full speed device detected.\r\n");
    } else if(PORT_SPEED_LOW == device_speed) {
        User_Debug_Log("> Low speed device detected.\r\n");
    } else {
        User_Debug_Log("> Device Fault.\r\n");
    }
    /* user code [fs_usbh_user_device_speed_detected local 0] end */

}

/*!
    \brief      user operation when device descriptor is available
    \param[in]  device_desc: device descriptor
    \param[out] none
    \retval     none
*/
void fs_usbh_user_device_desc_available(void *device_desc)
{
    usb_desc_dev *pDevStr = device_desc;
    /* user code [fs_usbh_user_device_desc_available local 0] begin */
    User_Debug_Log("> VID: %04Xh \r\n", (uint32_t)pDevStr->idVendor);
    User_Debug_Log("> PID: %04Xh \r\n", (uint32_t)pDevStr->idProduct);
    /* user code [fs_usbh_user_device_desc_available local 0] end */
}

/*!
    \brief      USB device is successfully assigned the address
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_device_address_assigned(void)
{
    /* user code [fs_usbh_user_device_address_assigned local 0] begin */

    /* user code [fs_usbh_user_device_address_assigned local 0] end */
}

/*!
    \brief      user operation when configuration descriptor is available
    \param[in]  cfg_desc: pointer to configuration descriptor
    \param[in]  itf_desc: pointer to interface descriptor
    \param[in]  ep_desc: pointer to endpoint descriptor
    \param[out] none
    \retval     none
*/
void fs_usbh_user_configuration_descavailable(usb_desc_config *cfg_desc,
  											   usb_desc_itf *itf_desc,
                                               usb_desc_ep *ep_desc)
{
    usb_desc_itf *id = itf_desc;
    /* user code [fs_usbh_user_configuration_descavailable local 0] begin */
    if (0x08U == (*id).bInterfaceClass) {
        User_Debug_Log("> Mass storage device connected.\r\n");
    } else if (0x03U == (*id).bInterfaceClass) {
        User_Debug_Log("> HID device connected.\r\n");
    }
    /* user code [fs_usbh_user_configuration_descavailable local 0] end */
}

/*!
    \brief      user operation when manufacturer string exists
    \param[in]  manufacturer_string: manufacturer string of usb device
    \param[out] none
    \retval     none
*/
void fs_usbh_user_manufacturer_string(void *manufacturer_string)
{
    /* user code [fs_usbh_user_manufacturer_string local 0] begin */
    User_Debug_Log("> Manufacturer: %s\r\n", (char *)manufacturer_string);
    /* user code [fs_usbh_user_manufacturer_string local 0] end */
}

/*!
    \brief      user operation when manufacturer string exists
    \param[in]  product_string: product string of usb device
    \param[out] none
    \retval     none
*/
void fs_usbh_user_product_string(void *product_string)
{
    /* user code [fs_usbh_user_product_string local 0] begin */
    User_Debug_Log("> Product: %s\r\n", (char *)product_string);
    /* user code [fs_usbh_user_product_string local 0] end */
}

/*!
    \brief      user operation when serialnum string exists
    \param[in]  serial_num_string: serialNum string of usb device
    \param[out] none
    \retval     none
*/
void fs_usbh_user_serialnum_string(void *serial_num_string)
{
    /* user code [fs_usbh_user_serialnum_string local 0] begin */
    User_Debug_Log("> Serial Number: %s\r\n", (char *)serial_num_string);
    /* user code [fs_usbh_user_serialnum_string local 0] end */
}

/*!
    \brief      user response request is displayed to ask for application jump to class
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_enumeration_finish(void)
{
    /* user code [fs_usbh_user_enumeration_finish local 0] begin */
    User_Debug_Log("> Enumeration completed.\r\n");
    User_Debug_Log("> ----------------------\r\n");
    User_Debug_Log("> To start the HID class operations: \r\n");
    /* user code [fs_usbh_user_enumeration_finish local 0] end */
}

/*!
    \brief      user operation when device is not supported
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_device_not_supported(void)
{
    /* user code [fs_usbh_user_device_not_supported local 0] begin */
    User_Debug_Log("> Device not supported.\r\n");
    /* user code [fs_usbh_user_device_not_supported local 0] end */
}

/*!
    \brief      user action for application state entry
    \param[in]  none
    \param[out] none
    \retval     user response for user key
*/
usbh_user_status fs_usbh_user_userinput(void)
{
    usbh_user_status usbh_usr_status = USR_IN_NO_RESP;

    /* user code [fs_usbh_user_userinput local 0] begin */
    usbh_usr_status = USR_IN_RESP_OK;
    /* user code [fs_usbh_user_userinput local 0] end */

    return usbh_usr_status;
}

/*!
    \brief      user action for device overcurrent detection event
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_usbh_user_over_current_detected(void)
{
    /* user code [fs_usbh_user_over_current_detected local 0] begin */
    User_Debug_Log("> Overcurrent detected.\r\n");
    /* user code [fs_usbh_user_over_current_detected local 0] end */
}

/*!
    \brief      demo application for mass storage
    \param[in]  pudev: pointer to device
    \param[in]  id: no use here
    \param[out] none
    \retval     status
*/
int fs_usbh_user_msc_application(void)
{
    /* user code [fs_usbh_user_msc_application local 0] begin */
    FRESULT res;
    msc_lun info;
    uint8_t WriteTextBuff[] = "GD32 Connectivity line Host Demo application using FAT_FS   ";
    uint16_t bytesWritten, bytesToWrite;

    switch(fs_usbh_usr_application_state) {
    case FS_USBH_USR_FS_INIT:
        /* initializes the file system*/
        if(FR_OK != f_mount(&fatfs, "0:/", 0)) {
            User_Debug_Log("> Cannot initialize File System.\r\n");

            return(-1);
        }

        User_Debug_Log("> File System initialized.\r\n");
        if(USBH_OK == fs_usbh_msc_lun_info_get(&fs_usb_host, 0, &info)) {
            User_Debug_Log("> Disk capacity: %ud Bytes.\r\n", info.capacity.block_nbr * info.capacity.block_size);
        }

        fs_usbh_usr_application_state = FS_USBH_USR_FS_READLIST;
        break;

    case FS_USBH_USR_FS_READLIST:
        User_Debug_Log("> Exploring disk flash ...\r\n");
        User_Debug_Log("> To see the root content of disk \r\n");
        usb_mdelay(100);

        explore_disk("0:/", 1);
        line_idx = 0;
        fs_usbh_usr_application_state = FS_USBH_USR_FS_WRITEFILE;
        break;

    case FS_USBH_USR_FS_WRITEFILE:
        usb_mdelay(100);

        User_Debug_Log("-------------------------------\r\n");
        User_Debug_Log("> Writing File to disk flash...\r\n");

        /* register work area for logical drives */
        f_mount(&fatfs, "0:/", 1);

        if(FR_OK == f_open(&file, "0:GD32.TXT", FA_CREATE_ALWAYS | FA_WRITE)) {
            /* write buffer to file */
            bytesToWrite = sizeof(WriteTextBuff);
            res = f_write(&file, WriteTextBuff, bytesToWrite, (void *)&bytesWritten);
            /* EOF or error */
            if((0U == bytesWritten) || (FR_OK != res)) {
                User_Debug_Log("> GD32.TXT C be written.\r\n");
            } else {
                User_Debug_Log("> GD32.TXT created in the disk.\r\n");
            }

            /* close file and filesystem */
            f_close(&file);
            f_mount(NULL, "0:/", 1);
        } else {
            User_Debug_Log("> GD32.TXT created in the disk.\r\n");
        }

        fs_usbh_usr_application_state = FS_USBH_USR_FS_DEMOEND;
        User_Debug_Log("> The MSC host demo is end.\r\n");
        break;

    case FS_USBH_USR_FS_DEMOEND:
        break;

    default:
        break;
    }
    /* user code [fs_usbh_user_msc_application local 0] end */  

    return(0);
}

/* user code [Private Function Implementations] begin */
/*!
    \brief      displays disk content
    \param[in]  path: pointer to root path
    \param[in]  recu_level: recursive level
    \param[out] none
    \retval     status
*/
static uint8_t explore_disk(char *path, uint8_t recu_level)
{
    FRESULT res;
    FILINFO fno;
    DIR dir;
    char *fn;

    res = f_opendir(&dir, path);

    if(FR_OK == res) {
        while((fs_usbh_core.host.connect_status)) {
            res = f_readdir(&dir, &fno);
            if(FR_OK != res || 0U == fno.fname[0]) {
                break;
            }

            if('.' == fno.fname[0]) {
                continue;
            }

            fn = fno.fname;

            line_idx++;

            if(line_idx > 4U) {
                line_idx = 0U;

                User_Debug_Log("                             \r\n");
            }

            if(1U == recu_level) {
                User_Debug_Log(">    |__ \r\n");
            } else if(2U == recu_level) {
                User_Debug_Log(">    |   |__ \r\n");
            }

            if(AM_DIR == fno.fattrib) {
                User_Debug_Log("%s\r\n", fno.fname);
            } else {
                User_Debug_Log("%s\r\n", fno.fname);
            }

            if((AM_DIR == fno.fattrib) && (1U == recu_level)) {
                explore_disk(fn, 2);
            }
        }
    }

    return res;
}
/* user code [Private Function Implementations] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */