[#ftl]
/*!
    \file    hs_usbh_conf.h
    \brief   USB host driver configuration

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS_USBH_CONF_H
#define __HS_USBH_CONF_H

#include "hs_usb_conf.h"
#include "gd32f527_init.h"

extern uint32_t hs_usbh_irq (void);
extern void hs_usbhs_wakeup_irq(void);

#define HS_HOST_MAX_EP_NUM                         ${USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumEndpointNumber}
#define HS_HOST_MAX_INTERFACES_NUM                 ${USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumInterfaceNumber}
#define HS_HOST_MAX_ALT_SETTING                    ${USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumAlternateSetting}
#define HS_HOST_MAX_SUPPORTED_CLASS                ${USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumSupportedClass}

[#if USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostConfigureDescriptorKeep == "Enable"]
#define HS_HOST_CFG_DESC_KEEP                      ENABLE
[#else]
#define HS_HOST_CFG_DESC_KEEP                      DISABLE
[/#if]
#define HS_HOST_DATA_BUF_MAX_LEN                   ${USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostDataBufferMaximumLength}
#define HS_HOST_CFGSET_MAX_LEN                     ${USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostConfigureSetMaximumLength}
[#if USBHS_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostUserDebugLog == "Enable"]
#define HS_HOST_USER_DEBUG_LOG                     ENABLE
[#else]
#define HS_HOST_USER_DEBUG_LOG                     DISABLE
[/#if]

[#if USBHS_USBHSHost_SOFSignalOutput ??==true]
[#if USBHS_USBHSHost_SOFSignalOutput == "Enable"]
#define HS_USB_SOF_OUTPUT                          ENABLE
[#elseif USBHS_USBHSHost_SOFSignalOutput == "Disable"]
#define HS_USB_SOF_OUTPUT                          DISABLE
[/#if]
[/#if]
[#if USBHS_USBHSDevice_LowPowerMode ??==true]
[#if USBHS_USBHSDevice_LowPowerMode == "Enable"]
#define HS_USB_LOW_POWER                           ENABLE
[#else]
#define HS_USB_LOW_POWER                           DISABLE
[/#if]
[/#if]

[#if USBHS_HostFIFOSize_AllocatedRXFIFOSize ??==true]
#define HS_RX_FIFO_SIZE                            ${USBHS_HostFIFOSize_AllocatedRXFIFOSize}
[#else]
#define HS_RX_FIFO_SIZE                            512
[/#if]
[#if USBHS_HostFIFOSize_AllocatedPeriodicTXFIFOSize ??==true]
#define HS_USB_HTX_PFIFO_SIZE                      ${USBHS_HostFIFOSize_AllocatedPeriodicTXFIFOSize}
[#else]
#define HS_USB_HTX_PFIFO_SIZE                      256
[/#if]
[#if USBHS_HostFIFOSize_AllocatedNonperiodicTXFIFOSize ??==true]
#define HS_USB_HTX_NPFIFO_SIZE                     ${USBHS_HostFIFOSize_AllocatedNonperiodicTXFIFOSize}
[#else]
#define HS_USB_HTX_NPFIFO_SIZE                     256
[/#if]

[#if USBHS_GeneralConfiguration_InternalDMA ??== true && USBHS_GeneralConfiguration_InternalDMA == "Enable"]
#define HS_USB_INTERNAL_DMA_ENABLED
[/#if]

#if (ENABLE == HS_HOST_USER_DEBUG_LOG)
#define User_Debug_Log(...) do { \
                                 \
                                 printf(__VA_ARGS__);\
                               } while (0)
#else
#define User_Debug_Log(...) do {} while (0)
#endif

void msd_usbhs_host_init(void);

#endif /* __HS_USBH_CONF_H */
