[#ftl]
[#-- V1.1 --]
/*
 * FREERTOS Kernel V11.1.0
 * Copyright (C) 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * https://www.FREERTOS.org
 * https://github.com/FREERTOS
 *
 */

/*******************************************************************************
 * This file provides an example FREERTOSConfig.h header file, inclusive of an
 * abbreviated explanation of each configuration item.  Online and reference
 * documentation provides more information.
 * https://www.freertos.org/a00110.html
 *
 * Constant values enclosed in square brackets ('[' and ']') must be completed
 * before this file will build.
 *
 * Use the FREERTOSConfig.h supplied with the RTOS port in use rather than this
 * generic file, if one is available.
 ******************************************************************************/

#ifndef FREERTOS_CONFIG_H
#define FREERTOS_CONFIG_H

/* External Includes*/
#if  defined(__ICCARM__) || defined(__CC_ARM) || defined(__TASKING__) || defined(__GNUC__)
#include <stdint.h>
extern uint32_t SystemCoreClock;
#endif
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Shared Macros */
/* Cortex M33 port configuration. */
[#if FREERTOS_FREERTOSEnable_TRUEMPUFPUConfiguration_EnableMPU == "Disable"]
#define configENABLE_MPU                              (0U)
[#else]
#define configENABLE_MPU                              (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEMPUFPUConfiguration_EnableFPU == "Disable"]
#define configENABLE_FPU                              (0U)
[#else]
#define configENABLE_FPU                              (1U)
[/#if]
#define configENABLE_TRUSTZONE                        (0U)

[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_PREEMPTION == "Disable"]
#define configUSE_PREEMPTION                          (0U)
[#else]
#define configUSE_PREEMPTION                          (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_STATIC_ALLOCATION == "Disable"]
#define configSUPPORT_STATIC_ALLOCATION               (0U)
[#else]
#define configSUPPORT_STATIC_ALLOCATION               (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_DYNAMIC_ALLOCATION == "Disable"]
#define configSUPPORT_DYNAMIC_ALLOCATION              (0U)
[#else]
#define configSUPPORT_DYNAMIC_ALLOCATION              (1U)
[/#if]
#define configCPU_CLOCK_HZ                            ((unsigned long)SystemCoreClock)
#define configTICK_RATE_HZ                            ((TickType_t)${FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_TICK_RATE_HZ})
#define configTOTAL_HEAP_SIZE                         ((size_t)${FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_TOTAL_HEAP_SIZE})
#define configMAX_PRIORITIES                          (${FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_MAX_PRIORITIES}U)
#define configMAX_TASK_NAME_LEN                       (${FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_MAX_TASK_NAME_LEN}U)
#define configMINIMAL_STACK_SIZE                      ((uint16_t)${FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_MINIMAL_STACK_SIZE})
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_IDLE_SHOULD_YIELD == "Disable"]
#define configIDLE_SHOULD_YIELD                       (0U)
[#else]
#define configIDLE_SHOULD_YIELD                       (1U)
[/#if]
#define configQUEUE_REGISTRY_SIZE                     (${FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_QUEUE_REGISTRY_SIZE}U)
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_16_BIT_TICKS == "Disable"]
#define configUSE_16_BIT_TICKS                        (0U)
[#else]
#define configUSE_16_BIT_TICKS                        (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_MUTEXES == "Disable"]
#define configUSE_MUTEXES                             (0U)
[#else]
#define configUSE_MUTEXES                             (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_RECURSIVE_MUTEXES == "Disable"]
#define configUSE_RECURSIVE_MUTEXES                   (0U)
[#else]
#define configUSE_RECURSIVE_MUTEXES                   (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_COUNTING_SEMAPHORES == "Disable"]
#define configUSE_COUNTING_SEMAPHORES                 (0U)
[#else]
#define configUSE_COUNTING_SEMAPHORES                 (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_PORT_OPTIMISED_TASK_SELECTION == "Disable"]
#define configUSE_PORT_OPTIMISED_TASK_SELECTION       (0U)
[#else]
#define configUSE_PORT_OPTIMISED_TASK_SELECTION       (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_APPLICATION_TASK_TAG == "Disable"]
#define configUSE_APPLICATION_TASK_TAG                (0U)
[#else]
#define configUSE_APPLICATION_TASK_TAG                (1U)
[/#if]

/* Scheduling behaviour related definitions. */
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_PORT_OPTIMISED_TASK_SELECTION == "Disable"]
#define configUSE_PORT_OPTIMISED_TASK_SELECTION       (0U)
[#else]
#define configUSE_PORT_OPTIMISED_TASK_SELECTION       (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_TICKLESS_IDLE == "Disable"]
#define configUSE_TICKLESS_IDLE                       (0U)
[#else]
#define configUSE_TICKLESS_IDLE                       (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_ENABLE_BACKWARD_COMPATIBILITY == "Disable"]
#define configENABLE_BACKWARD_COMPATIBILITY           (0U)
[#else]
#define configENABLE_BACKWARD_COMPATIBILITY           (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEKernalConfiguration_USE_MINI_LIST_ITEM == "Disable"]
#define configUSE_MINI_LIST_ITEM                      (0U)
[#else]
#define configUSE_MINI_LIST_ITEM                      (1U)
[/#if]

/* configMESSAGE_BUFFER_LENGTH_TYPE sets the type used to store the length of
 * each message written to a FREERTOS message buffer (the length is also written to
 * the message buffer.)  Defaults to size_t if left undefined - but that may waste
 * space if messages never go above a length that could be held in a uint8_t. */
#define configMESSAGE_BUFFER_LENGTH_TYPE              size_t

/* Co-routine related definitions. */
[#if FREERTOS_FREERTOSEnable_TRUECoroutineConfiguration_USE_CO_ROUTINES == "Disable"]
#define configUSE_CO_ROUTINES                         (0U)
[#else]
#define configUSE_CO_ROUTINES                         (1U)
[/#if]
#define configMAX_CO_ROUTINE_PRIORITIES               (${FREERTOS_FREERTOSEnable_TRUECoroutineConfiguration_MAX_CO_ROUTINE_PRIORITIES}U)

/* Software timer related definitions. */
[#if FREERTOS_FREERTOSEnable_TRUESoftwareTimerConfiguration_USE_TIMERS == "Disable"]
#define configUSE_TIMERS                              (0U)
[#else]
#define configUSE_TIMERS                              (1U)
[/#if]
 #define configTIMER_TASK_PRIORITY                    (${FREERTOS_FREERTOSEnable_TRUESoftwareTimerConfiguration_TIMER_TASK_PRIORITY}U)
 #define configTIMER_TASK_STACK_DEPTH                 (${FREERTOS_FREERTOSEnable_TRUESoftwareTimerConfiguration_TIMER_TASK_STACK_DEPTH}U)
 #define configTIMER_QUEUE_LENGTH                     (${FREERTOS_FREERTOSEnable_TRUESoftwareTimerConfiguration_TIMER_QUEUE_LENGTH}U)

/* Hook and callback function related definitions. */
[#if FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_USE_IDLE_HOOK == "Disable"]
#define configUSE_IDLE_HOOK                           (0U)
[#else]
#define configUSE_IDLE_HOOK                           (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_USE_TICK_HOOK == "Disable"]
#define configUSE_TICK_HOOK                           (0U)
[#else]
#define configUSE_TICK_HOOK                           (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_USE_MALLOC_FAILED_HOOK == "Disable"]
#define configUSE_MALLOC_FAILED_HOOK                  (0U)
[#else]
#define configUSE_MALLOC_FAILED_HOOK                  (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_USE_DAEMON_TASK_STARTUP_HOOK == "Disable"]
#define configUSE_DAEMON_TASK_STARTUP_HOOK            (0U)
[#else]
#define configUSE_DAEMON_TASK_STARTUP_HOOK            (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_CHECK_FOR_STACK_OVERFLOW == "Disable"]
#define configCHECK_FOR_STACK_OVERFLOW                (0U)
[#elseif FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_CHECK_FOR_STACK_OVERFLOW == "Method 1"]
#define configCHECK_FOR_STACK_OVERFLOW                (1U)
[#elseif FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_CHECK_FOR_STACK_OVERFLOW == "Method 2"]
#define configCHECK_FOR_STACK_OVERFLOW                (2U)
[#elseif FREERTOS_FREERTOSEnable_TRUEHookAndCallbackFunctionConfiguration_CHECK_FOR_STACK_OVERFLOW == "Method 3"]
#define configCHECK_FOR_STACK_OVERFLOW                (3U)
[/#if]


/* Run time and task stats gathering related definitions. */
[#if FREERTOS_FREERTOSEnable_TRUERunTimeAndTaskStatesGatheringConfiguration_GENERATE_RUN_TIME_STATS == "Disable"]
#define configGENERATE_RUN_TIME_STATS                 (0U)
[#else]
#define configGENERATE_RUN_TIME_STATS                 (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUERunTimeAndTaskStatesGatheringConfiguration_USE_STATS_FORMATTING_FUNCTIONS == "Disable"]
#define configUSE_STATS_FORMATTING_FUNCTIONS          (0U)
[#else]
#define configUSE_STATS_FORMATTING_FUNCTIONS          (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUERunTimeAndTaskStatesGatheringConfiguration_USE_TRACE_FACILITY == "Disable"]
#define configUSE_TRACE_FACILITY                      (0U)
[#else]
#define configUSE_TRACE_FACILITY                      (1U)
[/#if]


/* Set the following INCLUDE_* constants to 1 to incldue the named API function,
 * or 0 to exclude the named API function. */
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_vTaskPrioritySet == "Disable"]
#define INCLUDE_vTaskPrioritySet                      (0U)
[#else]
#define INCLUDE_vTaskPrioritySet                      (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_uxTaskPriorityGet == "Disable"]
#define INCLUDE_uxTaskPriorityGet                     (0U)
[#else]
#define INCLUDE_uxTaskPriorityGet                     (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_vTaskDelete == "Disable"]
#define INCLUDE_vTaskDelete                           (0U)
[#else]
#define INCLUDE_vTaskDelete                           (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_vTaskDelete == "Disable"]
#define INCLUDE_vTaskSuspend                          (0U)
[#else]
#define INCLUDE_vTaskSuspend                          (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xResumeFromISR == "Disable"]
#define INCLUDE_xResumeFromISR                        (0U)
[#else]
#define INCLUDE_xResumeFromISR                        (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_vTaskDelayUntil == "Disable"]
#define INCLUDE_vTaskDelayUntil                       (0U)
[#else]
#define INCLUDE_vTaskDelayUntil                       (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_vTaskDelay == "Disable"]
#define INCLUDE_vTaskDelay                            (0U)
[#else]
#define INCLUDE_vTaskDelay                            (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xTaskGetSchedulerState == "Disable"]
#define INCLUDE_xTaskGetSchedulerState                (0U)
[#else]
#define INCLUDE_xTaskGetSchedulerState                (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xTaskGetCurrentTaskHandle == "Disable"]
#define INCLUDE_xTaskGetCurrentTaskHandle             (0U)
[#else]
#define INCLUDE_xTaskGetCurrentTaskHandle             (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_uxTaskGetStackHighWaterMark == "Disable"]
#define INCLUDE_uxTaskGetStackHighWaterMark           (0U)
[#else]
#define INCLUDE_uxTaskGetStackHighWaterMark           (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xTaskGetIdleTaskHandle == "Disable"]
#define INCLUDE_xTaskGetIdleTaskHandle                (0U)
[#else]
#define INCLUDE_xTaskGetIdleTaskHandle                (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_eTaskGetState == "Disable"]
#define INCLUDE_eTaskGetState                         (0U)
[#else]
#define INCLUDE_eTaskGetState                         (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xEventGroupSetBitFromISR == "Disable"]
#define INCLUDE_xEventGroupSetBitFromISR              (0U)
[#else]
#define INCLUDE_xEventGroupSetBitFromISR              (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xTimerPendFunctionCall == "Disable"]
#define INCLUDE_xTimerPendFunctionCall                (0U)
[#else]
#define INCLUDE_xTimerPendFunctionCall                (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xQueueGetMutexHolder == "Disable"]
#define INCLUDE_xQueueGetMutexHolder                  (0U)
[#else]
#define INCLUDE_xQueueGetMutexHolder                  (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xTaskAbortDelay == "Disable"]
#define INCLUDE_xTaskAbortDelay                       (0U)
[#else]
#define INCLUDE_xTaskAbortDelay                       (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xTaskGetHandle == "Disable"]
#define INCLUDE_xTaskGetHandle                        (0U)
[#else]
#define INCLUDE_xTaskGetHandle                        (1U)
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEIncludeAPIConfiguration_xTaskResumeFromISR == "Disable"]
#define INCLUDE_xTaskResumeFromISR                    (0U)
[#else]
#define INCLUDE_xTaskResumeFromISR                    (1U)
[/#if]

/* Cortex-M specific definitions */
#ifdef __NVIC_PRIO_BITS
    /* __NVIC_PRIO_BITS will be specified when CMSIS is being used. */
    #define configPRIO_BITS                           __NVIC_PRIO_BITS
#else
    #define configPRIO_BITS                           (4U)        /* 15 priority levels */
#endif

/* The lowest interrupt priority that can be used in a call to a "set priority"
function. */
#define configLIBRARY_LOWEST_INTERRUPT_PRIORITY       (${FREERTOS_FREERTOSEnable_TRUEInterruptPriorityConfiguration_LIBRARY_LOWEST_INTERRUPT_PRIORITY}U)

/* The highest interrupt priority that can be used by any interrupt service
routine that makes calls to interrupt safe FREERTOS API functions.  DO NOT CALL
INTERRUPT SAFE FREERTOS API FUNCTIONS FROM ANY INTERRUPT THAT HAS A HIGHER
PRIORITY THAN THIS! (higher priorities are lower numeric values.) */
#define configLIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY  (${FREERTOS_FREERTOSEnable_TRUEInterruptPriorityConfiguration_LIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY}U)

/* Interrupt priorities used by the kernel port layer itself.  These are generic
to all Cortex-M ports, and do not rely on any particular library functions. */
#define configKERNEL_INTERRUPT_PRIORITY 		      (configLIBRARY_LOWEST_INTERRUPT_PRIORITY << (8 - configPRIO_BITS))
/* !!!! configMAX_SYSCALL_INTERRUPT_PRIORITY must not be set to zero !!!!
See http://www.FREERTOS.org/RTOS-Cortex-M3-M4.html. */
#define configMAX_SYSCALL_INTERRUPT_PRIORITY 	      (configLIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY << (8 - configPRIO_BITS))

/* Normal assert() semantics without relying on the provision of an assert.h header file. */
#define configASSERT( x )                             if ((x) == 0) {taskDISABLE_INTERRUPTS(); for( ;; );}

/* Definitions that map the FREERTOS port interrupt handlers to their CMSIS
standard names. */
#define vPortSVCHandler                               SVC_Handler
#define xPortPendSVHandler                            PendSV_Handler

/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants  */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#endif /* FREERTOS_CONFIG_H */
