[#ftl]
/*!
    \file    usbh_conf.h
    \brief   USB host driver configuration

    \version 2023-08-01, V1.0.0, HAL firmware for GD32F3x0
*/

/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc. 

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __USBH_CONF_H
#define __USBH_CONF_H

#include "usb_conf.h"

#define ENABLE                                  1
#define DISABLE                                 0

#define HOST_MAX_EP_NUM                         ${USBFS_HOST_ParametersConfiguration_Hostmaximumendpointnumber}
#define HOST_MAX_INTERFACES_NUM                 ${USBFS_HOST_ParametersConfiguration_Hostmaximuminterfacenumber}
#define HOST_MAX_ALT_SETTING                    ${USBFS_HOST_ParametersConfiguration_Hostmaximumalternatenumber}
#define HOST_MAX_SUPPORTED_CLASS                ${USBFS_HOST_ParametersConfiguration_Hostmaximumsupportedclass}
#define HOST_CFG_DESC_KEEP                      ${USBFS_HOST_ParametersConfiguration_Hostconfiguredescriptorkeep}
#define HOST_DATA_BUF_MAX_LEN                   ${USBFS_HOST_ParametersConfiguration_Hostdatabuffermaximumlength}
#define HOST_CFGSET_MAX_LEN                     ${USBFS_HOST_ParametersConfiguration_Hostconfiguresetmaximumlength}
#define HOST_USER_DEBUG_LOG                     ${USBFS_HOST_ParametersConfiguration_Hostuserdebuglog}
#define USB_SOF_OUTPUT                          ${USBFS_ParametersConfiguration_SOFsignaloutput}

#define USB_RX_FIFO_FS_SIZE                     ${USBFS_FIFOSize_AlloctedRXFIFOsize}
#define USB_HTX_NPFIFO_FS_SIZE                  ${USBFS_FIFOSize_AlloctedperiodicTXFIFOsize}
#define USB_HTX_PFIFO_FS_SIZE                   ${USBFS_FIFOSize_AlloctednonperiodicTXFIFOsize}

#if (ENABLE == HOST_USER_DEBUG_LOG)
#define User_Debug_Log(...) do { \
                                 \
                                 printf(__VA_ARGS__);\
                               } while (0)
#else
#define User_Debug_Log(...) do {} while (0)
#endif

#define hal_usbh_irq() usbh_irq()
void msd_usbfs_host_init(void);
extern uint32_t usbh_irq (void);

#endif /* __USBH_CONF_H */
