[#ftl]
/*!
    \file    usbd_conf.h
    \brief   the header file of USB device configuration

    \version 2023-08-01, V1.0.0, HAL firmware for GD32F3x0
*/

/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc. 

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef __USBD_CONF_H
#define __USBD_CONF_H

#include "usb_conf.h"
#include "drv_usb_hw.h"

extern void usbd_irq (void);
extern void usbfs_wakeup_irq(void);

#define DEVICE_MAX_CONF_NUM       ${USBFS_DEVICE_ParametersConfiguration_Devicemaxconfigurationnumber}
#define DEVICE_MAX_ITF_NUM        ${USBFS_DEVICE_ParametersConfiguration_Devicemaxinterfacenumber}
#define DEVICE_BOS_DESC_LEN       ${USBFS_DEVICE_ParametersConfiguration_DeviceBOSdescriptorlength}
#define DEVICE_SELF_POWERED       ${USBFS_DEVICE_ParametersConfiguration_Deviceselfpowered}
#define DEVICE_REMOTE_WAKEUP      ${USBFS_DEVICE_ParametersConfiguration_Deviceremotewakeup}
#define HID_INTERVAL              ${USBFS_DEVICE_ParametersConfiguration_HIDintervalframenumber}

#define USB_SOF_OUTPUT            ${USBFS_ParametersConfiguration_SOFsignaloutput}
#define USB_LOW_POWER             ${USBFS_ParametersConfiguration_Lowpowermode}
#define VBUS_SENSING              ${USBFS_ParametersConfiguration_VBUSsensingconfiguration}
#define LPM_ENABLE                ${USBFS_ParametersConfiguration_Linkpowermanagement}

#if VBUS_SENSING
#define VBUS_SENSING_ENABLED
#endif

#if LPM_ENABLE
#define USE_BOS_DESC   ENABLE
#endif 

#if !defined (USE_BOS_DESC)
#define USE_BOS_DESC   ${USBFS_ParametersConfiguration_BOSdescriptorconfiguration}
#endif

#define hal_usbfs_wakeup_irq() usbfs_wakeup_irq();
#define hal_usbd_irq() usbd_irq()
void msd_usbfs_device_init(void);

#endif /* __USBD_CONF_H */
