[#ftl]
/*!
    \file    usbd_conf.c
    \brief   the source file of USB device configuration

    \version 2023-08-01, V1.0.0, HAL firmware for GD32F3x0
*/

/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc. 

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#include "usbd_conf.h"
#include "drv_usb_hw.h"
#include "drv_usb_core.h"
#include "${middleType}_core.h"

#define RX_FIFO_FS_SIZE            ${USBFS_FIFOSize_AlloctedRXFIFOsize}
#define TX0_FIFO_FS_SIZE           ${USBFS_FIFOSize_AlloctedTX0FIFOsize}
#define TX1_FIFO_FS_SIZE           ${USBFS_FIFOSize_AlloctedTX1FIFOsize}
#define TX2_FIFO_FS_SIZE           ${USBFS_FIFOSize_AlloctedTX2FIFOsize}
#define TX3_FIFO_FS_SIZE           ${USBFS_FIFOSize_AlloctedTX3FIFOsize}

void usbd_basic_parameter_init(usb_core_basic *usb_basic);
void usbd_fifo_size_init(usb_core_regs  *usb_regs);
extern usb_core_driver usbd_core;
extern usb_class_core usbd_dfu_cb;

/*!
    \brief      configure USBFS device initialization
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usbfs_device_init(void)
{
${mwGetCode}
    usbd_basic_parameter_init(&usbd_core.bp);

    usbd_init (&usbd_core, USB_CORE_ENUM_FS, &${middleType}_desc, &usbd_${middleType}_cb);

    usbd_fifo_size_init(&usbd_core.regs);
}

/*!
    \brief      configure USB basic parameter 
    \param[in]  usb_basic: pointer to USB capabilities
    \param[out] none
    \retval     none
*/
void usbd_basic_parameter_init(usb_core_basic *usb_basic)
{
    usb_basic->core_speed = (uint8_t)USB_SPEED_FULL;
    usb_basic->sof_enable = USB_SOF_OUTPUT;
    usb_basic->low_power = USB_LOW_POWER;
    usb_basic->lpm_enable = LPM_ENABLE;
    usb_basic->vbus_sensing_enable = VBUS_SENSING;
    usb_basic->use_BOS_desc = USE_BOS_DESC;
}

/*!
    \brief      configure  endpoint FIFO size
    \param[in]  usb_regs: USB core registers
    \param[out] none
    \retval     none
*/
void usbd_fifo_size_init(usb_core_regs *usb_regs)
{
    usb_set_rxfifo(usb_regs, RX_FIFO_FS_SIZE);
    usb_set_txfifo(usb_regs, 0, TX0_FIFO_FS_SIZE);
    usb_set_txfifo(usb_regs, 1, TX1_FIFO_FS_SIZE);
    usb_set_txfifo(usb_regs, 2, TX2_FIFO_FS_SIZE);
    usb_set_txfifo(usb_regs, 3, TX3_FIFO_FS_SIZE);
}

/*!
    \brief      delay in milli seconds
    \param[in]  msec: value of delay required in milli seconds
    \param[out] none
    \retval     none
*/
void usb_mdelay(const uint32_t msec)
{
    hal_sys_basetick_delay_ms(msec);
}

