/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
hal_wwdgt_init_struct wwdgt_init_parameter;
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    gd_eval_led_init(LED1);
    gd_eval_led_init(LED2);
    gd_eval_led_init(LED3);

    gd_eval_led_on(LED1);
    gd_eval_led_on(LED2);
    gd_eval_led_off(LED3);
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */
    /* check if the system has resumed from WWDGT reset */
    if (RESET != hals_rcu_flag_get(RCU_FLAG_WWDGTRST)){
        /* WWDGTRST flag set */
        gd_eval_led_on(LED2);
        /* clear the reset flag */
        RCU_RSTSCK |= RCU_RSTSCK_RSTFC;
        while(1);
    }else{
        hal_sys_basetick_delay_ms(150);
        gd_eval_led_off(LED2);
    }

     /* set WWDGT clock = (PCLK1 (54MHz)/4096)/8 = 1647Hz (~607 us)
        set counter value to 127
        set window value to 80
        refresh window is: ~607 * (127-80)= 28.5ms < refresh window < ~607 * 64 = 38.8ms.
        user code [local 1] end */
    wwdgt_init_parameter.wwdgt_pre_select = WWDGT_PSC_DIV8;
    wwdgt_init_parameter.wwdgt_cnt_value = 127;
    wwdgt_init_parameter.wwdgt_downcnt_value = 80;
    hal_wwdgt_start();
    /* user code [local 1] end */
    msd_gpio_init();
    msd_wwdgt_init();

    /* user code [local 2] begin */

    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */
        gd_eval_led_toggle(LED3);
        /* insert 26 ms delay */
        hal_sys_basetick_delay_ms(27);

        /* update WWDGT counter */
        hal_wwdgt_reload(&wwdgt_init_parameter);
    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/* user code [global 1] end */	
