/*
    \file  gd32f3x0_hal_init.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */

/* user code [global 0] end */
hal_i2c_dev_struct i2c0_info;

void msd_system_init(void)
{
    /* user code [system_init local 0] begin */
    /* user code [system_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_CFGCMP);
    hal_nvic_irq_priority_group_set(NVIC_PRIGROUP_PRE0_SUB4);
    hal_sys_timesource_init(SYS_TIMEBASE_SOURCE_SYSTICK);

    hal_nvic_set_priority(NonMaskableInt_IRQn, 0, 0);
    hal_nvic_set_priority(SVCall_IRQn, 0, 0);
    hal_nvic_set_priority(PendSV_IRQn, 0, 0);
    hal_nvic_set_priority(SysTick_IRQn, 0, 0);
    /* user code [system_init local 1] begin */
    /* user code [system_init local 1] end */
}

void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */
    /* user code [clock_init local 0] end */
    hal_rcu_clk_struct rcu_clk_parameter;
    hal_rcu_osci_struct rcu_osci_parameter;

    hal_rcu_struct_init(HAL_RCU_CLK_STRUCT, &rcu_clk_parameter);
    hal_rcu_struct_init(HAL_RCU_OSCI_STRUCT, &rcu_osci_parameter);

    rcu_osci_parameter.hxtal.need_configure = ENABLE;
    rcu_osci_parameter.hxtal.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.need_configure = ENABLE;
    rcu_osci_parameter.irc8m.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.adjust_value = 0;
    rcu_osci_parameter.pll.need_configure = ENABLE;
    rcu_osci_parameter.pll.state = RCU_OSC_ON;
    rcu_osci_parameter.pll.pll_source = RCU_PLL_SRC_HXTAL_IRC48M;
    rcu_osci_parameter.pll.pll_mul = RCU_PLL_MULT27;
    rcu_osci_parameter.pll.pll_presel = RCU_PLL_PRESEL_HXTAL;
    rcu_osci_parameter.pll.pre_div = RCU_PLL_PREDIV2;
    if(HAL_ERR_NONE != hal_rcu_osci_config(&rcu_osci_parameter)){
        while(1);
    }

    rcu_clk_parameter.clock_type = RCU_CLKTYPE_SYSCLK | RCU_CLKTYPE_AHBCLK | RCU_CLKTYPE_APB1CLK | RCU_CLKTYPE_APB2CLK | RCU_CLKTYPE_CK48MCLK;
    rcu_clk_parameter.sysclk_source = RCU_SYSCLK_SRC_PLL;
    rcu_clk_parameter.ahbclk_divider = RCU_SYSCLK_AHBDIV1;
    rcu_clk_parameter.apb1clk_divider = RCU_AHBCLK_APB1DIV2;
    rcu_clk_parameter.apb2clk_divider = RCU_AHBCLK_APB2DIV2;
    rcu_clk_parameter.ck48mclk_source = RCU_USB_CK48MSRC_IRC48M;
    if(HAL_ERR_NONE != hal_rcu_clock_config(&rcu_clk_parameter)){
        while(1);
    }

    /* user code [clock_init local 1] begin */
    /* user code [clock_init local 1] end */
}

void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */
    /* user code [gpio_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;

    hal_rcu_periph_clk_enable(RCU_GPIOC);
    hal_rcu_periph_clk_enable(RCU_GPIOF);
    hal_rcu_periph_clk_enable(RCU_GPIOB);
    hal_rcu_periph_clk_enable(RCU_GPIOA);
    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_OUTPUT_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOC, GPIO_PIN_11, &gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_OUTPUT_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOC, GPIO_PIN_10, &gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_INPUT;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOA, GPIO_PIN_0, &gpio_init_parameter);

    /* user code [gpio_init local 1] begin */
    /* user code [gpio_init local 1] end */
}

void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */
    /* user code [gpio_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_GPIOC);
    hal_rcu_periph_clk_disable(RCU_GPIOF);
    hal_rcu_periph_clk_disable(RCU_GPIOB);
    hal_rcu_periph_clk_disable(RCU_GPIOA);
    hal_gpio_deinit(GPIOC, GPIO_PIN_11);
    hal_gpio_deinit(GPIOC, GPIO_PIN_10);
    hal_gpio_deinit(GPIOA, GPIO_PIN_0);
    /* user code [gpio_deinit local 1] begin */
    /* user code [gpio_deinit local 1] end */
}

void msd_i2c0_init(void)
{
    /* user code [i2c0_init local 0] begin */
    /* user code [i2c0_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;
    hal_i2c_init_struct i2c0_init_parameter;

    hal_rcu_periph_clk_enable(RCU_I2C0);
    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_AF_OD;
    gpio_init_parameter.pull = GPIO_PULL_UP;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_1;
    hal_gpio_init(GPIOB, GPIO_PIN_7, &gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_AF_OD;
    gpio_init_parameter.pull = GPIO_PULL_UP;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_1;
    hal_gpio_init(GPIOB, GPIO_PIN_6, &gpio_init_parameter);

    hal_i2c_struct_init(HAL_I2C_INIT_STRUCT, &i2c0_init_parameter);
    hal_i2c_struct_init(HAL_I2C_DEV_STRUCT, &i2c0_info);

    i2c0_init_parameter.duty_cycle = I2C_DTCY_2;
    i2c0_init_parameter.address_format = I2C_ADDFORMAT_7BITS;
    i2c0_init_parameter.dual_address = I2C_DUADEN_DISABLE;
    i2c0_init_parameter.own_address1 = 0x41;
    i2c0_init_parameter.own_address2 = 0x00;
    i2c0_init_parameter.general_call = I2C_GCEN_DISABLE;
    i2c0_init_parameter.no_stretch = I2C_SCLSTRETCH_ENABLE;
    i2c0_init_parameter.clock_speed = 400000;
    hal_i2c_init(&i2c0_info,I2C0,&i2c0_init_parameter);

    hal_nvic_irq_enable(I2C0_EV_IRQn, 0, 3);
    hal_nvic_irq_enable(I2C0_ER_IRQn, 0, 2);
    /* user code [i2c0_init local 1] begin */
    /* user code [i2c0_init local 1] end */
}

void msd_i2c0_deinit(void)
{
    /* user code [i2c0_deinit local 0] begin */
    /* user code [i2c0_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_I2C0);
    hal_gpio_deinit(GPIOB, GPIO_PIN_7);
    hal_gpio_deinit(GPIOB, GPIO_PIN_6);
    hal_i2c_deinit(&i2c0_info);
    /* user code [i2c0_deinit local 1] begin */
    /* user code [i2c0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */
