/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"

#define DATANUM                  16
__IO ErrStatus transferflag1 = ERROR;
__IO ErrStatus transferflag2 = ERROR;
uint8_t source_address[DATANUM]= {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
                                  0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,0x10};
uint8_t destination_address1[DATANUM];
uint8_t destination_address2[DATANUM];

void destbuf_init(void);
ErrStatus uc_data_compare(uint8_t* src, uint8_t* dst, uint16_t length);
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    int i = 0;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_dma_init();

    /* user code [local 2] begin */
    gd_eval_led_init(LED1);
    gd_eval_led_init(LED2);

    hal_dma_start(&dma_ch2_m2m_info, (uint32_t)source_address, (uint32_t)destination_address1, DATANUM);
    hal_dma_start(&dma_ch1_m2m_info, (uint32_t)source_address, (uint32_t)destination_address2, DATANUM);

    /* wait for DMA transfer complete */
    for(i = 0; i < 200; i++);
    /* compare the data of source_address with data of destination_address */
    transferflag1 = uc_data_compare(source_address, destination_address1, DATANUM);
    transferflag2 = uc_data_compare(source_address, destination_address2, DATANUM);

    /* if DMA channel 1 transfer success,light LED1 */
    if(SUCCESS == transferflag1){
    	gd_eval_led_on(LED1);
    }
    /* if DMA channel 2 transfer success,light LED2 */
    if(SUCCESS == transferflag2){
    	gd_eval_led_on(LED2);
    }
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */

    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
\brief      initialize destination buffer
\param[in]  none
\param[out] none
\retval     none
*/
void destbuf_init(void)
{
    memset(destination_address1, 0, DATANUM);
    memset(destination_address2, 0, DATANUM);
}

/*!
\brief      data compare function
\param[in]  src: source data
\param[in]  dst: destination data
\param[in]  length: the compare data length
\param[out] none
\retval     ErrStatus: ERROR or SUCCESS
*/
ErrStatus uc_data_compare(uint8_t* src, uint8_t* dst, uint16_t length)
{
    while(length--){
        if (*src++ != *dst++){
            return ERROR;
        }
    }
    return SUCCESS;
}
/* user code [global 1] end */	
