[#ftl]
[#-- V1.2.0 --]
/*
    \file  gd32h7xx_hal_it.c
*/
/*
    Copyright (c) ${CurrentData}, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32h7xx_hal_it.h"
#include "gd32h7xx_hal.h"
#include "gd32h7xx_hal_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

[#if NVIC_NonMaskableInterrupt ??== true && NVIC_NonMaskableInterrupt_Enabled == "TRUE"]
/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */
    while(1) {
        /* user code [NMI_IRQn local 1] begin */

        /* user code [NMI_IRQn local 1] end */
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

[/#if]
[#if NVIC_HardfaultInterrupt ??== true && NVIC_HardfaultInterrupt_Enabled == "TRUE"]
/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
    while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
    }

    /* user code [HardFault_IRQn local 2] begin */

    /* user code [HardFault_IRQn local 2] end */
}

[/#if]
[#if NVIC_MemoryManagementInterrupt ??== true && NVIC_MemoryManagementInterrupt_Enabled == "TRUE"]
/*!
    \brief      Memory Management Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void MemManage_Handler(void)
{
    /* user code [MemManage_IRQn local 0] begin */

    /* user code [MemManage_IRQn local 0] end */
    while(1) {
        /* user code [MemManage_IRQn local 1] begin */

        /* user code [MemManage_IRQn local 1] end */
    }

    /* user code [MemManage_IRQn local 2] begin */

    /* user code [MemManage_IRQn local 2] end */
}

[/#if]
[#if NVIC_PrefetchFaultMemoryAccessFault ??== true && NVIC_PrefetchFaultMemoryAccessFault_Enabled == "TRUE"]
/*!
    \brief      Pre-fetch Fault,Memory Access Fault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void BusFault_Handler(void)
{
    /* user code [BusFault_IRQn local 0] begin */

    /* user code [BusFault_IRQn local 0] end */
    while(1) {
        /* user code [BusFault_IRQn local 1] begin */

        /* user code [BusFault_IRQn local 1] end */
    }

    /* user code [BusFault_IRQn local 2] begin */

    /* user code [BusFault_IRQn local 2] end */
}

[/#if]
[#if NVIC_UndefinedInstructionOrIllegalState ??== true && NVIC_UndefinedInstructionOrIllegalState_Enabled == "TRUE"]
/*!
    \brief      Undefined Instruction Or Illegal State Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none

*/
void UsageFault_Handler(void)
{
    /* user code [UsageFault_IRQn local 0] begin */

    /* user code [UsageFault_IRQn local 0] end */
    while(1) {
        /* user code [UsageFault_IRQn local 1] begin */

        /* user code [UsageFault_IRQn local 1] end */
    }

    /* user code [UsageFault_IRQn local 2] begin */

    /* user code [UsageFault_IRQn local 2] end */
}

[/#if]
[#if NVIC_SystemServiceCallViaSWIInstruction ??== true && NVIC_SystemServiceCallViaSWIInstruction_Enabled == "TRUE"]
/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */
    while(1) {
        /* user code [SVC_IRQn local 1] begin */

        /* user code [SVC_IRQn local 1] end */
    }

    /* user code [SVC_IRQn local 2] begin */

    /* user code [SVC_IRQn local 2] end */
}

[/#if]
[#if NVIC_DebugMonitorInterrupt ??== true && NVIC_DebugMonitorInterrupt_Enabled == "TRUE"]
/*!
    \brief      Debug Monitor Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DebugMon_Handler(void)
{
    /* user code [DebugMon_IRQn local 0] begin */

    /* user code [DebugMon_IRQn local 0] end */
    while(1) {
        /* user code [DebugMon_IRQn local 1] begin */

        /* user code [DebugMon_IRQn local 1] end */
    }

    /* user code [DebugMon_IRQn local 2] begin */

    /* user code [DebugMon_IRQn local 2] end */
}

[/#if]
[#if NVIC_PendableRequestForSystemService ??== true && NVIC_PendableRequestForSystemService_Enabled == "TRUE"]
/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */
    while(1) {
        /* user code [PendSV_IRQn local 1] begin */

        /* user code [PendSV_IRQn local 1] end */
    }

    /* user code [PendSV_IRQn local 2] begin */

    /* user code [PendSV_IRQn local 2] end */
}

[/#if]
[#if NVIC_SystemTickTimer ??== true && NVIC_SystemTickTimer_Enabled == "TRUE"]
/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */

    /* user code [SysTick_IRQn local 0] end */
[#if SYS_TimebaseSource == "Systick"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

[/#if]
[#if NVIC_WindowWatchdogInterrupt ??== true && NVIC_WindowWatchdogInterrupt_Enabled == "TRUE"]
/*!
    \brief      WWDGT Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void WWDGT_IRQHandler(void)
{
    /* user code [WWDGT_IRQn local 0] begin */

    /* user code [WWDGT_IRQn local 0] end */
    hal_wwdgt_irq(&wwdgt_info);
    /* user code [WWDGT_IRQn local 1] begin */

    /* user code [WWDGT_IRQn local 1] end */
}

[/#if]
[#if NVIC_AVDLVDOVDThroughEXTILineDetectionInterrupt ??== true && NVIC_AVDLVDOVDThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      AVD,LVD,OVD Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void AVD_LVD_OVD_IRQHandler(void)
{
    /* user code [AVD_LVD_OVD_IRQn local 0] begin */

    /* user code [AVD_LVD_OVD_IRQn local 0] end */
    hal_pmu_irq(&pmu_info);
    /* user code [AVD_LVD_OVD_IRQn local 1] begin */

    /* user code [AVD_LVD_OVD_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCTamperAndTimestampFromEXTIInterruptLXTALClockStuckInterrupt ??== true && NVIC_RTCTamperAndTimestampFromEXTIInterruptLXTALClockStuckInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Tamper And Timestamp From EXTI Interrupt LXTAL Clock Stuck Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TAMPER_STAMP_LXTAL_IRQHandler(void)
{
    /* user code [TAMPER_STAMP_LXTAL_IRQn local 0] begin */

    /* user code [TAMPER_STAMP_LXTAL_IRQn local 0] end */
	hal_rcu_irq();
[#if Peripherals?contains("#RTC#") == true && RTC_ActiveClockSource == "TRUE"]
    hal_rtc_irq(&rtc_info);
[/#if]
    /* user code [TAMPER_STAMP_LXTAL_IRQn local 1] begin */

    /* user code [TAMPER_STAMP_LXTAL_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCWakeupFromEXTIInterrupt ??== true && NVIC_RTCWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTC_WKUP_IRQHandler(void)
{
    /* user code [RTC_WKUP_IRQn local 0] begin */

    /* user code [RTC_WKUP_IRQn local 0] end */
    hal_rtc_irq(&rtc_info);
    /* user code [RTC_WKUP_IRQn local 1] begin */

    /* user code [RTC_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_FMCGlobalInterrupt ??== true && NVIC_FMCGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FMC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FMC_IRQHandler(void)
{
    /* user code [FMC_IRQn local 0] begin */

    /* user code [FMC_IRQn local 0] end */
    hal_fmc_irq(&fmc_info);
    /* user code [FMC_IRQn local 1] begin */

    /* user code [FMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_RCUGlobalInterrupt ??== true && NVIC_RCUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      RCU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RCU_IRQHandler(void)
{
    /* user code [RCU_IRQn local 0] begin */

    /* user code [RCU_IRQn local 0] end */
    hal_rcu_irq();
    /* user code [RCU_IRQn local 1] begin */

    /* user code [RCU_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine0Interrupt ??== true && NVIC_EXTILine0Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI0_IRQHandler(void)
{
    /* user code [EXTI0_IRQn local 0] begin */

    /* user code [EXTI0_IRQn local 0] end */
    hal_exti_gpio_irq(EXTI_0_IRQHandler_USED);
    /* user code [EXTI0_IRQn local 1] begin */

    /* user code [EXTI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1Interrupt ??== true && NVIC_EXTILine1Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI1_IRQHandler(void)
{
    /* user code [EXTI1_IRQn local 0] begin */

    /* user code [EXTI1_IRQn local 0] end */
    hal_exti_gpio_irq(EXTI_1_IRQHandler_USED);
    /* user code [EXTI1_IRQn local 1] begin */

    /* user code [EXTI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine2Interrupt ??== true && NVIC_EXTILine2Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI2_IRQHandler(void)
{
    /* user code [EXTI2_IRQn local 0] begin */

    /* user code [EXTI2_IRQn local 0] end */
    hal_exti_gpio_irq(EXTI_2_IRQHandler_USED);
    /* user code [EXTI2_IRQn local 1] begin */

    /* user code [EXTI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine3Interrupt ??== true && NVIC_EXTILine3Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI3_IRQHandler(void)
{
    /* user code [EXTI3_IRQn local 0] begin */

    /* user code [EXTI3_IRQn local 0] end */
    hal_exti_gpio_irq(EXTI_3_IRQHandler_USED);
    /* user code [EXTI3_IRQn local 1] begin */

    /* user code [EXTI3_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine4Interrupt ??== true && NVIC_EXTILine4Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI4_IRQHandler(void)
{
    /* user code [EXTI4_IRQn local 0] begin */

    /* user code [EXTI4_IRQn local 0] end */
    hal_exti_gpio_irq(EXTI_4_IRQHandler_USED);
    /* user code [EXTI4_IRQn local 1] begin */

    /* user code [EXTI4_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel0GlobalInterrupt ??== true && NVIC_DMA0Channel0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel0_IRQHandler(void)
{
    /* user code [DMA0_Channel0_IRQn local 0] begin */

    /* user code [DMA0_Channel0_IRQn local 0] end */
[#if DMA0_CH0 ??== true]
    hal_dma_irq(&${DMA0_CH0_Info});
[/#if]
    /* user code [DMA0_Channel0_IRQn local 1] begin */

    /* user code [DMA0_Channel0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel1GlobalInterrupt ??== true && NVIC_DMA0Channel1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel1_IRQHandler(void)
{
    /* user code [DMA0_Channel1_IRQn local 0] begin */

    /* user code [DMA0_Channel1_IRQn local 0] end */
[#if DMA0_CH1 ??== true]
    hal_dma_irq(&${DMA0_CH1_Info});
[/#if]
    /* user code [DMA0_Channel1_IRQn local 1] begin */

    /* user code [DMA0_Channel1_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel2GlobalInterrupt ??== true && NVIC_DMA0Channel2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel2_IRQHandler(void)
{
    /* user code [DMA0_Channel2_IRQn local 0] begin */

    /* user code [DMA0_Channel2_IRQn local 0] end */
[#if DMA0_CH2 ??== true]
    hal_dma_irq(&${DMA0_CH2_Info});
[/#if]
    /* user code [DMA0_Channel2_IRQn local 1] begin */

    /* user code [DMA0_Channel2_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel3GlobalInterrupt ??== true && NVIC_DMA0Channel3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel3_IRQHandler(void)
{
    /* user code [DMA0_Channel3_IRQn local 0] begin */

    /* user code [DMA0_Channel3_IRQn local 0] end */
[#if DMA0_CH3 ??== true]
    hal_dma_irq(&${DMA0_CH3_Info});
[/#if]
    /* user code [DMA0_Channel3_IRQn local 1] begin */

    /* user code [DMA0_Channel3_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel4GlobalInterrupt ??== true && NVIC_DMA0Channel4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel4_IRQHandler(void)
{
    /* user code [DMA0_Channel4_IRQn local 0] begin */

    /* user code [DMA0_Channel4_IRQn local 0] end */
[#if DMA0_CH4 ??== true]
    hal_dma_irq(&${DMA0_CH4_Info});
[/#if]
    /* user code [DMA0_Channel4_IRQn local 1] begin */

    /* user code [DMA0_Channel4_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel5GlobalInterrupt ??== true && NVIC_DMA0Channel5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel5 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel5_IRQHandler(void)
{
    /* user code [DMA0_Channel5_IRQn local 0] begin */

    /* user code [DMA0_Channel5_IRQn local 0] end */
[#if DMA0_CH5 ??== true]
    hal_dma_irq(&${DMA0_CH5_Info});
[/#if]
    /* user code [DMA0_Channel5_IRQn local 1] begin */

    /* user code [DMA0_Channel5_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel6GlobalInterrupt ??== true && NVIC_DMA0Channel6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel6 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel6_IRQHandler(void)
{
    /* user code [DMA0_Channel6_IRQn local 0] begin */

    /* user code [DMA0_Channel6_IRQn local 0] end */
[#if DMA0_CH6 ??== true]
    hal_dma_irq(&${DMA0_CH6_Info});
[/#if]
    /* user code [DMA0_Channel6_IRQn local 1] begin */

    /* user code [DMA0_Channel6_IRQn local 1] end */
}

[/#if]
[#if NVIC_ADC0AndADC1GlobalInterrupt ??== true && NVIC_ADC0AndADC1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      ADC0 And ADC1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ADC0_1_IRQHandler(void)
{
    /* user code [ADC0_1_IRQn local 0] begin */

    /* user code [ADC0_1_IRQn local 0] end */
[#if Peripherals?contains("ADC0") == true]
    hal_adc_irq(&adc0_info);
[/#if]
[#if Peripherals?contains("ADC1") == true]
    hal_adc_irq(&adc1_info);
[/#if]
    /* user code [ADC0_1_IRQn local 1] begin */

    /* user code [ADC0_1_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine59Interrupt ??== true && NVIC_EXTILine59Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI5_9 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI5_9_IRQHandler(void)
{
    /* user code [EXTI5_9_IRQn local 0] begin */

    /* user code [EXTI5_9_IRQn local 0] end */
    hal_exti_gpio_irq(EXTI_5_9_IRQHandler_USED);
    /* user code [EXTI5_9_IRQn local 1] begin */

    /* user code [EXTI5_9_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0BreakInterrupt ??== true && NVIC_TIMER0BreakInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Break Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_BRK_IRQHandler(void)
{
    /* user code [TIMER0_BRK_IRQn local 0] begin */

    /* user code [TIMER0_BRK_IRQn local 0] end */
    hal_timer_irq(&timer0_info);
    /* user code [TIMER0_BRK_IRQn local 1] begin */

    /* user code [TIMER0_BRK_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0UpdateInterrupt ??== true && NVIC_TIMER0UpdateInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Update Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_UP_IRQHandler(void)
{
    /* user code [TIMER0_UP_IRQn local 0] begin */

    /* user code [TIMER0_UP_IRQn local 0] end */
[#if Peripherals?contains("#TIMER0#") == true]
    hal_timer_irq(&timer0_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER0"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER0_UP_IRQn local 1] begin */

    /* user code [TIMER0_UP_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0TriggerAndCommutationInterrupt ??== true && NVIC_TIMER0TriggerAndCommutationInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Trigger And Commutation Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_TRG_CMT_IRQHandler(void)
{
    /* user code [TIMER0_TRG_CMT_IRQn local 0] begin */

    /* user code [TIMER0_TRG_CMT_IRQn local 0] end */
    hal_timer_irq(&timer0_info);
    /* user code [TIMER0_TRG_CMT_IRQn local 1] begin */

    /* user code [TIMER0_TRG_CMT_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0ChannelCaptureCompareInterrupt ??== true && NVIC_TIMER0ChannelCaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Channel Capture Compare Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_Channel_IRQHandler(void)
{
    /* user code [TIMER0_Channel_IRQn local 0] begin */

    /* user code [TIMER0_Channel_IRQn local 0] end */
    hal_timer_irq(&timer0_info);
    /* user code [TIMER0_Channel_IRQn local 1] begin */

    /* user code [TIMER0_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER1GlobalInterrupt ??== true && NVIC_TIMER1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER1_IRQHandler(void)
{
    /* user code [TIMER1_IRQn local 0] begin */

    /* user code [TIMER1_IRQn local 0] end */
[#if Peripherals?contains("#TIMER1#") == true]
    hal_timer_irq(&timer1_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER1"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER1_IRQn local 1] begin */

    /* user code [TIMER1_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER2GlobalInterrupt ??== true && NVIC_TIMER2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER2_IRQHandler(void)
{
    /* user code [TIMER2_IRQn local 0] begin */

    /* user code [TIMER2_IRQn local 0] end */
[#if Peripherals?contains("#TIMER2#") == true]
    hal_timer_irq(&timer2_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER2"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER2_IRQn local 1] begin */

    /* user code [TIMER2_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER3GlobalInterrupt ??== true && NVIC_TIMER3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER3_IRQHandler(void)
{
    /* user code [TIMER3_IRQn local 0] begin */

    /* user code [TIMER3_IRQn local 0] end */
[#if Peripherals?contains("#TIMER3#") == true]
    hal_timer_irq(&timer3_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER3"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER3_IRQn local 1] begin */

    /* user code [TIMER3_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0EventInterrupt ??== true && NVIC_I2C0EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Event Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_EV_IRQHandler(void)
{
    /* user code [I2C0_EV_IRQn local 0] begin */

    /* user code [I2C0_EV_IRQn local 0] end */
[#if I2C0_Mode =="I2C"]
    hal_i2c_event_irq(&i2c0_info);
[/#if]
[#if I2C0_Mode?contains("SMBus") == true]
    hal_smbus_event_irq(&smbus0_info);
[/#if]
    /* user code [I2C0_EV_IRQn local 1] begin */

    /* user code [I2C0_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0ErrorInterrupt ??== true && NVIC_I2C0ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_ER_IRQHandler(void)
{
    /* user code [I2C0_ER_IRQn local 0] begin */

    /* user code [I2C0_ER_IRQn local 0] end */
[#if I2C0_Mode =="I2C"]
    hal_i2c_error_irq(&i2c0_info);
[/#if]
[#if I2C0_Mode?contains("SMBus")==true]
    hal_smbus_error_irq(&smbus0_info);
[/#if]
    /* user code [I2C0_ER_IRQn local 1] begin */

    /* user code [I2C0_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1EventInterrupt ??== true && NVIC_I2C1EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Event Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_EV_IRQHandler(void)
{
    /* user code [I2C1_EV_IRQn local 0] begin */

    /* user code [I2C1_EV_IRQn local 0] end */
[#if I2C1_Mode =="I2C"]
    hal_i2c_event_irq(&i2c1_info);
[/#if]
[#if I2C1_Mode?contains("SMBus")==true]
    hal_smbus_event_irq(&smbus1_info);
[/#if]
    /* user code [I2C1_EV_IRQn local 1] begin */

    /* user code [I2C1_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1ErrorInterrupt ??== true && NVIC_I2C1ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_ER_IRQHandler(void)
{
    /* user code [I2C1_ER_IRQn local 0] begin */

    /* user code [I2C1_ER_IRQn local 0] end */
[#if I2C1_Mode =="I2C"]
    hal_i2c_error_irq(&i2c1_info);
[/#if]
[#if I2C1_Mode?contains("SMBus")==true]
    hal_smbus_error_irq(&smbus1_info);
[/#if]
    /* user code [I2C1_ER_IRQn local 1] begin */

    /* user code [I2C1_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI0GlobalInterrupt ??== true && NVIC_SPI0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI0_IRQHandler(void)
{
    /* user code [SPI0_IRQn local 0] begin */

    /* user code [SPI0_IRQn local 0] end */
[#if Peripherals?contains("#SPI0#")==true]
    hal_spi_irq(&spi0_info);
[/#if]
[#if Peripherals?contains("I2S0")==true]
    hal_i2s_irq(&i2s0_info);
[/#if]
    /* user code [SPI0_IRQn local 1] begin */

    /* user code [SPI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI1GlobalInterrupt ??== true && NVIC_SPI1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI1_IRQHandler(void)
{
    /* user code [SPI1_IRQn local 0] begin */

    /* user code [SPI1_IRQn local 0] end */
[#if Peripherals?contains("#SPI1#")==true]
    hal_spi_irq(&spi1_info);
[/#if]
[#if Peripherals?contains("I2S1")==true]
    hal_i2s_irq(&i2s1_info);
[/#if]
    /* user code [SPI1_IRQn local 1] begin */

    /* user code [SPI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART0GlobalAndWakeupInterrupt ??== true && NVIC_USART0GlobalAndWakeupInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART0 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART0_IRQHandler(void)
{
    /* user code [USART0_IRQn local 0] begin */

    /* user code [USART0_IRQn local 0] end */
[#if USART0_Mode == "Asynchronous"
|| USART0_Mode == "Half Duplex"
|| USART0_Mode == "Multiprocessor"
|| USART0_Mode == "LIN"
|| USART0_Mode == "Modbus Communication"]
    hal_uart_irq(&usart0_info);
[/#if]
[#if USART0_Mode == "Synchronous Master"]
    hal_usrt_irq(&usart0_info);
[/#if]
[#if USART0_Mode == "IrDA"]
    hal_irda_irq(&usart0_info);
[/#if]
[#if USART0_Mode == "SmartCard"
|| USART0_Mode == "SmartCard With Clock"]
    hal_smartcard_irq(&usart0_info);
[/#if]
    /* user code [USART0_IRQn local 1] begin */

    /* user code [USART0_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART1GlobalAndWakeupInterrupt ??== true && NVIC_USART1GlobalAndWakeupInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART1 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART1_IRQHandler(void)
{
    /* user code [USART1_IRQn local 0] begin */

    /* user code [USART1_IRQn local 0] end */
[#if USART1_Mode == "Asynchronous"
|| USART1_Mode == "Half Duplex"
|| USART1_Mode == "Multiprocessor"
|| USART1_Mode == "LIN"
|| USART1_Mode == "Modbus Communication"]
    hal_uart_irq(&usart1_info);
[/#if]
[#if USART1_Mode == "Synchronous Master"]
    hal_usrt_irq(&usart1_info);
[/#if]
[#if USART1_Mode == "IrDA"]
    hal_irda_irq(&usart1_info);
[/#if]
[#if USART1_Mode == "SmartCard"
|| USART1_Mode == "SmartCard With Clock"]
    hal_smartcard_irq(&usart1_info);
[/#if]
    /* user code [USART1_IRQn local 1] begin */

    /* user code [USART1_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART2GlobalAndWakeupInterrupt ??== true && NVIC_USART2GlobalAndWakeupInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART2 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART2_IRQHandler(void)
{
    /* user code [USART2_IRQn local 0] begin */

    /* user code [USART2_IRQn local 0] end */
[#if USART2_Mode == "Asynchronous"
|| USART2_Mode == "Half Duplex"
|| USART2_Mode == "Multiprocessor"
|| USART2_Mode == "LIN"
|| USART2_Mode == "Modbus Communication"]
    hal_uart_irq(&usart2_info);
[/#if]
[#if USART2_Mode == "Synchronous Master"]
    hal_usrt_irq(&usart2_info);
[/#if]
[#if USART2_Mode == "IrDA"]
    hal_irda_irq(&usart2_info);
[/#if]
[#if USART2_Mode == "SmartCard"
|| USART2_Mode == "SmartCard With Clock"]
    hal_smartcard_irq(&usart2_info);
[/#if]
    /* user code [USART2_IRQn local 1] begin */

    /* user code [USART2_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1015Interrupt ??== true && NVIC_EXTILine1015Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI10_15 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI10_15_IRQHandler(void)
{
    /* user code [EXTI10_15_IRQn local 0] begin */

    /* user code [EXTI10_15_IRQn local 0] end */
    hal_exti_gpio_irq(EXTI_10_15_IRQHandler_USED);
    /* user code [EXTI10_15_IRQn local 1] begin */

    /* user code [EXTI10_15_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCAlarmFromEXTIInterrupt ??== true && NVIC_RTCAlarmFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Alarm From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTC_Alarm_IRQHandler(void)
{
    /* user code [RTC_Alarm_IRQn local 0] begin */

    /* user code [RTC_Alarm_IRQn local 0] end */
    hal_rtc_irq(&rtc_info);
    /* user code [RTC_Alarm_IRQn local 1] begin */

    /* user code [RTC_Alarm_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7BreakInterrupt ??== true && NVIC_TIMER7BreakInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Break Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_BRK_IRQHandler(void)
{
    /* user code [TIMER7_BRK_IRQn local 0] begin */

    /* user code [TIMER7_BRK_IRQn local 0] end */
    hal_timer_irq(&timer7_info);
    /* user code [TIMER7_BRK_IRQn local 1] begin */

    /* user code [TIMER7_BRK_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7UpdateInterrupt ??== true && NVIC_TIMER7UpdateInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Update Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_UP_IRQHandler(void)
{
    /* user code [TIMER7_UP_IRQn local 0] begin */

    /* user code [TIMER7_UP_IRQn local 0] end */
[#if Peripherals?contains("#TIMER7#") == true]
    hal_timer_irq(&timer7_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER7"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER7_UP_IRQn local 1] begin */

    /* user code [TIMER7_UP_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7TriggerAndCommutationInterrupt ??== true && NVIC_TIMER7TriggerAndCommutationInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Trigger And Commutation Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_TRG_CMT_IRQHandler(void)
{
    /* user code [TIMER7_TRG_CMT_IRQn local 0] begin */

    /* user code [TIMER7_TRG_CMT_IRQn local 0] end */
    hal_timer_irq(&timer7_info);
    /* user code [TIMER7_TRG_CMT_IRQn local 1] begin */

    /* user code [TIMER7_TRG_CMT_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7ChannelCaptureCompareInterrupt ??== true && NVIC_TIMER7ChannelCaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Channel Capture Compare Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_Channel_IRQHandler(void)
{
    /* user code [TIMER7_Channel_IRQn local 0] begin */

    /* user code [TIMER7_Channel_IRQn local 0] end */
    hal_timer_irq(&timer7_info);
    /* user code [TIMER7_Channel_IRQn local 1] begin */

    /* user code [TIMER7_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel7GlobalInterrupt ??== true && NVIC_DMA0Channel7GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel7 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel7_IRQHandler(void)
{
    /* user code [DMA0_Channel7_IRQn local 0] begin */

    /* user code [DMA0_Channel7_IRQn local 0] end */
[#if DMA0_CH7 ??== true]
    hal_dma_irq(&${DMA0_CH7_Info});
[/#if]
    /* user code [DMA0_Channel7_IRQn local 1] begin */

    /* user code [DMA0_Channel7_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXMCGlobalInterrupt ??== true && NVIC_EXMCGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      EXMC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXMC_IRQHandler(void)
{
    /* user code [EXMC_IRQn local 0] begin */

    /* user code [EXMC_IRQn local 0] end */
[#if EXMC_SDRAM0Data != "Disable"]
    hal_exmc_sdram_irq(&exmc_sdram0_info);
[/#if]
[#if EXMC_SDRAM1Data != "Disable"]
    hal_exmc_sdram_irq(&exmc_sdram1_info);
[/#if]
[#if EXMC_NANDFlashDataAddress != "Disable"]
	hal_exmc_nand_irq(&exmc_nand_info);
[/#if]
    /* user code [EXMC_IRQn local 1] begin */

    /* user code [EXMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_SDIO0GlobalInterrupt ??== true && NVIC_SDIO0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SDIO0 Global Interrupt
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SDIO0_IRQHandler (void)
{
    /* user code [SDIO0_IRQn local 0] begin */

    /* user code [SDIO0_IRQn local 0] end */
[#if SDIO0_Mode?contains("SD")==true]
    hal_sdio_sdcard_irq(&sdio0_info);
[/#if]
[#if SDIO0_Mode?contains("MMC")==true]
    hal_sdio_emmc_irq(&sdio0_info);
[/#if]
    /* user code [SDIO0_IRQn local 1] begin */

    /* user code [SDIO0_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER4GlobalInterrupt ??== true && NVIC_TIMER4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER4 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER4_IRQHandler(void)
{
    /* user code [TIMER4_IRQn local 0] begin */

    /* user code [TIMER4_IRQn local 0] end */
[#if Peripherals?contains("#TIMER4#") == true]
    hal_timer_irq(&timer4_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER4"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER4_IRQn local 1] begin */

    /* user code [TIMER4_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI2GlobalInterrupt ??== true && NVIC_SPI2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI2_IRQHandler(void)
{
    /* user code [SPI2_IRQn local 0] begin */

    /* user code [SPI2_IRQn local 0] end */
[#if Peripherals?contains("SPI2")==true]
    hal_spi_irq(&spi2_info);
[/#if]
[#if Peripherals?contains("I2S2")==true]
    hal_i2s_irq(&i2s2_info);
[/#if]
    /* user code [SPI2_IRQn local 1] begin */

    /* user code [SPI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART3GlobalInterrupt ??== true && NVIC_UART3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART3_IRQHandler(void)
{
    /* user code [UART3_IRQn local 0] begin */

    /* user code [UART3_IRQn local 0] end */
    hal_uart_irq(&uart3_info);
    /* user code [UART3_IRQn local 1] begin */

    /* user code [UART3_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART4GlobalInterrupt ??== true && NVIC_UART4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART4 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART4_IRQHandler(void)
{
    /* user code [UART4_IRQn local 0] begin */

    /* user code [UART4_IRQn local 0] end */
    hal_uart_irq(&uart4_info);
    /* user code [UART4_IRQn local 1] begin */

    /* user code [UART4_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER5GlobalInterruptAndDACUnderrunErrorInterrupt ??== true && NVIC_TIMER5GlobalInterruptAndDACUnderrunErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER5 Global Interrupt And DAC Underrun Error Interrupt
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER5_DAC_UDR_IRQHandler(void)
{
    /* user code [TIMER5_DAC_UDR_IRQn local 0] begin */

    /* user code [TIMER5_DAC_UDR_IRQn local 0] end */
[#if Peripherals?contains("#TIMER5#") == true]
    hal_timer_irq(&timer5_info);
[/#if]
[#if Peripherals?contains("#SYS#") == true && SYS_TimebaseSource == "TIMER5"]
    hal_sys_basetick_irq();
[/#if]
[#if Peripherals?contains("#DAC#") == true && DAC_DAC_OUT0Enable == "TRUE"]
	hal_dac_irq(&dac_info, DAC_OUT_0);
[/#if]
[#if Peripherals?contains("#DAC#") == true && DAC_DAC_OUT1Enable == "TRUE"]
	hal_dac_irq(&dac_info, DAC_OUT_1);
[/#if]
    /* user code [TIMER5_DAC_UDR_IRQn local 1] begin */

    /* user code [TIMER5_DAC_UDR_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER6GlobalInterrupt ??== true && NVIC_TIMER6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER6 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER6_IRQHandler(void)
{
    /* user code [TIMER6_IRQn local 0] begin */

    /* user code [TIMER6_IRQn local 0] end */
[#if Peripherals?contains("#TIMER6#") == true]
    hal_timer_irq(&timer6_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER6"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER6_IRQn local 1] begin */

    /* user code [TIMER6_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel0GlobalInterrupt ??== true && NVIC_DMA1Channel0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel0_IRQHandler(void)
{
    /* user code [DMA1_Channel0_IRQn local 0] begin */

    /* user code [DMA1_Channel0_IRQn local 0] end */
[#if DMA1_CH0 ??== true]
    hal_dma_irq(&${DMA1_CH0_Info});
[/#if]
    /* user code [DMA1_Channel0_IRQn local 1] begin */

    /* user code [DMA1_Channel0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel1GlobalInterrupt ??== true && NVIC_DMA1Channel1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel1_IRQHandler(void)
{
    /* user code [DMA1_Channel1_IRQn local 0] begin */

    /* user code [DMA1_Channel1_IRQn local 0] end */
[#if DMA1_CH1 ??== true]
    hal_dma_irq(&${DMA1_CH1_Info});
[/#if]
    /* user code [DMA1_Channel1_IRQn local 1] begin */

    /* user code [DMA1_Channel1_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel2GlobalInterrupt ??== true && NVIC_DMA1Channel2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel2_IRQHandler(void)
{
    /* user code [DMA1_Channel2_IRQn local 0] begin */

    /* user code [DMA1_Channel2_IRQn local 0] end */
[#if DMA1_CH2 ??== true]
    hal_dma_irq(&${DMA1_CH2_Info});
[/#if]
    /* user code [DMA1_Channel2_IRQn local 1] begin */

    /* user code [DMA1_Channel2_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel3GlobalInterrupt ??== true && NVIC_DMA1Channel3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel3_IRQHandler(void)
{
    /* user code [DMA1_Channel3_IRQn local 0] begin */

    /* user code [DMA1_Channel3_IRQn local 0] end */
[#if DMA1_CH3 ??== true]
    hal_dma_irq(&${DMA1_CH3_Info});
[/#if]
    /* user code [DMA1_Channel3_IRQn local 1] begin */

    /* user code [DMA1_Channel3_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel4GlobalInterrupt ??== true && NVIC_DMA1Channel4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel4_IRQHandler(void)
{
    /* user code [DMA1_Channel4_IRQn local 0] begin */

    /* user code [DMA1_Channel4_IRQn local 0] end */
[#if DMA1_CH4 ??== true]
    hal_dma_irq(&${DMA1_CH4_Info});
[/#if]
    /* user code [DMA1_Channel4_IRQn local 1] begin */

    /* user code [DMA1_Channel4_IRQn local 1] end */
}

[/#if]
[#if NVIC_Ethernet0GlobalInterrupt ??== true && NVIC_Ethernet0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      Ethernet0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ENET0_IRQHandler(void)
{
    /* user code [ENET0_IRQn local 0] begin */

    /* user code [ENET0_IRQn local 0] end */
    hal_enet_irq(&enet0_info);
    /* user code [ENET0_IRQn local 1] begin */

    /* user code [ENET0_IRQn local 1] end */
}

[/#if]
[#if NVIC_Ethernet0WakeupFromEXTIInterrupt ??== true && NVIC_Ethernet0WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      Ethernet0 Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ENET0_WKUP_IRQHandler (void)
{
    /* user code [ENET0_WKUP_IRQn local 0] begin */

    /* user code [ENET0_WKUP_IRQn local 0] end */
    hal_enet_wakeup_irq(&enet0_info);
    /* user code [ENET0_WKUP_IRQn local 1] begin */

    /* user code [ENET0_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel5GlobalInterrupt ??== true && NVIC_DMA1Channel5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel5 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel5_IRQHandler(void)
{
    /* user code [DMA1_Channel5_IRQn local 0] begin */

    /* user code [DMA1_Channel5_IRQn local 0] end */
[#if DMA1_CH5 ??== true]
    hal_dma_irq(&${DMA1_CH5_Info});
[/#if]
    /* user code [DMA1_Channel5_IRQn local 1] begin */

    /* user code [DMA1_Channel5_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel6GlobalInterrupt ??== true && NVIC_DMA1Channel6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel6 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel6_IRQHandler(void)
{
    /* user code [DMA1_Channel6_IRQn local 0] begin */

    /* user code [DMA1_Channel6_IRQn local 0] end */
[#if DMA1_CH6 ??== true]
    hal_dma_irq(&${DMA1_CH6_Info});
[/#if]
    /* user code [DMA1_Channel6_IRQn local 1] begin */

    /* user code [DMA1_Channel6_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel7GlobalInterrupt ??== true && NVIC_DMA1Channel7GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel7 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel7_IRQHandler(void)
{
    /* user code [DMA1_Channel7_IRQn local 0] begin */

    /* user code [DMA1_Channel7_IRQn local 0] end */
[#if DMA1_CH7 ??== true]
    hal_dma_irq(&${DMA1_CH7_Info});
[/#if]
    /* user code [DMA1_Channel7_IRQn local 1] begin */

    /* user code [DMA1_Channel7_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART5GlobalAndWakeupInterrupt ??== true && NVIC_USART5GlobalAndWakeupInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART5 Global And Wakeup Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART5_IRQHandler(void)
{
    /* user code [USART5_IRQn local 0] begin */

    /* user code [USART5_IRQn local 0] end */
[#if USART5_Mode == "Asynchronous"
|| USART5_Mode == "Half Duplex"
|| USART5_Mode == "Multiprocessor"
|| USART5_Mode == "LIN"
|| USART5_Mode == "Modbus Communication"]
    hal_uart_irq(&usart5_info);
[/#if]
[#if USART5_Mode == "Synchronous Master"]
    hal_usrt_irq(&usart5_info);
[/#if]
[#if USART5_Mode == "IrDA"]
    hal_irda_irq(&usart5_info);
[/#if]
[#if USART5_Mode == "SmartCard"
|| USART5_Mode == "SmartCard With Clock"]
    hal_smartcard_irq(&usart5_info);
[/#if]
    /* user code [USART5_IRQn local 1] begin */

    /* user code [USART5_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C2EventInterrupt ??== true && NVIC_I2C2EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C2 Event Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C2_EV_IRQHandler (void)
{
    /* user code [I2C2_EV_IRQn local 0] begin */

    /* user code [I2C2_EV_IRQn local 0] end */
[#if I2C2_Mode =="I2C"]
    hal_i2c_event_irq(&i2c2_info);
[/#if]
[#if I2C2_Mode?contains("SMBus")==true]
    hal_smbus_event_irq(&smbus2_info);
[/#if]
    /* user code [I2C2_EV_IRQn local 1] begin */

    /* user code [I2C2_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C2ErrorInterrupt ??== true && NVIC_I2C2ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C2 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C2_ER_IRQHandler(void)
{
    /* user code [I2C2_ER_IRQn local 0] begin */

    /* user code [I2C2_ER_IRQn local 0] end */
[#if I2C2_Mode =="I2C"]
    hal_i2c_error_irq(&i2c2_info);
[/#if]
[#if I2C2_Mode?contains("SMBus")==true]
    hal_smbus_error_irq(&smbus2_info);
[/#if]
    /* user code [I2C2_ER_IRQn local 1] begin */

    /* user code [I2C2_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS0Endpoint1OutInterrupt ??== true && NVIC_USBHS0Endpoint1OutInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS0 Endpoint1 Out Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS0_EP1_OUT_IRQHandler(void)
{
    /* user code [USBHS0_EP1_OUT_IRQn local 0] begin */

    /* user code [USBHS0_EP1_OUT_IRQn local 0] end */
[#if USBHS0_USB0Device_DedicatedEndpoint1Configuration=="Enable"]
	hal_hs0_usbd_int_dedicated_ep1out();
[/#if]
    /* user code [USBHS0_EP1_OUT_IRQn local 1] begin */

    /* user code [USBHS0_EP1_OUT_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS0Endpoint1InInterrupt ??== true && NVIC_USBHS0Endpoint1InInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS0 Endpoint1 In Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS0_EP1_In_IRQHandler(void)
{
    /* user code [USBHS0_EP1_In_IRQn local 0] begin */

    /* user code [USBHS0_EP1_In_IRQn local 0] end */
[#if USBHS0_USB0Device_DedicatedEndpoint1Configuration=="Enable"]
	hal_hs0_usbd_int_dedicated_ep1in();
[/#if]
    /* user code [USBHS0_EP1_In_IRQn local 1] begin */

    /* user code [USBHS0_EP1_In_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS0WakeupFromEXTIInterrupt ??== true && NVIC_USBHS0WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS0 Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS0_WKUP_IRQHandler(void)
{
    /* user code [USBHS0_WKUP_IRQn local 0] begin */

    /* user code [USBHS0_WKUP_IRQn local 0] end */
	hal_hs0_usbhs_wakeup_irq();
    /* user code [USBHS0_WKUP_IRQn local 1] begin */

    /* user code [USBHS0_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS0GlobalInterrupt ??== true && NVIC_USBHS0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS0_IRQHandler(void)
{
    /* user code [USBHS0_IRQn local 0] begin */

    /* user code [USBHS0_IRQn local 0] end */
[#if USBHS0_USB0Mode == "USB0 Host"]
	hal_hs0_usbh_irq();
[/#if]
[#if USBHS0_USB0Mode == "USB0 Device"]
	hal_hs0_usbd_irq();
[/#if]
    /* user code [USBHS0_IRQn local 1] begin */

    /* user code [USBHS0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DCIGlobalInterrupt ??== true && NVIC_DCIGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DCI Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DCI_IRQHandler(void)
{
    /* user code [DCI_IRQn local 0] begin */

    /* user code [DCI_IRQn local 0] end */
    hal_dci_irq(&dci_info);
    /* user code [DCI_IRQn local 1] begin */

    /* user code [DCI_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAUGlobalInterrupt ??== true && NVIC_CAUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAU_IRQHandler(void)
{
    /* user code [CAU_IRQn local 0] begin */

    /* user code [CAU_IRQn local 0] end */
    hal_cau_irq(&cau_info);
    /* user code [CAU_IRQn local 1] begin */

    /* user code [CAU_IRQn local 1] end */
}

[/#if]
[#if NVIC_HAUAndTRNGGlobalInterrupt ??== true && NVIC_HAUAndTRNGGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      HAU And TRNG Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HAU_TRNG_IRQHandler(void)
{
    /* user code [HAU_TRNG_IRQn local 0] begin */

    /* user code [HAU_TRNG_IRQn local 0] end */
[#if HAU_HAUEnable ??== true]
    hal_hau_irq(&hau_info);
[/#if]
[#if  TRNG_TRNGEnable ??== true]
    hal_trng_irq(&trng_info);
[/#if]
    /* user code [HAU_TRNG_IRQn local 1] begin */

    /* user code [HAU_TRNG_IRQn local 1] end */
}

[/#if]
[#if NVIC_FPUGlobalInterrupt ??== true && NVIC_FPUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FPU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FPU_IRQHandler(void)
{
    /* user code [FPU_IRQn local 0] begin */

    /* user code [FPU_IRQn local 0] end */
    /* user code [FPU_IRQn local 1] begin */

    /* user code [FPU_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART6GlobalInterrupt ??== true && NVIC_UART6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART6 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART6_IRQHandler(void)
{
    /* user code [UART6_IRQn local 0] begin */

    /* user code [UART6_IRQn local 0] end */
    hal_uart_irq(&uart6_info);
    /* user code [UART6_IRQn local 1] begin */

    /* user code [UART6_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART7GlobalInterrupt ??== true && NVIC_UART7GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART7 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART7_IRQHandler(void)
{
    /* user code [UART7_IRQn local 0] begin */

    /* user code [UART7_IRQn local 0] end */
    hal_uart_irq(&uart7_info);
    /* user code [UART7_IRQn local 1] begin */

    /* user code [UART7_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI3GlobalInterrupt ??== true && NVIC_SPI3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI3_IRQHandler(void)
{
    /* user code [SPI3_IRQn local 0] begin */

    /* user code [SPI3_IRQn local 0] end */
    hal_spi_irq(&spi3_info);
    /* user code [SPI3_IRQn local 1] begin */

    /* user code [SPI3_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI4GlobalInterrupt ??== true && NVIC_SPI4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI4 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI4_IRQHandler(void)
{
    /* user code [SPI4_IRQn local 0] begin */

    /* user code [SPI4_IRQn local 0] end */
    hal_spi_irq(&spi4_info);
    /* user code [SPI4_IRQn local 1] begin */

    /* user code [SPI4_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI5GlobalInterrupt ??== true && NVIC_SPI5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI5 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI5_IRQHandler(void)
{
    /* user code [SPI5_IRQn local 0] begin */

    /* user code [SPI5_IRQn local 0] end */
[#if Peripherals?contains("#SPI5#")==true]
    hal_spi_irq(&spi5_info);
[/#if]
[#if Peripherals?contains("I2S5")==true]
    hal_i2s_irq(&i2s5_info);
[/#if]
    /* user code [SPI5_IRQn local 1] begin */

    /* user code [SPI5_IRQn local 1] end */
}

[/#if]
[#if NVIC_SAI0GlobalInterrupt ??== true && NVIC_SAI0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SAI0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SAI0_IRQHandler (void)
{
    /* user code [SAI0_IRQn local 0] begin */

    /* user code [SAI0_IRQn local 0] end */
[#if SAI0_BLOCK0Mode != "Disable"]
    hal_sai_irq(&sai0_block0_info);
[/#if]
[#if SAI0_BLOCK1Mode != "Disable"]
    hal_sai_irq(&sai0_block1_info);
[/#if]
    /* user code [SAI0_IRQn local 1] begin */

    /* user code [SAI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_TLIGlobalInterrupt ??== true && NVIC_TLIGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TLI Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TLI_IRQHandler(void)
{
    /* user code [TLI_IRQn local 0] begin */

    /* user code [TLI_IRQn local 0] end */
    hal_tli_irq(&tli_info);
    /* user code [TLI_IRQn local 1] begin */

    /* user code [TLI_IRQn local 1] end */
}

[/#if]
[#if NVIC_TLIErrorInterrupt ??== true && NVIC_TLIErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TLI Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TLI_ER_IRQHandler(void)
{
    /* user code [TLI_ER_IRQn local 0] begin */

    /* user code [TLI_ER_IRQn local 0] end */
    hal_tli_error_irq(&tli_info);
    /* user code [TLI_ER_IRQn local 1] begin */

    /* user code [TLI_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_IPAGlobalInterrupt ??== true && NVIC_IPAGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      IPA Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void IPA_IRQHandler(void)
{
    /* user code [IPA_IRQn local 0] begin */

    /* user code [IPA_IRQn local 0] end */
    hal_ipa_irq(&ipa_info);
    /* user code [IPA_IRQn local 1] begin */

    /* user code [IPA_IRQn local 1] end */
}

[/#if]
[#if NVIC_SAI1GlobalInterrupt ??== true && NVIC_SAI1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SAI1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SAI1_IRQHandler(void)
{
    /* user code [SAI1_IRQn local 0] begin */

    /* user code [SAI1_IRQn local 0] end */
[#if SAI1_BLOCK0Mode != "Disable"]
    hal_sai_irq(&sai1_block0_info);
[/#if]
[#if SAI1_BLOCK1Mode != "Disable"]
    hal_sai_irq(&sai1_block1_info);
[/#if]
    /* user code [SAI1_IRQn local 1] begin */

    /* user code [SAI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_OSPI0GlobalInterrupt ??== true && NVIC_OSPI0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      OSPI0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void OSPI0_IRQHandler(void)
{
    /* user code [OSPI0_IRQn local 0] begin */

    /* user code [OSPI0_IRQn local 0] end */
    hal_ospi_irq(&ospi0_info);
    /* user code [OSPI0_IRQn local 1] begin */

    /* user code [OSPI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3EventInterrupt ??== true && NVIC_I2C3EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Event Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_EV_IRQHandler(void)
{
    /* user code [I2C3_EV_IRQn local 0] begin */

    /* user code [I2C3_EV_IRQn local 0] end */
[#if I2C3_Mode =="I2C"]
    hal_i2c_event_irq(&i2c3_info);
[/#if]
[#if I2C3_Mode?contains("SMBus")==true]
    hal_smbus_event_irq(&smbus3_info);
[/#if]
    /* user code [I2C3_EV_IRQn local 1] begin */

    /* user code [I2C3_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3ErrorInterrupt ??== true && NVIC_I2C3ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_ER_IRQHandler(void)
{
    /* user code [I2C3_ER_IRQn local 0] begin */

    /* user code [I2C3_ER_IRQn local 0] end */
[#if I2C3_Mode =="I2C"]
    hal_i2c_error_irq(&i2c3_info);
[/#if]
[#if I2C3_Mode?contains("SMBus")==true]
    hal_smbus_error_irq(&smbus3_info);
[/#if]
    /* user code [I2C3_ER_IRQn local 1] begin */

    /* user code [I2C3_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_RSPDIFGlobalInterrupt ??== true && NVIC_RSPDIFGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      RSPDIF Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RSPDIF_IRQHandler(void)
{
    /* user code [RSPDIF_IRQn local 0] begin */

    /* user code [RSPDIF_IRQn local 0] end */
    hal_rspdif_irq(&rspdif_info);
    /* user code [RSPDIF_IRQn local 1] begin */

    /* user code [RSPDIF_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMAMUXOverrunInterrupt ??== true && NVIC_DMAMUXOverrunInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMAMUX Overrun Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMAMUX_OVR_IRQHandler(void)
{
    /* user code [DMAMUX_OVR_IRQn local 0] begin */

    /* user code [DMAMUX_OVR_IRQn local 0] end */
[#if DMA0_CH0 ??== true]
    hal_dma_irq(&${DMA0_CH0_Info});
[/#if]
[#if DMA0_CH1 ??== true]
    hal_dma_irq(&${DMA0_CH1_Info});
[/#if]
[#if DMA0_CH2 ??== true]
    hal_dma_irq(&${DMA0_CH2_Info});
[/#if]
[#if DMA0_CH3 ??== true]
    hal_dma_irq(&${DMA0_CH3_Info});
[/#if]
[#if DMA0_CH4 ??== true]
    hal_dma_irq(&${DMA0_CH4_Info});
[/#if]
[#if DMA0_CH5 ??== true]
    hal_dma_irq(&${DMA0_CH5_Info});
[/#if]
[#if DMA0_CH6 ??== true]
    hal_dma_irq(&${DMA0_CH6_Info});
[/#if]
[#if DMA0_CH7 ??== true]
    hal_dma_irq(&${DMA0_CH7_Info});
[/#if]
[#if DMA1_CH0 ??== true]
    hal_dma_irq(&${DMA1_CH0_Info});
[/#if]
[#if DMA1_CH1 ??== true]
    hal_dma_irq(&${DMA1_CH1_Info});
[/#if]
[#if DMA1_CH2 ??== true]
    hal_dma_irq(&${DMA1_CH2_Info});
[/#if]
[#if DMA1_CH3 ??== true]
    hal_dma_irq(&${DMA1_CH3_Info});
[/#if]
[#if DMA1_CH4 ??== true]
    hal_dma_irq(&${DMA1_CH4_Info});
[/#if]
[#if DMA1_CH5 ??== true]
    hal_dma_irq(&${DMA1_CH5_Info});
[/#if]
[#if DMA1_CH6 ??== true]
    hal_dma_irq(&${DMA1_CH6_Info});
[/#if]
[#if DMA1_CH7 ??== true]
    hal_dma_irq(&${DMA1_CH7_Info});
[/#if]
    /* user code [DMAMUX_OVR_IRQn local 1] begin */

    /* user code [DMAMUX_OVR_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal0Interrupt ??== true && NVIC_HPDFGlobal0Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT0_IRQHandler(void)
{
    /* user code [HPDF_INT0_IRQn local 0] begin */

    /* user code [HPDF_INT0_IRQn local 0] end */
    hal_hpdf_irq(&hpdf_info);
    /* user code [HPDF_INT0_IRQn local 1] begin */

    /* user code [HPDF_INT0_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal1Interrupt ??== true && NVIC_HPDFGlobal1Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT1_IRQHandler(void)
{
    /* user code [HPDF_INT1_IRQn local 0] begin */

    /* user code [HPDF_INT1_IRQn local 0] end */
    hal_hpdf_irq(&hpdf_info);
    /* user code [HPDF_INT1_IRQn local 1] begin */

    /* user code [HPDF_INT1_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal2Interrupt ??== true && NVIC_HPDFGlobal2Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT2_IRQHandler(void)
{
    /* user code [HPDF_INT2_IRQn local 0] begin */

    /* user code [HPDF_INT2_IRQn local 0] end */
    hal_hpdf_irq(&hpdf_info);
    /* user code [HPDF_INT2_IRQn local 1] begin */

    /* user code [HPDF_INT2_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal3Interrupt ??== true && NVIC_HPDFGlobal3Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT3_IRQHandler(void)
{
    /* user code [HPDF_INT3_IRQn local 0] begin */

    /* user code [HPDF_INT3_IRQn local 0] end */
    hal_hpdf_irq(&hpdf_info);
    /* user code [HPDF_INT3_IRQn local 1] begin */

    /* user code [HPDF_INT3_IRQn local 1] end */
}

[/#if]
[#if NVIC_SAI2GlobalInterrupt ??== true && NVIC_SAI2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SAI2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SAI2_IRQHandler(void)
{
    /* user code [SAI2_IRQn local 0] begin */

    /* user code [SAI2_IRQn local 0] end */
[#if SAI2_BLOCK0Mode != "Disable"]
    hal_sai_irq(&sai2_block0_info);
[/#if]
[#if SAI2_BLOCK1Mode != "Disable"]
    hal_sai_irq(&sai2_block1_info);
[/#if]
    /* user code [SAI2_IRQn local 1] begin */

    /* user code [SAI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER14GlobalInterrupt ??== true && NVIC_TIMER14GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER14 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER14_IRQHandler(void)
{
    /* user code [TIMER14_IRQn local 0] begin */

    /* user code [TIMER14_IRQn local 0] end */
[#if Peripherals?contains("#TIMER14#") == true]
    hal_timer_irq(&timer14_info);
[/#if]
[#if SYS_TimebaseSource=="TIMER14"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER14_IRQn local 1] begin */

    /* user code [TIMER14_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER15GlobalInterrupt ??== true && NVIC_TIMER15GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER15 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER15_IRQHandler(void)
{
    /* user code [TIMER15_IRQn local 0] begin */

    /* user code [TIMER15_IRQn local 0] end */
[#if Peripherals?contains("#TIMER15#") == true]
    hal_timer_irq(&timer15_info);
[/#if]
[#if SYS_TimebaseSource=="TIMER15"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER15_IRQn local 1] begin */

    /* user code [TIMER15_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER16GlobalInterrupt ??== true && NVIC_TIMER16GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER16 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER16_IRQHandler(void)
{
    /* user code [TIMER16_IRQn local 0] begin */

    /* user code [TIMER16_IRQn local 0] end */
[#if Peripherals?contains("#TIMER16#") == true]
    hal_timer_irq(&timer16_info);
[/#if]
[#if SYS_TimebaseSource=="TIMER16"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER16_IRQn local 1] begin */

    /* user code [TIMER16_IRQn local 1] end */
}

[/#if]
[#if NVIC_MDIOGlobalInterrupt ??== true && NVIC_MDIOGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      MDIO Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void MDIO_IRQHandler (void)
{
    /* user code [MDIO_IRQn local 0] begin */

    /* user code [MDIO_IRQn local 0] end */
    hal_mdio_irq(&mdio_info);
    /* user code [MDIO_IRQn local 1] begin */

    /* user code [MDIO_IRQn local 1] end */
}

[/#if]
[#if NVIC_MDMAGlobalInterrupt ??== true && NVIC_MDMAGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      MDMA Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void MDMA_IRQHandler(void)
{
    /* user code [MDMA_IRQn local 0] begin */

    /* user code [MDMA_IRQn local 0] end */
[#if MDMA_CH0 ??== true]
    hal_mdma_irq(&mdma_ch0_info);
[/#if]
[#if MDMA_CH1 ??== true]
    hal_mdma_irq(&mdma_ch1_info);
[/#if]
[#if MDMA_CH2 ??== true]
    hal_mdma_irq(&mdma_ch2_info);
[/#if]
[#if MDMA_CH3 ??== true]
    hal_mdma_irq(&mdma_ch3_info);
[/#if]
[#if MDMA_CH4 ??== true]
    hal_mdma_irq(&mdma_ch4_info);
[/#if]
[#if MDMA_CH5 ??== true]
    hal_mdma_irq(&mdma_ch5_info);
[/#if]
[#if MDMA_CH6 ??== true]
    hal_mdma_irq(&mdma_ch6_info);
[/#if]
[#if MDMA_CH7 ??== true]
    hal_mdma_irq(&mdma_ch7_info);
[/#if]
[#if MDMA_CH8 ??== true]
    hal_mdma_irq(&mdma_ch8_info);
[/#if]
[#if MDMA_CH9 ??== true]
    hal_mdma_irq(&mdma_ch9_info);
[/#if]
[#if MDMA_CH10 ??== true]
    hal_mdma_irq(&mdma_ch10_info);
[/#if]
[#if MDMA_CH11 ??== true]
    hal_mdma_irq(&mdma_ch11_info);
[/#if]
[#if MDMA_CH12 ??== true]
    hal_mdma_irq(&mdma_ch12_info);
[/#if]
[#if MDMA_CH13 ??== true]
    hal_mdma_irq(&mdma_ch13_info);
[/#if]
[#if MDMA_CH14 ??== true]
    hal_mdma_irq(&mdma_ch14_info);
[/#if]
[#if MDMA_CH15 ??== true]
    hal_mdma_irq(&mdma_ch15_info);
[/#if]
    /* user code [MDMA_IRQn local 1] begin */

    /* user code [MDMA_IRQn local 1] end */
}

[/#if]
[#if NVIC_SDIO1GlobalInterrupt ??== true && NVIC_SDIO1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SDIO1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SDIO1_IRQHandler (void)
{
    /* user code [SDIO1_IRQn local 0] begin */

    /* user code [SDIO1_IRQn local 0] end */
[#if SDIO1_Mode?contains("SD")==true]
    hal_sdio_sdcard_irq(&sdio1_info);
[/#if]
[#if SDIO1_Mode?contains("MMC")==true]
    hal_sdio_emmc_irq(&sdio1_info);
[/#if]
    /* user code [SDIO1_IRQn local 1] begin */

    /* user code [SDIO1_IRQn local 1] end */
}

[/#if]
[#if NVIC_HWSEMGlobalInterrupt ??== true && NVIC_HWSEMGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      HWSEM Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HWSEM_IRQHandler(void)
{
    /* user code [HWSEM_IRQn local 0] begin */

    /* user code [HWSEM_IRQn local 0] end */
    hal_hwsem_irq(&hwsem_info);
    /* user code [HWSEM_IRQn local 1] begin */

    /* user code [HWSEM_IRQn local 1] end */
}

[/#if]
[#if NVIC_ADC2GlobalInterrupt ??== true && NVIC_ADC2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      ADC2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ADC2_IRQHandler(void)
{
    /* user code [ADC2_IRQn local 0] begin */

    /* user code [ADC2_IRQn local 0] end */
    hal_adc_irq(&adc2_info);
    /* user code [ADC2_IRQn local 1] begin */

    /* user code [ADC2_IRQn local 1] end */
}

[/#if]
[#if NVIC_CMP0AndCMP1GlobalInterruptCMP0AndCMP1ThroughEXTILineDetectionInterrupt ??== true && NVIC_CMP0AndCMP1GlobalInterruptCMP0AndCMP1ThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      CMP0 And CMP1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CMP0_1_IRQHandler(void)
{
    /* user code [CMP0_1_IRQn local 0] begin */

    /* user code [CMP0_1_IRQn local 0] end */
[#if CMP0_InvertingInput ??==true && CMP0_InvertingInput != "Disable"]
    hal_cmp_irq(&cmp0_info);
[/#if]
[#if CMP1_InvertingInput ??==true && CMP1_InvertingInput != "Disable"]
    hal_cmp_irq(&cmp1_info);
[/#if]
    /* user code [CMP0_1_IRQn local 1] begin */

    /* user code [CMP0_1_IRQn local 1] end */
}

[/#if]
[#if NVIC_CTCInterrupt ??== true && NVIC_CTCInterrupt_Enabled == "TRUE"]
/*!
    \brief      CTC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CTC_IRQHandler(void)
{
    /* user code [CTC_IRQn local 0] begin */

    /* user code [CTC_IRQn local 0] end */
    hal_ctc_irq(&ctc_info);
    /* user code [CTC_IRQn local 1] begin */

    /* user code [CTC_IRQn local 1] end */
}

[/#if]
[#if NVIC_RAMECCMUGlobalInterrupt ??== true && NVIC_RAMECCMUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      RAMECCMU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RAMECCMU_IRQHandler(void)
{
    /* user code [RAMECCMU_IRQn local 0] begin */

    /* user code [RAMECCMU_IRQn local 0] end */
    hal_rameccmu_irq(&rameccmu_info);
    /* user code [RAMECCMU_IRQn local 1] begin */

    /* user code [RAMECCMU_IRQn local 1] end */
}

[/#if]
[#if NVIC_OSPI1GlobalInterrupt ??== true && NVIC_OSPI1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      QSPI1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void OSPI1_IRQHandler(void)
{
    /* user code [OSPI1_IRQn local 0] begin */

    /* user code [OSPI1_IRQn local 0] end */
    hal_ospi_irq(&ospi1_info);
    /* user code [OSPI1_IRQn local 1] begin */

    /* user code [OSPI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTDEC0GlobalInterrupt ??== true && NVIC_RTDEC0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTDEC0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTDEC0_IRQHandler(void)
{
    /* user code [RTDEC0_IRQn local 0] begin */

    /* user code [RTDEC0_IRQn local 0] end */
    hal_rtdec_irq(&rtdec0_info);
    /* user code [RTDEC0_IRQn local 1] begin */

    /* user code [RTDEC0_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTDEC1GlobalInterrupt ??== true && NVIC_RTDEC1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTDEC1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTDEC1_IRQHandler(void)
{
    /* user code [RTDEC1_IRQn local 0] begin */

    /* user code [RTDEC1_IRQn local 0] end */
    hal_rtdec_irq(&rtdec1_info);
    /* user code [RTDEC1_IRQn local 1] begin */

    /* user code [RTDEC1_IRQn local 1] end */
}

[/#if]
[#if NVIC_FACGlobalInterrupt ??== true && NVIC_FACGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FAC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FAC_IRQHandler(void)
{
    /* user code [FAC_IRQn local 0] begin */

    /* user code [FAC_IRQn local 0] end */
    hal_fac_irq(&fac_info);
    /* user code [FAC_IRQn local 1] begin */

    /* user code [FAC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TMUGlobalInterrupt ??== true && NVIC_TMUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TMU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TMU_IRQHandler(void)
{
    /* user code [TMU_IRQn local 0] begin */

    /* user code [TMU_IRQn local 0] end */
    hal_tmu_irq(&tmu_info);
    /* user code [TMU_IRQn local 1] begin */

    /* user code [TMU_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER22GlobalInterrupt ??== true && NVIC_TIMER22GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER22 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER22_IRQHandler(void)
{
    /* user code [TIMER22_IRQn local 0] begin */

    /* user code [TIMER22_IRQn local 0] end */
[#if Peripherals?contains("#TIMER22#") == true]
    hal_timer_irq(&timer22_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER22"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER22_IRQn local 1] begin */

    /* user code [TIMER22_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER23GlobalInterrupt ??== true && NVIC_TIMER23GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER23 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER23_IRQHandler(void)
{
    /* user code [TIMER23_IRQn local 0] begin */

    /* user code [TIMER23_IRQn local 0] end */
[#if Peripherals?contains("#TIMER23#") == true]
    hal_timer_irq(&timer23_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER23"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER23_IRQn local 1] begin */

    /* user code [TIMER23_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER30GlobalInterrupt ??== true && NVIC_TIMER30GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER30 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER30_IRQHandler(void)
{
    /* user code [TIMER30_IRQn local 0] begin */

    /* user code [TIMER30_IRQn local 0] end */
[#if Peripherals?contains("#TIMER30#") == true]
    hal_timer_irq(&timer30_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER30"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER30_IRQn local 1] begin */

    /* user code [TIMER30_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER31GlobalInterrupt ??== true && NVIC_TIMER31GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER31 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER31_IRQHandler(void)
{
    /* user code [TIMER31_IRQn local 0] begin */

    /* user code [TIMER31_IRQn local 0] end */
[#if Peripherals?contains("#TIMER31#") == true]
    hal_timer_irq(&timer31_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER31"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER31_IRQn local 1] begin */

    /* user code [TIMER31_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER40GlobalInterrupt ??== true && NVIC_TIMER40GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER40 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER40_IRQHandler(void)
{
    /* user code [TIMER40_IRQn local 0] begin */

    /* user code [TIMER40_IRQn local 0] end */
[#if Peripherals?contains("#TIMER40#") == true]
    hal_timer_irq(&timer40_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER40"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER40_IRQn local 1] begin */

    /* user code [TIMER40_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER41GlobalInterrupt ??== true && NVIC_TIMER41GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER41 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER41_IRQHandler(void)
{
    /* user code [TIMER41_IRQn local 0] begin */

    /* user code [TIMER41_IRQn local 0] end */
[#if Peripherals?contains("#TIMER41#") == true]
    hal_timer_irq(&timer41_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER41"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER41_IRQn local 1] begin */

    /* user code [TIMER41_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER42GlobalInterrupt ??== true && NVIC_TIMER42GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER42 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER42_IRQHandler(void)
{
    /* user code [TIMER42_IRQn local 0] begin */

    /* user code [TIMER42_IRQn local 0] end */
[#if Peripherals?contains("#TIMER42#") == true]
    hal_timer_irq(&timer42_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER42"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER42_IRQn local 1] begin */

    /* user code [TIMER42_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER43GlobalInterrupt ??== true && NVIC_TIMER43GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER43 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER43_IRQHandler(void)
{
    /* user code [TIMER43_IRQn local 0] begin */

    /* user code [TIMER43_IRQn local 0] end */
[#if Peripherals?contains("#TIMER43#") == true]
    hal_timer_irq(&timer43_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER43"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER43_IRQn local 1] begin */

    /* user code [TIMER43_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER44GlobalInterrupt ??== true && NVIC_TIMER44GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER44 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER44_IRQHandler(void)
{
    /* user code [TIMER44_IRQn local 0] begin */

    /* user code [TIMER44_IRQn local 0] end */
[#if Peripherals?contains("#TIMER44#") == true]
    hal_timer_irq(&timer44_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER44"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER44_IRQn local 1] begin */

    /* user code [TIMER44_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER50GlobalInterrupt ??== true && NVIC_TIMER50GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER50 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER50_IRQHandler(void)
{
    /* user code [TIMER50_IRQn local 0] begin */

    /* user code [TIMER50_IRQn local 0] end */
[#if Peripherals?contains("#TIMER50#") == true]
    hal_timer_irq(&timer50_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER50"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER50_IRQn local 1] begin */

    /* user code [TIMER50_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER51GlobalInterrupt ??== true && NVIC_TIMER51GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER51 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER51_IRQHandler(void)
{
    /* user code [TIMER51_IRQn local 0] begin */

    /* user code [TIMER51_IRQn local 0] end */
[#if Peripherals?contains("#TIMER51#") == true]
    hal_timer_irq(&timer51_info);
[/#if]
[#if SYS_TimebaseSource == "TIMER51"]
    hal_sys_basetick_irq();
[/#if]
    /* user code [TIMER51_IRQn local 1] begin */

    /* user code [TIMER51_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS1Endpoint1OutInterrupt ??== true && NVIC_USBHS1Endpoint1OutInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS1 Endpoint1 Out Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS1_EP1_OUT_IRQHandler(void)
{
    /* user code [USBHS1_EP1_OUT_IRQn local 0] begin */

    /* user code [USBHS1_EP1_OUT_IRQn local 0] end */
[#if USBHS1_USB1Device_DedicatedEndpoint1Configuration=="Enable"]
	hal_hs1_usbd_int_dedicated_ep1out();
[/#if]
    /* user code [USBHS1_EP1_OUT_IRQn local 1] begin */

    /* user code [USBHS1_EP1_OUT_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS1Endpoint1InInterrupt ??== true && NVIC_USBHS1Endpoint1InInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS1 Endpoint1 In Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS1_EP1_IN_IRQHandler(void)
{
    /* user code [USBHS1_EP1_IN_IRQn local 0] begin */

    /* user code [USBHS1_EP1_IN_IRQn local 0] end */
[#if USBHS1_USB1Device_DedicatedEndpoint1Configuration=="Enable"]
	hal_hs1_usbd_int_dedicated_ep1in();
[/#if]
    /* user code [USBHS1_EP1_IN_IRQn local 1] begin */

    /* user code [USBHS1_EP1_IN_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS1WakeupFromEXTIInterrupt ??== true && NVIC_USBHS1WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS1 Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS1_WKUP_IRQHandler (void)
{
    /* user code [USBHS1_WKUP_IRQn local 0] begin */

    /* user code [USBHS1_WKUP_IRQn local 0] end */
	hal_hs1_usbhs_wakeup_irq();
    /* user code [USBHS1_WKUP_IRQn local 1] begin */

    /* user code [USBHS1_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHS1GlobalInterrupt ??== true && NVIC_USBHS1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS1_IRQHandler(void)
{
    /* user code [USBHS1_IRQn local 0] begin */

    /* user code [USBHS1_IRQn local 0] end */
[#if USBHS1_USB1Mode == "USB1 Host"]
	hal_hs1_usbh_irq();
[/#if]
[#if USBHS1_USB1Mode == "USB1 Device"]
	hal_hs1_usbd_irq();
[/#if]
    /* user code [USBHS1_IRQn local 1] begin */

    /* user code [USBHS1_IRQn local 1] end */
}

[/#if]
[#if NVIC_Ethernet1GlobalInterrupt ??== true && NVIC_Ethernet1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      Ethernet1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ENET1_IRQHandler(void)
{
    /* user code [ENET1_IRQn local 0] begin */

    /* user code [ENET1_IRQn local 0] end */
    hal_enet_irq(&enet1_info);
    /* user code [ENET1_IRQn local 1] begin */

    /* user code [ENET1_IRQn local 1] end */
}

[/#if]
[#if NVIC_Ethernet1WakeupFromEXTIInterrupt ??== true && NVIC_Ethernet1WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      Ethernet1 Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ENET1_WKUP_IRQHandler (void)
{
    /* user code [ENET1_WKUP_IRQn local 0] begin */

    /* user code [ENET1_WKUP_IRQn local 0] end */
    hal_enet_wakeup_irq(&enet1_info);
    /* user code [ENET1_WKUP_IRQn local 1] begin */

    /* user code [ENET1_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_CAN0WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN0 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_WKUP_IRQHandler(void)
{
    /* user code [CAN0_WKUP_IRQn local 0] begin */

    /* user code [CAN0_WKUP_IRQn local 0] end */
    hal_can_irq(&can0_info);
    /* user code [CAN0_WKUP_IRQn local 1] begin */

    /* user code [CAN0_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForMessageBuffer ??== true && NVIC_CAN0InterruptForMessageBuffer_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Message Buffer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_Message_IRQHandler(void)
{
    /* user code [CAN0_Message_IRQn local 0] begin */

    /* user code [CAN0_Message_IRQn local 0] end */
    hal_can_irq(&can0_info);
    /* user code [CAN0_Message_IRQn local 1] begin */

    /* user code [CAN0_Message_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForBusOffBusOffDone ??== true && NVIC_CAN0InterruptForBusOffBusOffDone_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Bus Off / Bus Off Done Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_Busoff_IRQHandler(void)
{
    /* user code [CAN0_Busoff_IRQn local 0] begin */

    /* user code [CAN0_Busoff_IRQn local 0] end */
    hal_can_irq(&can0_info);
    /* user code [CAN0_Busoff_IRQn local 1] begin */

    /* user code [CAN0_Busoff_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForError ??== true && NVIC_CAN0InterruptForError_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_Error_IRQHandler(void)
{
    /* user code [CAN0_Error_IRQn local 0] begin */

    /* user code [CAN0_Error_IRQn local 0] end */
    hal_can_irq(&can0_info);
    /* user code [CAN0_Error_IRQn local 1] begin */

    /* user code [CAN0_Error_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForErrorInFastTransmission ??== true && NVIC_CAN0InterruptForErrorInFastTransmission_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Error In Fast Transmission Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_FastError_IRQHandler(void)
{
    /* user code [CAN0_FastError_IRQn local 0] begin */

    /* user code [CAN0_FastError_IRQn local 0] end */
    hal_can_irq(&can0_info);
    /* user code [CAN0_FastError_IRQn local 1] begin */

    /* user code [CAN0_FastError_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForTransmitWarning ??== true && NVIC_CAN0InterruptForTransmitWarning_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Transmit Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_TEC_IRQHandler(void)
{
    /* user code [CAN0_TEC_IRQn local 0] begin */

    /* user code [CAN0_TEC_IRQn local 0] end */
    hal_can_irq(&can0_info);
    /* user code [CAN0_TEC_IRQn local 1] begin */

    /* user code [CAN0_TEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForReceiveWarning ??== true && NVIC_CAN0InterruptForReceiveWarning_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Receive Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_REC_IRQHandler(void)
{
    /* user code [CAN0_REC_IRQn local 0] begin */

    /* user code [CAN0_REC_IRQn local 0] end */
    hal_can_irq(&can0_info);
    /* user code [CAN0_REC_IRQn local 1] begin */

    /* user code [CAN0_REC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_CAN1WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN1 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_WKUP_IRQHandler(void)
{
    /* user code [CAN1_WKUP_IRQn local 0] begin */

    /* user code [CAN1_WKUP_IRQn local 0] end */
    hal_can_irq(&can1_info);
    /* user code [CAN1_WKUP_IRQn local 1] begin */

    /* user code [CAN1_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForMessageBuffer ??== true && NVIC_CAN1InterruptForMessageBuffer_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Message Buffer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_Message_IRQHandler(void)
{
    /* user code [CAN1_Message_IRQn local 0] begin */

    /* user code [CAN1_Message_IRQn local 0] end */
    hal_can_irq(&can1_info);
    /* user code [CAN1_Message_IRQn local 1] begin */

    /* user code [CAN1_Message_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForBusOffBusOffDone ??== true && NVIC_CAN1InterruptForBusOffBusOffDone_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Bus Off / Bus Off Done Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_Busoff_IRQHandler (void)
{
    /* user code [CAN1_Busoff_IRQn local 0] begin */

    /* user code [CAN1_Busoff_IRQn local 0] end */
    hal_can_irq(&can1_info);
    /* user code [CAN1_Busoff_IRQn local 1] begin */

    /* user code [CAN1_Busoff_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForError ??== true && NVIC_CAN1InterruptForError_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_Error_IRQHandler (void)
{
    /* user code [CAN1_Error_IRQn local 0] begin */

    /* user code [CAN1_Error_IRQn local 0] end */
    hal_can_irq(&can1_info);
    /* user code [CAN1_Error_IRQn local 1] begin */

    /* user code [CAN1_Error_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForErrorInFastTransmission ??== true && NVIC_CAN1InterruptForErrorInFastTransmission_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Error In Fast Transmission Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_FastError_IRQHandler (void)
{
    /* user code [CAN1_FastError_IRQn local 0] begin */

    /* user code [CAN1_FastError_IRQn local 0] end */
    hal_can_irq(&can1_info);
    /* user code [CAN1_FastError_IRQn local 1] begin */

    /* user code [CAN1_FastError_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForTransmitWarning ??== true && NVIC_CAN1InterruptForTransmitWarning_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Transmit Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_TEC_IRQHandler(void)
{
    /* user code [CAN1_TEC_IRQn local 0] begin */

    /* user code [CAN1_TEC_IRQn local 0] end */
    hal_can_irq(&can1_info);
    /* user code [CAN1_TEC_IRQn local 1] begin */

    /* user code [CAN1_TEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForReceiveWarning ??== true && NVIC_CAN1InterruptForReceiveWarning_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Receive Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_REC_IRQHandler(void)
{
    /* user code [CAN1_REC_IRQn local 0] begin */

    /* user code [CAN1_REC_IRQn local 0] end */
    hal_can_irq(&can1_info);
    /* user code [CAN1_REC_IRQn local 1] begin */

    /* user code [CAN1_REC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_CAN2WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN2 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_WKUP_IRQHandler(void)
{
    /* user code [CAN2_WKUP_IRQn local 0] begin */

    /* user code [CAN2_WKUP_IRQn local 0] end */
    hal_can_irq(&can2_info);
    /* user code [CAN2_WKUP_IRQn local 1] begin */

    /* user code [CAN2_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForMessageBuffer ??== true && NVIC_CAN2InterruptForMessageBuffer_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Message Buffer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_Message_IRQHandler(void)
{
    /* user code [CAN2_Message_IRQn local 0] begin */

    /* user code [CAN2_Message_IRQn local 0] end */
    hal_can_irq(&can2_info);
    /* user code [CAN2_Message_IRQn local 1] begin */

    /* user code [CAN2_Message_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForBusOffBusOffDone ??== true && NVIC_CAN2InterruptForBusOffBusOffDone_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Bus Off / Bus Off Done Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_Busoff_IRQHandler (void)
{
    /* user code [CAN2_Busoff_IRQn local 0] begin */

    /* user code [CAN2_Busoff_IRQn local 0] end */
    hal_can_irq(&can2_info);
    /* user code [CAN2_Busoff_IRQn local 1] begin */

    /* user code [CAN2_Busoff_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForError ??== true && NVIC_CAN2InterruptForError_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_Error_IRQHandler (void)
{
    /* user code [CAN2_Error_IRQn local 0] begin */

    /* user code [CAN2_Error_IRQn local 0] end */
    hal_can_irq(&can2_info);
    /* user code [CAN2_Error_IRQn local 1] begin */

    /* user code [CAN2_Error_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForErrorInFastTransmission ??== true && NVIC_CAN2InterruptForErrorInFastTransmission_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Error In Fast Transmission Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_FastError_IRQHandler(void)
{
    /* user code [CAN2_FastError_IRQn local 0] begin */

    /* user code [CAN2_FastError_IRQn local 0] end */
    hal_can_irq(&can2_info);
    /* user code [CAN2_FastError_IRQn local 1] begin */

    /* user code [CAN2_FastError_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForTransmitWarning ??== true && NVIC_CAN2InterruptForTransmitWarning_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Transmit Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_TEC_IRQHandler(void)
{
    /* user code [CAN2_TEC_IRQn local 0] begin */

    /* user code [CAN2_TEC_IRQn local 0] end */
    hal_can_irq(&can2_info);
    /* user code [CAN2_TEC_IRQn local 1] begin */

    /* user code [CAN2_TEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForReceiveWarning ??== true && NVIC_CAN2InterruptForReceiveWarning_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Receive Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_REC_IRQHandler(void)
{
    /* user code [CAN2_REC_IRQn local 0] begin */

    /* user code [CAN2_REC_IRQn local 0] end */
    hal_can_irq(&can2_info);
    /* user code [CAN2_REC_IRQn local 1] begin */

    /* user code [CAN2_REC_IRQn local 1] end */
}

[/#if]
[#if NVIC_EFUSEGlobalInterrupt ??== true && NVIC_EFUSEGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      EFUSE Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EFUSE_IRQHandler(void)
{
    /* user code [EFUSE_IRQn local 0] begin */

    /* user code [EFUSE_IRQn local 0] end */
    /* user code [EFUSE_IRQn local 1] begin */

    /* user code [EFUSE_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_I2C0WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_WKUP_IRQHandler(void)
{
    /* user code [I2C0_WKUP_IRQn local 0] begin */

    /* user code [I2C0_WKUP_IRQn local 0] end */
    hal_i2c_wake_up_irq(&i2c0_info);
    /* user code [I2C0_WKUP_IRQn local 1] begin */

    /* user code [I2C0_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_I2C1WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_WKUP_IRQHandler(void)
{
    /* user code [I2C1_WKUP_IRQn local 0] begin */

    /* user code [I2C1_WKUP_IRQn local 0] end */
    hal_i2c_wake_up_irq(&i2c1_info);
    /* user code [I2C1_WKUP_IRQn local 1] begin */

    /* user code [I2C1_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C2WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_I2C2WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C2 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C2_WKUP_IRQHandler(void)
{
    /* user code [I2C2_WKUP_IRQn local 0] begin */

    /* user code [I2C2_WKUP_IRQn local 0] end */
    hal_i2c_wake_up_irq(&i2c2_info);
    /* user code [I2C2_WKUP_IRQn local 1] begin */

    /* user code [I2C2_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_I2C3WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_WKUP_IRQHandler(void)
{
    /* user code [I2C3_WKUP_IRQn local 0] begin */

    /* user code [I2C3_WKUP_IRQn local 0] end */
    hal_i2c_wake_up_irq(&i2c3_info);
    /* user code [I2C3_WKUP_IRQn local 1] begin */

    /* user code [I2C3_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_LPDTSInterrupt ??== true && NVIC_LPDTSInterrupt_Enabled == "TRUE"]
/*!
    \brief      LPDTS Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void LPDTS_IRQHandler(void)
{
    /* user code [LPDTS_IRQn local 0] begin */

    /* user code [LPDTS_IRQn local 0] end */
    hal_lpdts_irq(&lpdts_info);
    /* user code [LPDTS_IRQn local 1] begin */

    /* user code [LPDTS_IRQn local 1] end */
}

[/#if]
[#if NVIC_LPDTSWakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_LPDTSWakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      LPDTS Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void LPDTS_WKUP_IRQHandler(void)
{
    /* user code [LPDTS_WKUP_IRQn local 0] begin */

    /* user code [LPDTS_WKUP_IRQn local 0] end */
    hal_lpdts_irq(&lpdts_info);
    /* user code [LPDTS_WKUP_IRQn local 1] begin */

    /* user code [LPDTS_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0DECInterrupt ??== true && NVIC_TIMER0DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_DEC_IRQHandler(void)
{
    /* user code [TIMER0_DEC_IRQn local 0] begin */

    /* user code [TIMER0_DEC_IRQn local 0] end */
    hal_timer_irq(&timer0_info);
    /* user code [TIMER0_DEC_IRQn local 1] begin */

    /* user code [TIMER0_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7DECInterrupt ??== true && NVIC_TIMER7DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_DEC_IRQHandler(void)
{
    /* user code [TIMER7_DEC_IRQn local 0] begin */

    /* user code [TIMER7_DEC_IRQn local 0] end */
    hal_timer_irq(&timer7_info);
    /* user code [TIMER7_DEC_IRQn local 1] begin */

    /* user code [TIMER7_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER1DECInterrupt ??== true && NVIC_TIMER1DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER1 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER1_DEC_IRQHandler(void)
{
    /* user code [TIMER1_DEC_IRQn local 0] begin */

    /* user code [TIMER1_DEC_IRQn local 0] end */
    hal_timer_irq(&timer1_info);
    /* user code [TIMER1_DEC_IRQn local 1] begin */

    /* user code [TIMER1_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER2DECInterrupt ??== true && NVIC_TIMER2DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER2 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER2_DEC_IRQHandler(void)
{
    /* user code [TIMER2_DEC_IRQn local 0] begin */

    /* user code [TIMER2_DEC_IRQn local 0] end */
    hal_timer_irq(&timer2_info);
    /* user code [TIMER2_DEC_IRQn local 1] begin */

    /* user code [TIMER2_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER3DECInterrupt ??== true && NVIC_TIMER3DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER3 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER3_DEC_IRQHandler(void)
{
    /* user code [TIMER3_DEC_IRQn local 0] begin */

    /* user code [TIMER3_DEC_IRQn local 0] end */
    hal_timer_irq(&timer3_info);
    /* user code [TIMER3_DEC_IRQn local 1] begin */

    /* user code [TIMER3_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER4DECInterrupt ??== true && NVIC_TIMER4DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER4 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER4_DEC_IRQHandler(void)
{
    /* user code [TIMER4_DEC_IRQn local 0] begin */

    /* user code [TIMER4_DEC_IRQn local 0] end */
    hal_timer_irq(&timer4_info);
    /* user code [TIMER4_DEC_IRQn local 1] begin */

    /* user code [TIMER4_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER22DECInterrupt ??== true && NVIC_TIMER22DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER22 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER22_DEC_IRQHandler (void)
{
    /* user code [TIMER22_DEC_IRQn local 0] begin */

    /* user code [TIMER22_DEC_IRQn local 0] end */
    hal_timer_irq(&timer22_info);
    /* user code [TIMER22_DEC_IRQn local 1] begin */

    /* user code [TIMER22_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER23DECInterrupt ??== true && NVIC_TIMER23DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER23 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER23_DEC_IRQHandler(void)
{
    /* user code [TIMER23_DEC_IRQn local 0] begin */

    /* user code [TIMER23_DEC_IRQn local 0] end */
    hal_timer_irq(&timer23_info);
    /* user code [TIMER23_DEC_IRQn local 1] begin */

    /* user code [TIMER23_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER30DECInterrupt ??== true && NVIC_TIMER30DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER30 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER30_DEC_IRQHandler (void)
{
    /* user code [TIMER30_DEC_IRQn local 0] begin */

    /* user code [TIMER30_DEC_IRQn local 0] end */
    hal_timer_irq(&timer30_info);
    /* user code [TIMER30_DEC_IRQn local 1] begin */

    /* user code [TIMER30_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER31DECInterrupt ??== true && NVIC_TIMER31DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER31 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER31_DEC_IRQHandler(void)
{
    /* user code [TIMER31_DEC_IRQn local 0] begin */

    /* user code [TIMER31_DEC_IRQn local 0] end */
    hal_timer_irq(&timer31_info);
    /* user code [TIMER31_DEC_IRQn local 1] begin */

    /* user code [TIMER31_DEC_IRQn local 1] end */
}

[/#if]

