[#ftl]
[#-- V1.3 --]
[#if FAC_FACEnable ??== true]
[<GlobalStructs_H_SharedMacros>]
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
#define FAC_COEFFA ${FAC_BasicParameters_CoefficientVectorASize}
[/#if]
#define FAC_COEFFB ${FAC_BasicParameters_CoefficientVectorBSize}
#define INPUT_DATA_SIZE ${FAC_BasicParameters_InputDataSize}
#define FAC_GAIN ${FAC_BasicParameters_Gain}
#define D0 100
#define D1 100

[<GlobalStructs_H_ExternalVariables>]
[#if FAC_BasicParameters_FloatDataEnable == "Disable"]
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
extern int16_t fac_coeffa_data[FAC_COEFFA];
[/#if]
extern int16_t fac_coeffb_data[FAC_COEFFB];
extern int16_t input_data[INPUT_DATA_SIZE];
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
extern int16_t output_data[FAC_COEFFA];
[/#if]
[/#if]

[#if FAC_BasicParameters_FloatDataEnable == "Enable"]
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
extern float fac_coeffa_data[FAC_COEFFA];
[/#if]
extern float fac_coeffb_data[FAC_COEFFB];
extern float input_data[INPUT_DATA_SIZE];
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
extern float output_data[FAC_COEFFA];
[/#if]
[/#if]

[<GlobalStructs_C_PrivateVariables>]
[#if FAC_BasicParameters_FloatDataEnable == "Disable"]
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
int16_t fac_coeffa_data[FAC_COEFFA] = { 0 };
[/#if]
int16_t fac_coeffb_data[FAC_COEFFB] = { 0 };
int16_t input_data[INPUT_DATA_SIZE] = { 0 };
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
int16_t output_data[FAC_COEFFA] = { 0 };
[/#if]
[/#if]

[#if FAC_BasicParameters_FloatDataEnable == "Enable"]
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
float fac_coeffa_data[FAC_COEFFA] = { 0 };
[/#if]
float fac_coeffb_data[FAC_COEFFB] = { 0 };
float input_data[INPUT_DATA_SIZE] = { 0 };
[#if FAC_BasicParameters_CoefficientVectorASize ??== true]
float output_data[FAC_COEFFA] = { 0 };
[/#if]
[/#if]

[<InitCode>]
fac_parameter_struct facconfig;
[#if FAC_BasicParameters_FloatDataEnable == "Disable"]
fac_fixed_data_preload_struct faccoeff;
[/#if]
[#if FAC_BasicParameters_FloatDataEnable == "Enable"]
fac_float_data_preload_struct faccoeff;
[/#if]
fac_struct_para_init(&facconfig);

[#if FAC_BasicParameters_FilterMode == "FIR"]
facconfig.coeff_addr = 0;
facconfig.coeff_size = FAC_COEFFB;
facconfig.input_addr = FAC_COEFFB;
facconfig.input_size = FAC_COEFFB + D0;
    [#if FAC_BasicParameters_X0BufferThreshold == "Threshold 1"]
    facconfig.input_threshold = FAC_THRESHOLD_1;
    [#elseif FAC_BasicParameters_X0BufferThreshold == "Threshold 2"]
    facconfig.input_threshold = FAC_THRESHOLD_2;
    [#elseif FAC_BasicParameters_X0BufferThreshold == "Threshold 4"]
    facconfig.input_threshold = FAC_THRESHOLD_4;
    [#elseif FAC_BasicParameters_X0BufferThreshold == "Threshold 8"]
    facconfig.input_threshold = FAC_THRESHOLD_8;
    [/#if]
facconfig.output_addr = FAC_COEFFB + FAC_COEFFB + D0;
facconfig.output_size = D1;
    [#if FAC_BasicParameters_YBufferThreshold == "Threshold 1"]
    facconfig.output_threshold = FAC_THRESHOLD_1;
    [#elseif FAC_BasicParameters_YBufferThreshold == "Threshold 2"]
    facconfig.output_threshold = FAC_THRESHOLD_2;
    [#elseif FAC_BasicParameters_YBufferThreshold == "Threshold 4"]
    facconfig.output_threshold = FAC_THRESHOLD_4;
    [#elseif FAC_BasicParameters_YBufferThreshold == "Threshold 8"]
    facconfig.output_threshold = FAC_THRESHOLD_8;
    [/#if]
    [#if FAC_BasicParameters_ClippingEnable == "Disable"]
    facconfig.clip = FAC_CP_DISABLE;
    [#elseif FAC_BasicParameters_ClippingEnable == "Enable"]
    facconfig.clip = FAC_CP_ENABLE;
    [/#if]
fac_init(&facconfig);

faccoeff.coeffa_ctx = NULL;
faccoeff.coeffa_size = 0;
faccoeff.coeffb_ctx = fac_coeffb_data;
faccoeff.coeffb_size = FAC_COEFFB;
faccoeff.input_ctx = input_data;
faccoeff.input_size = INPUT_DATA_SIZE;
faccoeff.output_ctx = NULL;
faccoeff.output_size = 0;
[#if FAC_BasicParameters_FloatDataEnable == "Disable"]
fac_fixed_buffer_preload(&faccoeff);
[/#if]
[#if FAC_BasicParameters_FloatDataEnable == "Enable"]
fac_float_buffer_preload(&faccoeff);
[/#if]

facconfig.func = FUNC_CONVO_FIR;
facconfig.ipp = FAC_COEFFB;
facconfig.ipq = 0;
facconfig.ipr = FAC_GAIN;
fac_function_config(&facconfig);

[#elseif FAC_BasicParameters_FilterMode == "IIR"]
facconfig.coeff_addr = 0;
facconfig.coeff_size = FAC_COEFFA + FAC_COEFFB;
facconfig.input_addr = FAC_COEFFA + FAC_COEFFB;
facconfig.input_size = FAC_COEFFB + D0;
    [#if FAC_BasicParameters_X0BufferThreshold == "Threshold 1"]
    facconfig.input_threshold = FAC_THRESHOLD_1;
    [#elseif FAC_BasicParameters_X0BufferThreshold == "Threshold 2"]
    facconfig.input_threshold = FAC_THRESHOLD_2;
    [#elseif FAC_BasicParameters_X0BufferThreshold == "Threshold 4"]
    facconfig.input_threshold = FAC_THRESHOLD_4;
    [#elseif FAC_BasicParameters_X0BufferThreshold == "Threshold 8"]
    facconfig.input_threshold = FAC_THRESHOLD_8;
    [/#if]
facconfig.output_addr = FAC_COEFFA + FAC_COEFFB + FAC_COEFFB + D0;
facconfig.output_size = FAC_COEFFA + D1;
    [#if FAC_BasicParameters_YBufferThreshold == "Threshold 1"]
    facconfig.output_threshold = FAC_THRESHOLD_1;
    [#elseif FAC_BasicParameters_YBufferThreshold == "Threshold 2"]
    facconfig.output_threshold = FAC_THRESHOLD_2;
    [#elseif FAC_BasicParameters_YBufferThreshold == "Threshold 4"]
    facconfig.output_threshold = FAC_THRESHOLD_4;
    [#elseif FAC_BasicParameters_YBufferThreshold == "Threshold 8"]
    facconfig.output_threshold = FAC_THRESHOLD_8;
    [/#if]
    [#if FAC_BasicParameters_ClippingEnable == "Disable"]
    facconfig.clip = FAC_CP_DISABLE;
    [#elseif FAC_BasicParameters_ClippingEnable == "Enable"]
    facconfig.clip = FAC_CP_ENABLE;
    [/#if]
fac_init(&facconfig);

faccoeff.coeffa_ctx = fac_coeffa_data;
faccoeff.coeffa_size = FAC_COEFFA;
faccoeff.coeffb_ctx = fac_coeffb_data;
faccoeff.coeffb_size = FAC_COEFFB;
faccoeff.input_ctx = input_data;
faccoeff.input_size = INPUT_DATA_SIZE;
faccoeff.output_ctx = output_data;
faccoeff.output_size = FAC_COEFFA;
[#if FAC_BasicParameters_FloatDataEnable == "Disable"]
fac_fixed_buffer_preload(&faccoeff);
[/#if]
[#if FAC_BasicParameters_FloatDataEnable == "Enable"]
fac_float_buffer_preload(&faccoeff);
[/#if]

facconfig.func = FUNC_IIR_DIRECT_FORM_1;
facconfig.ipp = FAC_COEFFB;
facconfig.ipq = FAC_COEFFA;
facconfig.ipr = FAC_GAIN;
fac_function_config(&facconfig);
[/#if]

[#if FAC_BasicParameters_FloatDataEnable == "Disable"]
fac_float_disable();
[#elseif FAC_BasicParameters_FloatDataEnable == "Enable"]
fac_float_enable();
[/#if]
[/#if]
