[#ftl]
[#-- V1.0.8 --]

[#if RCU_HighSpeedCrystalOscillator != "Disable" && (RTCSRC == "RCU_RTCSRC_HXTAL_DIV_RTCDIV" || CKOUT1SEL == "RCU_CKOUT1SRC_HXTAL" || CKOUT0SEL == "RCU_CKOUT0SRC_HXTAL" || SCS == "RCU_CKSYSSRC_HXTAL" || PLLSEL == "RCU_PLLSRC_HXTAL")]
[#if RCU_HighSpeedCrystalOscillator == "Clock Bypass"]
    rcu_osci_bypass_mode_enable(RCU_HXTAL);

[/#if]
    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);
[/#if]

[#if RCU_LowSpeedCrystalOscillator != "Disable" && (RTCSRC == "RCU_RTCSRC_LXTAL" || CKOUT0SEL == "RCU_CKOUT0SRC_LXTAL" || ((Peripherals?contains("CTC") == true && CTC_ReferenceSignalSource == "LXTAL")))]
[#if RCU_LowSpeedCrystalOscillator == "Clock Bypass"]
    rcu_osci_bypass_mode_enable(RCU_LXTAL);

[/#if]
    rcu_periph_clock_enable(RCU_PMU);
    pmu_backup_write_enable();

    rcu_osci_on(RCU_LXTAL);
    while(rcu_osci_stab_wait(RCU_LXTAL) != SUCCESS);
[/#if]

[#if ((Peripherals?contains("RTC") == true && RTCSRC == "RCU_RTCSRC_IRC32K") || (Peripherals?contains("FWDGT") == true))]
    rcu_osci_on(RCU_IRC32K);
    while(rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);
[/#if]

[#if Peripherals?contains("CTC") == true || CK48MSEL == "RCU_CK48MSRC_IRC48M"]
    rcu_osci_on(RCU_IRC48M);
    while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
[/#if]

[#if SCS == "RCU_CKSYSSRC_IRC16M" || SCS == ""]
    rcu_osci_on(RCU_IRC16M);
    while(rcu_osci_stab_wait(RCU_IRC16M) != SUCCESS);
    rcu_irc16m_adjust_value_set(IRC16M_TRIM_ADJUST_VALUE);

    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb1_clock_config(${APB1Prescaler});
    rcu_apb2_clock_config(${APB2Prescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC16M);
    while(RCU_SCSS_IRC16M != rcu_system_clock_source_get());
[#elseif SCS == "RCU_CKSYSSRC_HXTAL"]
    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb1_clock_config(${APB1Prescaler});
    rcu_apb2_clock_config(${APB2Prescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_HXTAL);
    while(RCU_SCSS_HXTAL != rcu_system_clock_source_get());
[#elseif SCS == "RCU_CKSYSSRC_PLLP"]
    [#if PLLSEL == "RCU_PLLSRC_IRC16M" || PLLSEL == ""]
        rcu_osci_on(RCU_IRC16M);
        while(rcu_osci_stab_wait(RCU_IRC16M) != SUCCESS);
        rcu_irc16m_adjust_value_set(IRC16M_TRIM_ADJUST_VALUE);
    [/#if]

    RCU_APB1EN |= RCU_APB1EN_PMUEN;
    PMU_CTL |= PMU_CTL_LDOVS;

    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb1_clock_config(${APB1Prescaler});
    rcu_apb2_clock_config(${APB2Prescaler});

    [#if PLLP != "" && PLLQ != ""]
        rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (${PLLP}U), (${PLLQ}U));
    [#elseif PLLP != "" && PLLQ == ""]
        rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (${PLLP}U), (4U));
    [#elseif PLLP == "" && PLLQ != ""]
        rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (2U), (${PLLQ}U));
    [#elseif PLLP == "" && PLLQ == ""]
        rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (2U), (4U));
    [/#if]
    [#if SCS == "RCU_CKSYSSRC_PLLP"]
        rcu_osci_on(RCU_PLL_CK);
    [/#if]
    while(rcu_osci_stab_wait(RCU_PLL_CK) != SUCCESS);

    /* Enable the high-drive */
    PMU_CTL |= PMU_CTL_HDEN;
    while(0U == (PMU_CS & PMU_CS_HDRF)){
    }

    /* select the high-drive mode */
    PMU_CTL |= PMU_CTL_HDS;
    while(0U == (PMU_CS & PMU_CS_HDSRF)){
    }

    rcu_system_clock_source_config(RCU_CKSYSSRC_PLLP);
    while(RCU_SCSS_PLLP != rcu_system_clock_source_get());

[/#if]

[#if RCU_ResetAndClockAdjustParameters_TIMERPrescalerSelection ??== true]
[#if RCU_ResetAndClockAdjustParameters_TIMERPrescalerSelection != "Disable"]
    rcu_timer_clock_prescaler_config(RCU_TIMER_PSC_MUL4);
[/#if]
[/#if]

[#if (CKOUT0SEL == "RCU_CKOUT0SRC_IRC16M" || PLLSEL == "RCU_PLLSRC_IRC16M" || I2C3SEL == "RCU_I2CSRC_IRC16M" || I2C4SEL == "RCU_I2CSRC_IRC16M" || I2C5SEL == "RCU_I2CSRC_IRC16M") && (SCS != "RCU_CKSYSSRC_IRC16M")]
    [#if !((SCS == "RCU_CKSYSSRC_IRC16M" || SCS == "") || (SCS == "RCU_CKSYSSRC_PLLP" && (PLLSEL == "RCU_PLLSRC_IRC16M" || PLLSEL == "")))]
    rcu_osci_on(RCU_IRC16M);
    while(rcu_osci_stab_wait(RCU_IRC16M) != SUCCESS);
    rcu_irc16m_adjust_value_set(IRC16M_TRIM_ADJUST_VALUE);
    [/#if]
[/#if]

[#if (CKOUT0SEL == "RCU_CKOUT0SRC_PLLP") || (CKOUT1SEL == "RCU_CKOUT1SRC_PLLP") || (CKOUT1SEL == "RCU_CKOUT1SRC_PLLI2SR")
    || (PLL48MSEL == "RCU_PLL48MSRC_PLLQ") || (PLL48MSEL == "RCU_PLL48MSRC_PLLSAIP") || (I2SSEL == "RCU_I2SSRC_PLLI2S")
    || (Peripherals?contains("TLI") == true) || (I2C3SEL == "RCU_I2CSRC_PLLSAIR") || (I2C4SEL == "RCU_I2CSRC_PLLSAIR")
    || (I2C5SEL == "RCU_I2CSRC_PLLSAIR") || (SAISEL == "RCU_SAISRC_PLLSAIQ") || (SAISEL == "RCU_SAISRC_PLLI2SQ")]
    [#if SCS != "RCU_CKSYSSRC_PLLP"]
        [#if PLLP != "" && PLLQ != ""]
            rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (${PLLP}U), (${PLLQ}U));
        [#elseif PLLP != "" && PLLQ == ""]
            rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (${PLLP}U), (4U));
        [#elseif PLLP == "" && PLLQ != ""]
            rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (2U), (${PLLQ}U));
        [#elseif PLLP == "" && PLLQ == ""]
            rcu_pll_config(${PLLSEL}, (${PLLPSC}U), (${PLLN}U), (2U), (4U));
        [/#if]
        rcu_osci_on(RCU_PLL_CK);
        while(rcu_osci_stab_wait(RCU_PLL_CK) != SUCCESS);

    [/#if]

    [#if (CKOUT1SEL == "RCU_CKOUT1SRC_PLLI2SR") || (I2SSEL == "RCU_I2SSRC_PLLI2S") || (SAISEL == "RCU_SAISRC_PLLI2SQ")]
        [#if CKOUT1SEL == "RCU_CKOUT1SRC_PLLI2SR" || I2SSEL == "RCU_I2SSRC_PLLI2S"]
            rcu_plli2s_r_config(${PLLI2SN}U, ${PLLI2SR}U);
        [/#if]
        [#if SAISEL == "RCU_SAISRC_PLLI2SQ"]
            rcu_plli2s_q_config(${PLLI2SN}U, ${PLLI2SQ}U, ${PLLI2SQ_DIV});
        [/#if]
        rcu_osci_on(RCU_PLLI2S_CK);
        while(rcu_osci_stab_wait(RCU_PLLI2S_CK) != SUCCESS);

    [/#if]

    [#if (PLL48MSEL == "RCU_PLL48MSRC_PLLSAIP") || (Peripherals?contains("TLI") == true) || (I2C3SEL == "RCU_I2CSRC_PLLSAIR")
        || (I2C4SEL == "RCU_I2CSRC_PLLSAIR") || (I2C5SEL == "RCU_I2CSRC_PLLSAIR") || (SAISEL == "RCU_SAISRC_PLLSAIQ")]
        [#if (PLL48MSEL == "RCU_PLL48MSRC_PLLSAIP")]
            rcu_pllsai_p_config(${PLLSAIN}U, ${PLLSAIP}U);
        [/#if]
        [#if (Peripherals?contains("TLI") == true) || (I2C3SEL == "RCU_I2CSRC_PLLSAIR") || (I2C4SEL == "RCU_I2CSRC_PLLSAIR") || (I2C5SEL == "RCU_I2CSRC_PLLSAIR")]
            rcu_pllsai_r_config(${PLLSAIN}U, ${PLLSAIR}U);
        [/#if]
        [#if (SAISEL == "RCU_SAISRC_PLLSAIQ")]
            rcu_pllsai_q_config(${PLLSAIN}U, ${PLLSAIQ}U);
        [/#if]
        [#if Peripherals?contains("TLI") == true]
            rcu_tli_clock_div_config(${PLLSAIR_DIV});
        [/#if]
        rcu_osci_on(RCU_PLLSAI_CK);
        while(rcu_osci_stab_wait(RCU_PLLSAI_CK) != SUCCESS);

    [/#if]
[/#if]

[#if Peripherals?contains("RTC") == true]
    [#if RTCSRC == "RCU_RTCSRC_HXTAL_DIV_RTCDIV"]
        rcu_rtc_div_config(${HXTAL_DIV});
    [/#if]
    [#if RTCSRC != ""]
        rcu_rtc_clock_config(${RTCSRC});
    [#else]
        rcu_rtc_clock_config(RCU_RTCSRC_NONE);
    [/#if]

[/#if]
[#if Peripherals?contains("USBFS") == true || Peripherals?contains("TRNG") == true || Peripherals?contains("USBHS") == true || Peripherals?contains("SDIO") == true]
    [#if PLL48MSEL == "RCU_PLL48MSRC_PLLQ"]
        rcu_pll48m_clock_config(RCU_PLL48MSRC_PLLQ);
    [#elseif PLL48MSEL == "RCU_PLL48MSRC_PLLSAIP"]
        rcu_pll48m_clock_config(RCU_PLL48MSRC_PLLSAIP);
    [/#if]
    [#if CK48MSEL == "RCU_CK48MSRC_PLL48M"]
        rcu_ck48m_clock_config(RCU_CK48MSRC_PLL48M);
    [#elseif CK48MSEL == "RCU_CK48MSRC_IRC48M"]
        rcu_ck48m_clock_config(RCU_CK48MSRC_IRC48M);
    [/#if]
[/#if]

[#if Peripherals?contains("I2S1") == true || Peripherals?contains("I2S2") == true]
    [#if I2SSEL == ""]
        rcu_i2s_clock_config(RCU_I2SSRC_I2S_CKIN);
    [#else]
        rcu_i2s_clock_config(${I2SSEL});
    [/#if]

[/#if]
[#if Peripherals?contains("I2C3") == true]
    rcu_i2c_clock_config(IDX_I2C3,${I2C3SEL});
[/#if]
[#if Peripherals?contains("I2C4") == true]
    rcu_i2c_clock_config(IDX_I2C4, ${I2C4SEL});
[/#if]
[#if Peripherals?contains("I2C5") == true]
    rcu_i2c_clock_config(IDX_I2C5, ${I2C5SEL});
[/#if]

[#if Peripherals?contains("SAI") == true]
    [#if SAISEL != ""]
        rcu_sai_clock_config(${SAISEL});
    [#else]
        rcu_sai_clock_config(RCU_SAISRC_PLLSAIQ);
    [/#if]

[/#if]
[#if RCU_ClockOutput0 == "Enable"]
    [#if CKOUT0SEL != ""]
        rcu_ckout0_config(${CKOUT0SEL}, ${CKOUT0DIV});
    [#else]
        rcu_ckout0_config(RCU_CKOUT0SRC_IRC16M, RCU_CKOUT0_DIV1);
    [/#if]

[/#if]
[#if RCU_ClockOutput1 == "Enable"]
    [#if CKOUT1SEL != ""]
        rcu_ckout1_config(${CKOUT1SEL}, ${CKOUT1DIV});
    [#else]
        rcu_ckout1_config(RCU_CKOUT1SRC_SYSTEMCLOCK, RCU_CKOUT1_DIV1);
    [/#if]
[/#if]

[#if RCU_MonitorConfiguration_HXTALMonitor ??== true && RCU_MonitorConfiguration_HXTALMonitor == "Enable"]
    rcu_hxtal_clock_monitor_enable();
[/#if]

[#if RCU_PLLSpreadSpectrumModulationConfiguration_PLLSpreadSpectrumEnable ??== true && RCU_PLLSpreadSpectrumModulationConfiguration_PLLSpreadSpectrumEnable != "Disable"]
    [#if RCU_PLLSpreadSpectrumModulationConfiguration_PLLSpreadSpectrumModulationType == "Center Spread"]
    rcu_spread_spectrum_config(RCU_SS_TYPE_CENTER, ${RCU_PLLSpreadSpectrumModulationConfiguration_MODSTEP}U, ${RCU_PLLSpreadSpectrumModulationConfiguration_MODCNT}U);
    [#else]
    rcu_spread_spectrum_config(RCU_SS_TYPE_DOWN, ${RCU_PLLSpreadSpectrumModulationConfiguration_MODSTEP}U, ${RCU_PLLSpreadSpectrumModulationConfiguration_MODCNT}U);
    [/#if]
    rcu_spread_spectrum_enable();
[/#if]

/* update SystemCoreClock value */
SystemCoreClockUpdate();

[#if SYS_SystickClockSource == "Source From HCLK"]
/* setup systick timer for 1000Hz interrupts */
if (SysTick_Config(SystemCoreClock / 1000U)){
    /* capture error */
    while (1);
}

systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);
[#elseif SYS_SystickClockSource == "Source From HCLK/8"]
/* setup systick timer for 1000Hz interrupts */
if (SysTick_Config(SystemCoreClock / 8U / 1000U)){
    /* capture error */
    while (1);
}

systick_clksource_set(SYSTICK_CLKSOURCE_HCLK_DIV8);
[/#if]
