[#ftl]
[#-- V1.0 --]

[<GlobalStructs_H_SharedMacros>]
[#if CAU_CAUEnable ??== true]
    #define Input_Size ${ParameterConfiguration_InputSize}
    [#if CAU_Algorithm_AlgorithmMode?contains("AES") == true]
    #define KEY_BUFFER_SIZE ${ReflectionFunc.extractNumber(CAU_ParameterConfiguration_AESKeyLength, "DEC")}
    [/#if]
[/#if]

[<GlobalStructs_H_ExternalVariables>]
[#if CAU_CAUEnable ??== true]
    [#if CAU_Algorithm_AlgorithmMode?contains("ECB") != true]
    extern uint8_t CAU_VECTOR_BUFFER[${ReflectionFunc.GetArrayLength(CAU_ParameterConfiguration_InitializationVector,"HEX")}];
    [/#if]
    [#if CAU_Algorithm_AlgorithmMode?contains("AES-") == true]
    extern uint8_t CAU_KEY_BUFFER[KEY_BUFFER_SIZE / 8];
    [#elseif CAU_Algorithm_AlgorithmMode?contains("AES-") != true]
    extern uint8_t CAU_KEY_BUFFER[${ReflectionFunc.GetArrayLength(CAU_ParameterConfiguration_EncryptionDecryptionKey,"HEX")}];
    [/#if]
[/#if]

[<GlobalStructs_C_PrivateVariables>]
[#if CAU_CAUEnable ??== true]
    uint8_t INPUT_DATA_BUFFER[Input_Size] = {0};
    [#if CAU_Algorithm_AlgorithmMode?contains("ECB") != true]
    __ALIGNED(4) uint8_t CAU_VECTOR_BUFFER[${ReflectionFunc.GetArrayLength(CAU_ParameterConfiguration_InitializationVector,"HEX")}] = ${ReflectionFunc.GetValueArray(CAU_ParameterConfiguration_InitializationVector,"HEX")};
    [/#if]
    [#if CAU_Algorithm_AlgorithmMode?contains("AES-") == true]
    __ALIGNED(4) uint8_t CAU_KEY_BUFFER[KEY_BUFFER_SIZE / 8] = ${ReflectionFunc.GetValueArray(CAU_ParameterConfiguration_EncryptionDecryptionKey,"HEX")};
    [#elseif CAU_Algorithm_AlgorithmMode?contains("AES-") != true]
    __ALIGNED(4) uint8_t CAU_KEY_BUFFER[${ReflectionFunc.GetArrayLength(CAU_ParameterConfiguration_EncryptionDecryptionKey,"HEX")}] = ${ReflectionFunc.GetValueArray(CAU_ParameterConfiguration_EncryptionDecryptionKey,"HEX")};
    [/#if]
[/#if]


[<InitCode>]
[#if CAU_CAUEnable ??== true]

[#--DMA和INT模式下生成以下代码--]
[#if (NVIC_CAUGlobalInterrupt ??== true && NVIC_CAUGlobalInterrupt_Enabled == "TRUE")
|| (DMA0_CH0_DMARequest ??== true && DMA0_CH0_DMARequest == "CAU_IN") || (DMA1_CH0_DMARequest ??== true && DMA1_CH0_DMARequest == "CAU_OUT")
|| (DMA0_CH1_DMARequest ??== true && DMA0_CH1_DMARequest == "CAU_IN") || (DMA1_CH1_DMARequest ??== true && DMA1_CH1_DMARequest == "CAU_OUT")
|| (DMA0_CH2_DMARequest ??== true && DMA0_CH2_DMARequest == "CAU_IN") || (DMA1_CH2_DMARequest ??== true && DMA1_CH2_DMARequest == "CAU_OUT")
|| (DMA0_CH3_DMARequest ??== true && DMA0_CH3_DMARequest == "CAU_IN") || (DMA1_CH3_DMARequest ??== true && DMA1_CH3_DMARequest == "CAU_OUT")
|| (DMA0_CH4_DMARequest ??== true && DMA0_CH4_DMARequest == "CAU_IN") || (DMA1_CH4_DMARequest ??== true && DMA1_CH4_DMARequest == "CAU_OUT")
|| (DMA0_CH5_DMARequest ??== true && DMA0_CH5_DMARequest == "CAU_IN") || (DMA1_CH5_DMARequest ??== true && DMA1_CH5_DMARequest == "CAU_OUT")
|| (DMA0_CH6_DMARequest ??== true && DMA0_CH6_DMARequest == "CAU_IN") || (DMA1_CH6_DMARequest ??== true && DMA1_CH6_DMARequest == "CAU_OUT")
|| (DMA0_CH7_DMARequest ??== true && DMA0_CH7_DMARequest == "CAU_IN") || (DMA1_CH7_DMARequest ??== true && DMA1_CH7_DMARequest == "CAU_OUT")
|| (DMA1_CH0_DMARequest ??== true && DMA1_CH0_DMARequest == "CAU_IN") || (DMA0_CH0_DMARequest ??== true && DMA0_CH0_DMARequest == "CAU_OUT")
|| (DMA1_CH1_DMARequest ??== true && DMA1_CH1_DMARequest == "CAU_IN") || (DMA0_CH1_DMARequest ??== true && DMA0_CH1_DMARequest == "CAU_OUT")
|| (DMA1_CH2_DMARequest ??== true && DMA1_CH2_DMARequest == "CAU_IN") || (DMA0_CH2_DMARequest ??== true && DMA0_CH2_DMARequest == "CAU_OUT")
|| (DMA1_CH3_DMARequest ??== true && DMA1_CH3_DMARequest == "CAU_IN") || (DMA0_CH3_DMARequest ??== true && DMA0_CH3_DMARequest == "CAU_OUT")
|| (DMA1_CH4_DMARequest ??== true && DMA1_CH4_DMARequest == "CAU_IN") || (DMA0_CH4_DMARequest ??== true && DMA0_CH4_DMARequest == "CAU_OUT")
|| (DMA1_CH5_DMARequest ??== true && DMA1_CH5_DMARequest == "CAU_IN") || (DMA0_CH5_DMARequest ??== true && DMA0_CH5_DMARequest == "CAU_OUT")
|| (DMA1_CH6_DMARequest ??== true && DMA1_CH6_DMARequest == "CAU_IN") || (DMA0_CH6_DMARequest ??== true && DMA0_CH6_DMARequest == "CAU_OUT")
|| (DMA1_CH7_DMARequest ??== true && DMA1_CH7_DMARequest == "CAU_IN") || (DMA0_CH7_DMARequest ??== true && DMA0_CH7_DMARequest == "CAU_OUT")]

    cau_key_parameter_struct key_initpara;
[#if CAU_Algorithm_AlgorithmMode?? && CAU_Algorithm_AlgorithmMode != "TDES-ECB" && CAU_Algorithm_AlgorithmMode != "DES-ECB" && CAU_Algorithm_AlgorithmMode != "AES-ECB"]
    cau_iv_parameter_struct iv_initpara;
[/#if]

    uint32_t *key_temp = (uint32_t *)&CAU_KEY_BUFFER[0];
[#if CAU_Algorithm_AlgorithmMode?? && CAU_Algorithm_AlgorithmMode != "TDES-ECB" && CAU_Algorithm_AlgorithmMode != "DES-ECB" && CAU_Algorithm_AlgorithmMode != "AES-ECB"]
    uint32_t *ivaddr = (uint32_t *)&CAU_VECTOR_BUFFER[0];
[/#if]
[#if CAU_Algorithm_CAUDirection?? && CAU_Algorithm_CAUDirection == "Decryption"]
    volatile uint32_t counter = 0U;
    uint32_t busystatus = 0U;
[/#if]

    cau_key_struct_para_init(&key_initpara);
[#if CAU_Algorithm_AlgorithmMode?? && CAU_Algorithm_AlgorithmMode != "TDES-ECB" && CAU_Algorithm_AlgorithmMode != "DES-ECB" && CAU_Algorithm_AlgorithmMode != "AES-ECB"]
    cau_iv_struct_para_init(&iv_initpara);
[/#if]

[#if CAU_ParameterConfiguration_AESKeyLength??]
[#if CAU_ParameterConfiguration_AESKeyLength == "128 bit"]
    cau_aes_keysize_config(CAU_KEYSIZE_128BIT);
[#elseif CAU_ParameterConfiguration_AESKeyLength == "192 bit"]
    cau_aes_keysize_config(CAU_KEYSIZE_192BIT);
[#elseif CAU_ParameterConfiguration_AESKeyLength == "256 bit"]
    cau_aes_keysize_config(CAU_KEYSIZE_256BIT);
[/#if]
[/#if]

[#if CAU_Algorithm_AlgorithmMode?? ]
    [#if CAU_Algorithm_AlgorithmMode == "TDES-ECB" || CAU_Algorithm_AlgorithmMode == "TDES-CBC"]
    key_initpara.key_1_high = __REV(*key_temp);
    key_initpara.key_1_low  = __REV(*(++key_temp));
    key_initpara.key_2_high = __REV(*(++key_temp));
    key_initpara.key_2_low  = __REV(*(++key_temp));
    key_initpara.key_3_high = __REV(*(++key_temp));
    key_initpara.key_3_low  = __REV(*(++key_temp));
    [#elseif CAU_Algorithm_AlgorithmMode == "DES-ECB" || CAU_Algorithm_AlgorithmMode == "DES-CBC"]
    key_initpara.key_1_high = __REV(*key_temp);
    key_initpara.key_1_low  = __REV(*(++key_temp));
    [#elseif CAU_ParameterConfiguration_AESKeyLength == "192 bit"]
    key_initpara.key_1_high = __REV(*key_temp);
    key_initpara.key_1_low  = __REV(*(++key_temp));
    key_initpara.key_2_high = __REV(*(++key_temp));
    key_initpara.key_2_low  = __REV(*(++key_temp));
    key_initpara.key_3_high = __REV(*(++key_temp));
    key_initpara.key_3_low  = __REV(*(++key_temp));
    [#elseif CAU_ParameterConfiguration_AESKeyLength == "128 bit"]
    key_initpara.key_2_high = __REV(*key_temp);
    key_initpara.key_2_low  = __REV(*(++key_temp));
    key_initpara.key_3_high = __REV(*(++key_temp));
    key_initpara.key_3_low  = __REV(*(++key_temp));
    [#elseif CAU_ParameterConfiguration_AESKeyLength == "256 bit"]
    key_initpara.key_0_high = __REV(*key_temp);
    key_initpara.key_0_low  = __REV(*(++key_temp));
    key_initpara.key_1_high = __REV(*(++key_temp));
    key_initpara.key_1_low  = __REV(*(++key_temp));
    key_initpara.key_2_high = __REV(*(++key_temp));
    key_initpara.key_2_low  = __REV(*(++key_temp));
    key_initpara.key_3_high = __REV(*(++key_temp));
    key_initpara.key_3_low  = __REV(*(++key_temp));
    [/#if]
[/#if]
    cau_key_init(&key_initpara);

[#if CAU_Algorithm_CAUDirection?? && CAU_Algorithm_CAUDirection == "Decryption"]

    /* flush the IN and OUT FIFOs */
    cau_fifo_flush();
    /* initialize the CAU peripheral */
    cau_init(CAU_DECRYPT, CAU_MODE_AES_KEY, CAU_SWAPPING_32BIT);
    /* enable the CAU peripheral */
    cau_enable();
    /* wait until the busy flag is RESET */
    do {
        busystatus = cau_flag_get(CAU_FLAG_BUSY);
        counter++;
    } while((AESBSY_TIMEOUT != counter) && (RESET != busystatus));

    if(RESET != busystatus) {
        /*if the program is executed here, please add the user code to solve it*/
        while(1);
    }
[/#if]

[#if CAU_Algorithm_AlgorithmMode?? && CAU_Algorithm_CAUDirection?? && CAU_ParameterConfiguration_DataSwappingType??]
[#if CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_ECB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "TDES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_TDES_CBC, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_ECB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "DES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_DES_CBC, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-ECB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_ECB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CBC" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CBC, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CTR" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CTR, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-GCM" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_GCM, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CCM" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CCM, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-CFB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_CFB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Encryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_ENCRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_1BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "No Exchange"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_32BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "Half-Word"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_16BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "Byte"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_8BIT);
[#elseif CAU_Algorithm_CAUDirection == "Decryption" && CAU_Algorithm_AlgorithmMode == "AES-OFB" && CAU_ParameterConfiguration_DataSwappingType == "bit"]
cau_init(CAU_DECRYPT, CAU_MODE_AES_OFB, CAU_SWAPPING_1BIT);
[/#if]
[/#if]

[#if CAU_Algorithm_AlgorithmMode?? ]
[#if CAU_Algorithm_AlgorithmMode == "AES-CBC" || CAU_Algorithm_AlgorithmMode == "AES-CTR" || CAU_Algorithm_AlgorithmMode == "AES-GCM"
  || CAU_Algorithm_AlgorithmMode == "AES-CCM" || CAU_Algorithm_AlgorithmMode == "AES-CFB" || CAU_Algorithm_AlgorithmMode == "AES-OFB"]
    iv_initpara.iv_0_high = __REV(*ivaddr);
    iv_initpara.iv_0_low  = __REV(*(++ivaddr));
    iv_initpara.iv_1_high = __REV(*(++ivaddr));
    iv_initpara.iv_1_low  = __REV(*(++ivaddr));
[#elseif CAU_Algorithm_AlgorithmMode == "DES-CBC" || CAU_Algorithm_AlgorithmMode == "TDES-CBC"]
    iv_initpara.iv_0_high = __REV(*ivaddr);
    iv_initpara.iv_0_low  = __REV(*(++ivaddr));
[/#if]
[#if CAU_Algorithm_AlgorithmMode?? && CAU_Algorithm_AlgorithmMode != "TDES-ECB" && CAU_Algorithm_AlgorithmMode != "DES-ECB" && CAU_Algorithm_AlgorithmMode != "AES-ECB"]
    cau_iv_init(&iv_initpara);
[/#if]
[/#if]


[#--标准模式下生成以下代码--]
[#else]
cau_parameter_struct cau_parameter;

cau_struct_para_init(&cau_parameter);
[#if CAU_Algorithm_CAUDirection == "Encryption"]
cau_parameter.alg_dir = CAU_ENCRYPT;
[#elseif CAU_Algorithm_CAUDirection == "Decryption"]
cau_parameter.alg_dir = CAU_DECRYPT;
[/#if]
cau_parameter.key = (uint8_t *)CAU_KEY_BUFFER;
[#if CAU_Algorithm_AlgorithmMode??]
[#if CAU_Algorithm_AlgorithmMode != "TDES-ECB" && CAU_Algorithm_AlgorithmMode != "DES-ECB" && CAU_Algorithm_AlgorithmMode != "TDES-CBC" && CAU_Algorithm_AlgorithmMode != "DES-CBC"]
cau_parameter.key_size = KEY_BUFFER_SIZE;
[/#if]
[#if CAU_Algorithm_AlgorithmMode != "TDES-ECB" && CAU_Algorithm_AlgorithmMode != "DES-ECB" && CAU_Algorithm_AlgorithmMode != "AES-ECB"]
cau_parameter.iv = (uint8_t *)CAU_VECTOR_BUFFER;
cau_parameter.iv_size = sizeof(CAU_VECTOR_BUFFER);
[/#if]
[/#if]
/* INPUT_DATA_BUFFER needs to be filled in by user */
cau_parameter.input = (uint8_t *)INPUT_DATA_BUFFER;
cau_parameter.in_length = Input_Size;

/* Users need to call the generated function manually
    to complete the corresponding function according to their needs */

[/#if]
[/#if]
