[#ftl]
[#-- V1.0.9 --]

    [#if RCU_HighSpeedCrystalOscillator == "Clock Bypass"]
        rcu_osci_bypass_mode_enable(RCU_HXTAL);
    [/#if]
    [#if RCU_LowSpeedCrystalOscillator == "Clock Bypass"]
        rcu_osci_bypass_mode_enable(RCU_LXTAL);
    [/#if]

[#if SCS == "RCU_CKSYSSRC_IRC48MDIV_SYS"]
    rcu_osci_on(RCU_IRC48M);
    while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
    rcu_irc48m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC48MClockTrimAdjustValue});

    [#if CK_AHB?number == 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb_clock_config(${APBPrescaler});

    rcu_irc48mdiv_sys_clock_config(${IRC48MDIV_SYS});
    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC48MDIV_SYS);
    while(RCU_SCSS_IRC48MDIV != rcu_system_clock_source_get());

    [#if CK_AHB?number > 0 && CK_AHB?number <= 24]
        fmc_wscnt_set(FMC_WAIT_STATE_0);
    [#elseif CK_AHB?number > 24 && CK_AHB?number < 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
[#elseif SCS == "RCU_CKSYSSRC_HXTAL"]
    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);

    [#if CK_AHB?number == 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb_clock_config(${APBPrescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_HXTAL);
    while(RCU_SCSS_HXTAL != rcu_system_clock_source_get());

    [#if CK_AHB?number > 0 && CK_AHB?number <= 24]
        fmc_wscnt_set(FMC_WAIT_STATE_0);
    [#elseif CK_AHB?number > 24 && CK_AHB?number < 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
[#elseif SCS == "RCU_CKSYSSRC_IRC32K"]
    rcu_osci_on(RCU_IRC32K);
    while(rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);

    [#if CK_AHB?number == 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb_clock_config(${APBPrescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC32K);
    while(RCU_SCSS_IRC32K != rcu_system_clock_source_get());

    [#if CK_AHB?number > 0 && CK_AHB?number <= 24]
        fmc_wscnt_set(FMC_WAIT_STATE_0);
    [#elseif CK_AHB?number > 24 && CK_AHB?number < 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
[#elseif SCS == "RCU_CKSYSSRC_LXTAL"]
    rcu_osci_on(RCU_LXTAL);
    while(rcu_osci_stab_wait(RCU_LXTAL) != SUCCESS);

    [#if CK_AHB?number == 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb_clock_config(${APBPrescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_LXTAL);
    while(RCU_SCSS_LXTAL != rcu_system_clock_source_get());

    [#if CK_AHB?number > 0 && CK_AHB?number <= 24]
        fmc_wscnt_set(FMC_WAIT_STATE_0);
    [#elseif CK_AHB?number > 24 && CK_AHB?number < 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
[#else]
    rcu_osci_on(RCU_IRC48M);
    while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
    rcu_irc48m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC48MClockTrimAdjustValue});

    [#if CK_AHB?number == 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
    rcu_ahb_clock_config(${AHBPrescaler});
    rcu_apb_clock_config(${APBPrescaler});

    rcu_irc48mdiv_sys_clock_config(${IRC48MDIV_SYS});
    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC48MDIV_SYS);
    while(RCU_SCSS_IRC48MDIV != rcu_system_clock_source_get());

    [#if CK_AHB?number > 0 && CK_AHB?number <= 24]
        fmc_wscnt_set(FMC_WAIT_STATE_0);
    [#elseif CK_AHB?number > 24 && CK_AHB?number < 48]
        fmc_wscnt_set(FMC_WAIT_STATE_1);
    [/#if]
[/#if]

[#if Peripherals?contains("USART0") == true]
    [#if USART0SEL == "RCU_USART0SRC_LXTAL"]
        [#if SCS != "RCU_CKSYSSRC_LXTAL"]
            rcu_osci_on(RCU_LXTAL);
            while(rcu_osci_stab_wait(RCU_LXTAL) != SUCCESS);
        [/#if]
    [#elseif USART0SEL == "RCU_USART0SRC_IRC48MDIV_PER"]
        [#if (SCS != "RCU_CKSYSSRC_IRC48MDIV_SYS") && (SCS != "")]
            rcu_osci_on(RCU_IRC48M);
            while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
            rcu_irc48m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC48MClockTrimAdjustValue});
            rcu_irc48mdiv_per_clock_config(${IRC48MDIV_PER});
        [/#if]
    [/#if]

    [#if USART0SEL != ""]
    rcu_usart_clock_config(IDX_USART0, ${USART0SEL});
    [#else]
    rcu_usart_clock_config(IDX_USART0, RCU_USART0SRC_CKAPB);
    [/#if]
[/#if]

[#if Peripherals?contains("RTC") == true]
    [#if RTCSRC == "RCU_RTCSRC_HXTAL_DIV32"]
        [#if SCS != "RCU_CKSYSSRC_HXTAL"]
            rcu_osci_on(RCU_HXTAL);
            while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);
        [/#if]
    [#elseif RTCSRC == "RCU_RTCSRC_LXTAL"]
        [#if (SCS != "RCU_CKSYSSRC_LXTAL") && (USART0SEL != "RCU_USART0SRC_LXTAL")]
            rcu_osci_on(RCU_LXTAL);
            while(rcu_osci_stab_wait(RCU_LXTAL) != SUCCESS);
        [/#if]
    [#elseif RTCSRC == "RCU_RTCSRC_IRC32K"]
        [#if SCS != "RCU_CKSYSSRC_IRC32K"]
            rcu_osci_on(RCU_IRC32K);
            while(rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);
        [/#if]
    [/#if]

     rcu_rtc_clock_config(${RTCSRC});
[/#if]

[#if Peripherals?contains("FWDGT") == true]
    [#if SCS != "RCU_CKSYSSRC_IRC32K"]
        [#if (RTCSRC != "RCU_RTCSRC_IRC32K")]
            rcu_osci_on(RCU_IRC32K);
            while(rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);
        [/#if]
    [/#if]
[/#if]

[#if Peripherals?contains("ADC") == true]
    [#if ADCSEL == "RCU_ADCSRC_IRC48M_PER"]
        [#if (SCS != "RCU_CKSYSSRC_IRC48MDIV_SYS") && (USART0SEL != "RCU_USART0SRC_IRC48MDIV_PER") && (SCS != "")]
            rcu_osci_on(RCU_IRC48M);
            while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
            rcu_irc48m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC48MClockTrimAdjustValue});
        [/#if]
    [#elseif ADCSEL == "RCU_ADCSRC_HXTAL"]
        [#if (SCS != "RCU_CKSYSSRC_HXTAL") && (RTCSRC != "RCU_RTCSRC_HXTAL_DIV32")]
            rcu_osci_on(RCU_HXTAL);
            while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);
        [/#if]
    [/#if]

    [#if ADCSEL != ""]
    rcu_adc_clock_config(${ADCSEL}, ${ADCPSC});
    [#else]
     rcu_adc_clock_config(RCU_ADCSRC_CKSYS, ${ADCPSC});
    [/#if]
[/#if]

[#if Peripherals?contains("I2C0") == true]
    [#if I2C0SEL == "RCU_I2CSRC_IRC48MDIV_PER"]
        [#if (SCS != "RCU_CKSYSSRC_IRC48MDIV_SYS") && (USART0SEL != "RCU_USART0SRC_IRC48MDIV_PER")
        && (ADCSEL != "RCU_ADCSRC_IRC48M_PER") && (SCS != "")]
            rcu_osci_on(RCU_IRC48M);
            while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
            rcu_irc48m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC48MClockTrimAdjustValue});
        [/#if]
    [/#if]

    [#if I2C0SEL != ""]
    rcu_i2c_clock_config(IDX_I2C0, ${I2C0SEL});
    [#else]
    rcu_i2c_clock_config(IDX_I2C0, RCU_I2CSRC_CKAPB);
    [/#if]
[/#if]

[#if RCU_ClockOutput0 == "Enable"]
    [#if CKOUT0SEL == "RCU_CKOUT0SRC_IRC48M"]
        [#if (SCS != "RCU_CKSYSSRC_IRC48MDIV_SYS") && (USART0SEL != "RCU_USART0SRC_IRC48MDIV_PER")
        && (ADCSEL != "RCU_ADCSRC_IRC48M_PER") && (I2C0SEL != "RCU_I2CSRC_IRC48MDIV_PER") && (SCS != "")]
            rcu_osci_on(RCU_IRC48M);
            while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
            rcu_irc48m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC48MClockTrimAdjustValue});
        [/#if]
    [#elseif CKOUT0SEL == "RCU_CKOUT0SRC_HXTAL"]
        [#if (SCS != "RCU_CKSYSSRC_HXTAL") && (RTCSRC != "RCU_RTCSRC_HXTAL_DIV32") && (ADCSEL != "RCU_ADCSRC_HXTAL")]
            rcu_osci_on(RCU_HXTAL);
            while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);
        [/#if]
    [#elseif CKOUT0SEL == "RCU_CKOUT0SRC_IRC32K"]
        [#if (SCS != "RCU_CKSYSSRC_IRC32K") && (RTCSRC != "RCU_RTCSRC_IRC32K") && (Peripherals?contains("FWDGT") != true)]
            rcu_osci_on(RCU_IRC32K);
            while(rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);
        [/#if]
    [#elseif CKOUT0SEL == "RCU_CKOUT0SRC_LXTAL"]
        [#if (SCS != "RCU_CKSYSSRC_LXTAL") && (USART0SEL != "RCU_USART0SRC_LXTAL")
        && (RTCSRC != "RCU_RTCSRC_LXTAL")]
            rcu_osci_on(RCU_LXTAL);
            while(rcu_osci_stab_wait(RCU_LXTAL) != SUCCESS);
        [/#if]
    [/#if]

    [#if CKOUT0SEL != ""]
    rcu_ckout0_config(${CKOUT0SEL}, ${CKOUT0DIV});
    [#else]
    rcu_ckout0_config(RCU_CKOUT0SRC_NONE);
    [/#if]
[/#if]

[#if RCU_ClockOutput1 == "Enable"]
    [#if CKOUT1SEL == "RCU_CKOUT1SRC_IRC48M"]
        [#if (SCS != "RCU_CKSYSSRC_IRC48MDIV_SYS") && (USART0SEL != "RCU_USART0SRC_IRC48MDIV_PER")
        && (ADCSEL != "RCU_ADCSRC_IRC48M_PER") && (I2C0SEL != "RCU_I2CSRC_IRC48MDIV_PER")
        && (CKOUT0SEL != "RCU_CKOUT0SRC_IRC48M") && (SCS != "")]
            rcu_osci_on(RCU_IRC48M);
            while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
            rcu_irc48m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC48MClockTrimAdjustValue});
        [/#if]
    [#elseif CKOUT1SEL == "RCU_CKOUT1SRC_HXTAL"]
        [#if (SCS != "RCU_CKSYSSRC_HXTAL") && (RTCSRC != "RCU_RTCSRC_HXTAL_DIV32")
        && (CKOUT0SEL != "RCU_CKOUT0SRC_HXTAL") && (ADCSEL != "RCU_ADCSRC_HXTAL")]
            rcu_osci_on(RCU_HXTAL);
            while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);
        [/#if]
    [#elseif CKOUT1SEL == "RCU_CKOUT1SRC_IRC32K"]
        [#if (SCS != "RCU_CKSYSSRC_IRC32K") && ( RTCSRC != "RCU_RTCSRC_IRC32K")
        && (CKOUT0SEL != "RCU_CKOUT0SRC_IRC32K") && (Peripherals?contains("FWDGT") != true)]
            rcu_osci_on(RCU_IRC32K);
            while(rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);
        [/#if]
    [#elseif CKOUT1SEL == "RCU_CKOUT1SRC_LXTAL"]
        [#if (SCS != "RCU_CKSYSSRC_LXTAL") && (USART0SEL != "RCU_USART0SRC_LXTAL")
        && (RTCSRC != "RCU_RTCSRC_LXTAL") && (CKOUT0SEL != "RCU_CKOUT0SRC_LXTAL")]
            rcu_osci_on(RCU_LXTAL);
            while(rcu_osci_stab_wait(RCU_LXTAL) != SUCCESS);
        [/#if]
    [/#if]

    [#if CKOUT1SEL != ""]
    rcu_ckout1_config(${CKOUT1SEL}, ${CKOUT1DIV});
    [#else]
    rcu_ckout1_config(RCU_CKOUT1SRC_NONE);
    [/#if]
[/#if]

[#if RCU_MonitorConfiguration_LXTALMonitor ??== true && RCU_MonitorConfiguration_LXTALMonitor == "Enable"]
    rcu_lxtal_clock_monitor_enable();
[/#if]

/* update SystemCoreClock value */
SystemCoreClockUpdate();

[#if SYS_SystickClockSource == "Source From HCLK"]
/* setup systick timer for 1000Hz interrupts */
if (SysTick_Config(SystemCoreClock / 1000U)){
    /* capture error */
    while (1);
}

systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);
[#elseif SYS_SystickClockSource == "Source From HCLK/8"]
/* setup systick timer for 1000Hz interrupts */
if (SysTick_Config(SystemCoreClock / 8U / 1000U)){
    /* capture error */
    while (1);
}

systick_clksource_set(SYSTICK_CLKSOURCE_HCLK_DIV8);
[/#if]
