/*
    \file  gd32g5x3_it.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3_it.h"
#include "gd32g5x3.h"
#include "gd32g5x3_init.h"
/* External includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
#define SRAM_ECC_ERROR_HANDLE(s) \
    do {                         \
    } while(1)
#define FLASH_ECC_ERROR_HANDLE(s) \
    do {                          \
    } while(1)
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
extern uint8_t transmitter_buffer1[];
extern uint8_t transmitter_buffer2[];
extern uint8_t receiver_buffer1[3];
extern uint8_t receiver_buffer2[3];

extern __IO uint8_t transfersize;
extern __IO uint16_t txcount1;
extern __IO uint16_t txcount2;
extern __IO uint16_t rxcount1;
extern __IO uint16_t rxcount2;

/* user code [Extern Variables] end */

/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */

    if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_TCMSRAMECCME)) {
        SRAM_ECC_ERROR_HANDLE("TCMSRAM multi-bits non-correction ECC error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_SRAM1ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM1 multi-bits non-correction ECC error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_SRAM0ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM0 multi-bits non-correction ECC error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_FLASHECC)) {
        FLASH_ECC_ERROR_HANDLE("FLASH ECC error\r\n");
    } else {
        /* if NMI exception occurs, go to infinite loop */
        /* HXTAL clock monitor NMI error or NMI pin error */
        while(1) {
            /* user code [NMI_IRQn local 1] begin */

            /* user code [NMI_IRQn local 1] end */
        }
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
    while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
    }
}

/*!
    \brief      Memory Management Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void MemManage_Handler(void)
{
    /* user code [MemManage_IRQn local 0] begin */

    /* user code [MemManage_IRQn local 0] end */
    while(1) {
        /* user code [MemManage_IRQn local 1] begin */

        /* user code [MemManage_IRQn local 1] end */
    }
}

/*!
    \brief      Pre-fetch Fault,Memory Access Fault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void BusFault_Handler(void)
{
    /* user code [BusFault_IRQn local 0] begin */

    /* user code [BusFault_IRQn local 0] end */
    while(1) {
        /* user code [BusFault_IRQn local 1] begin */

        /* user code [BusFault_IRQn local 1] end */
    }
}

/*!
    \brief      Undefined Instruction Or Illegal State Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none

*/
void UsageFault_Handler(void)
{
    /* user code [UsageFault_IRQn local 0] begin */

    /* user code [UsageFault_IRQn local 0] end */
    while(1) {
        /* user code [UsageFault_IRQn local 1] begin */

        /* user code [UsageFault_IRQn local 1] end */
    }
}

/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */
    while(1) {
        /* user code [SVC_IRQn local 1] begin */

        /* user code [SVC_IRQn local 1] end */
    }
}

/*!
    \brief      Debug Monitor Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DebugMon_Handler(void)
{
    /* user code [DebugMon_IRQn local 0] begin */

    /* user code [DebugMon_IRQn local 0] end */
    while(1) {
        /* user code [DebugMon_IRQn local 1] begin */

        /* user code [DebugMon_IRQn local 1] end */
    }
}

/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */
    while(1) {
        /* user code [PendSV_IRQn local 1] begin */

        /* user code [PendSV_IRQn local 1] end */
    }
}

/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */

    /* user code [SysTick_IRQn local 0] end */

    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

/*!
    \brief      USART1 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART1_IRQHandler(void)
{
    /* user code [USART1_IRQn local 0] begin */
    if(RESET != usart_interrupt_flag_get(USART1, USART_INT_FLAG_RBNE)) {
        /* receive data */
        receiver_buffer2[rxcount2++] = usart_data_receive(USART1);
        if(rxcount2 == transfersize) {
            usart_interrupt_disable(USART1, USART_INT_RBNE);
        }
    }

    if(RESET != usart_interrupt_flag_get(USART1, USART_INT_FLAG_TBE)) {
        /* transmit data */
        usart_data_transmit(USART1, transmitter_buffer2[txcount2++]);
        if(txcount2 == transfersize) {
            usart_interrupt_disable(USART1, USART_INT_TBE);
        }
    }
    /* user code [USART1_IRQn local 0] end */

    /* user code [USART1_IRQn local 1] begin */

    /* user code [USART1_IRQn local 1] end */
}

/*!
    \brief      USART2 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART2_IRQHandler(void)
{
    /* user code [USART2_IRQn local 0] begin */
    if(RESET != usart_interrupt_flag_get(USART2, USART_INT_FLAG_RBNE)) {
        /* receive data */
        receiver_buffer1[rxcount1++] = usart_data_receive(USART2);
        if(rxcount1 == transfersize) {
            usart_interrupt_disable(USART2, USART_INT_RBNE);
        }
    }

    if(RESET != usart_interrupt_flag_get(USART2, USART_INT_FLAG_TBE)) {
        /* transmit data */
        usart_data_transmit(USART2, transmitter_buffer1[txcount1++]);
        if(txcount1 == transfersize) {
            usart_interrupt_disable(USART2, USART_INT_TBE);
        }
    }
    /* user code [USART2_IRQn local 0] end */

    /* user code [USART2_IRQn local 1] begin */

    /* user code [USART2_IRQn local 1] end */
}


/* user code [Global Functions Implementations] begin */

/* user code [Global Functions Implementations] end */

/* user code [Static Functions Implementations] begin */

/* user code [Static Functions Implementations] end */
