/*
    \file  gd32g5x3_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3_init.h"

/* user code [global 0] begin */

/* user code [global 0] end */

/* External includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);
    nvic_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);
    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);
    nvic_exception_irq_enable(MemoryManagement_IRQn, 0, 0);
    nvic_exception_irq_enable(BusFault_IRQn, 0, 0);
    nvic_exception_irq_enable(UsageFault_IRQn, 0, 0);
    nvic_exception_irq_enable(SVCall_IRQn, 0, 0);
    nvic_exception_irq_enable(DebugMonitor_IRQn, 0, 0);
    nvic_exception_irq_enable(PendSV_IRQn, 0, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);

    rcu_pll_source_config(RCU_PLLSRC_HXTAL);
    rcu_pll_config((2U), (108U), (2U), (2U), (2U));
    rcu_pll_clock_output_enable(RCU_PLLP);
    fmc_wscnt_set(FMC_WAIT_STATE_7);
    rcu_system_clock_source_config(RCU_CKSYSSRC_PLLP);
    rcu_osci_on(RCU_PLL_CK);
    while(rcu_osci_stab_wait(RCU_PLL_CK) != SUCCESS);

    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb1_clock_config(RCU_APB1_CKAHB_DIV1);
    rcu_apb2_clock_config(RCU_APB2_CKAHB_DIV1);
    rcu_apb3_clock_config(RCU_APB3_CKAHB_DIV1);

    rcu_usart_clock_config(IDX_USART0, RCU_USARTSRC_APB);

    rcu_osci_bypass_mode_disable(RCU_HXTAL);
    rcu_osci_bypass_mode_disable(RCU_LXTAL);
    rcu_hxtal_clock_monitor_disable();
    rcu_lxtal_clock_monitor_disable();

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if(SysTick_Config(SystemCoreClock / 1000U)) {
        /* capture error */
        while(1);
    }

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOC);
    rcu_periph_clock_enable(RCU_GPIOA);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOC);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      TIMER0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer0_init(void)
{
    /* user code [timer0_init local 0] begin */

    /* user code [timer0_init local 0] end */

    timer_parameter_struct timer0_parameter;
    timer_oc_parameter_struct timer0_oc_parameter;
    timer_free_complementary_parameter_struct timer0_free_complementary_parameter;
    timer_break_parameter_struct timer0_break_parameter;

    rcu_periph_clock_enable(RCU_TIMER0);

    gpio_af_set(GPIOA, GPIO_AF_6, GPIO_PIN_8);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_8);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_60MHZ, GPIO_PIN_8);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_8);

    timer_struct_para_init(&timer0_parameter);
    timer_channel_output_struct_para_init(&timer0_oc_parameter);
    timer_free_complementary_struct_para_init(&timer0_free_complementary_parameter);
    timer_break_struct_para_init(&timer0_break_parameter);

    timer_adjustment_mode_config(TIMER0, DISABLE);
    timer_auto_reload_shadow_enable(TIMER0);
    timer_counter_initial_register_config(TIMER0, DISABLE);
    timer_upif_backup_config(TIMER0, DISABLE);
    timer_master_slave_mode_config(TIMER0, TIMER_MASTER_SLAVE_MODE_DISABLE);
    timer_master_output0_trigger_source_select(TIMER0, TIMER_TRI_OUT0_SRC_RESET);
    timer_master_output1_trigger_source_select(TIMER0, TIMER_TRI_OUT1_SRC_RESET);
    timer0_parameter.prescaler         = 0;
    timer0_parameter.alignedmode       = TIMER_COUNTER_EDGE;
    timer0_parameter.counterdirection  = TIMER_COUNTER_UP;
    timer0_parameter.period            = 1;
    timer0_parameter.repetitioncounter = 0x00000000;
    timer0_parameter.clockdivision     = TIMER_CKDIV_DIV1;
    timer_init(TIMER0, &timer0_parameter);

    timer_slave_mode_select(TIMER0, TIMER_SLAVE_MODE_EXTERNAL0);
    timer_input_trigger_source_select(TIMER0, TIMER_SMCFG_TRGSEL_ITI14);
    timer0_oc_parameter.outputstate  = TIMER_CCX_ENABLE;
    timer0_oc_parameter.outputnstate = TIMER_CCXN_DISABLE;
    timer0_oc_parameter.ocpolarity   = TIMER_OC_POLARITY_HIGH;
    timer0_oc_parameter.ocidlestate  = TIMER_OC_IDLE_STATE_LOW;
    timer_channel_output_config(TIMER0, TIMER_CH_0, &timer0_oc_parameter);

    timer_channel_output_mode_config(TIMER0, TIMER_CH_0, TIMER_OC_MODE_PWM0);
    timer_channel_output_pulse_value_config(TIMER0, TIMER_CH_0, 1);
    timer_channel_output_shadow_config(TIMER0, TIMER_CH_0, TIMER_OC_SHADOW_DISABLE);
    timer_channel_output_clear_config(TIMER0, TIMER_CH_0, TIMER_OC_CLEAR_DISABLE);
    timer_channel_output_compare_fast_config(TIMER0, TIMER_CH_0, TIMER_OC_FAST_DISABLE);
    timer0_free_complementary_parameter.freecomstate = TIMER_FCCHP_STATE_DISABLE;
    timer_channel_free_complementary_config(TIMER0, TIMER_CH_0, &timer0_free_complementary_parameter);

    timer_channel_composite_pwm_mode_config(TIMER0, TIMER_CH_0, DISABLE);
    timer_output_match_pulse_select(TIMER0, TIMER_CH_0, TIMER_PULSE_OUTPUT_NORMAL);
    timer_multi_mode_channel_mode_config(TIMER0, TIMER_MCH_0, TIMER_MCH_MODE_COMPLEMENTARY);
    timer0_break_parameter.runoffstate     = TIMER_ROS_STATE_DISABLE;
    timer0_break_parameter.ideloffstate    = TIMER_IOS_STATE_DISABLE;
    timer0_break_parameter.deadtime        = 0;
    timer0_break_parameter.outputautostate = TIMER_OUTAUTO_DISABLE;
    timer0_break_parameter.protectmode     = TIMER_CCHP0_PROT_OFF;
    timer0_break_parameter.break0release   = TIMER_BREAK0_UNRELEASE;
    timer0_break_parameter.break1release   = TIMER_BREAK1_UNRELEASE;
    timer_break_config(TIMER0, &timer0_break_parameter);

    timer_internal_trigger_as_external_clock_config(TIMER0, TIMER_SMCFG_TRGSEL_ITI14);

    /* user code [timer0_init local 1] begin */
    /* TIMER0 output enable */
    timer_primary_output_config(TIMER0, ENABLE);

    /* user code [timer0_init local 1] end */
}

/*!
    \brief      TIMER0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer0_deinit(void)
{
    /* user code [timer0_deinit local 0] begin */

    /* user code [timer0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TIMER0);

    timer_deinit(TIMER0);

    /* user code [timer0_deinit local 1] begin */

    /* user code [timer0_deinit local 1] end */
}

/*!
    \brief      TIMER1 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer1_init(void)
{
    /* user code [timer1_init local 0] begin */

    /* user code [timer1_init local 0] end */

    timer_parameter_struct timer1_parameter;
    timer_oc_parameter_struct timer1_oc_parameter;

    rcu_periph_clock_enable(RCU_TIMER1);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_5);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_5);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_60MHZ, GPIO_PIN_5);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_5);

    timer_struct_para_init(&timer1_parameter);
    timer_channel_output_struct_para_init(&timer1_oc_parameter);

    timer_adjustment_mode_config(TIMER1, DISABLE);
    timer_auto_reload_shadow_enable(TIMER1);
    timer_upif_backup_config(TIMER1, DISABLE);
    timer_master_slave_mode_config(TIMER1, TIMER_MASTER_SLAVE_MODE_ENABLE);
    timer_master_output0_trigger_source_select(TIMER1, TIMER_TRI_OUT0_SRC_UPDATE);
    timer1_parameter.prescaler        = 1079;
    timer1_parameter.alignedmode      = TIMER_COUNTER_EDGE;
    timer1_parameter.counterdirection = TIMER_COUNTER_UP;
    timer1_parameter.period           = 0xF9F;
    timer1_parameter.clockdivision    = TIMER_CKDIV_DIV1;
    timer_init(TIMER1, &timer1_parameter);

    timer1_oc_parameter.outputstate = TIMER_CCX_ENABLE;
    timer1_oc_parameter.ocpolarity  = TIMER_OC_POLARITY_HIGH;
    timer_channel_output_config(TIMER1, TIMER_CH_0, &timer1_oc_parameter);

    timer_channel_output_mode_config(TIMER1, TIMER_CH_0, TIMER_OC_MODE_PWM0);
    timer_channel_output_pulse_value_config(TIMER1, TIMER_CH_0, 0x7D0);
    timer_channel_output_shadow_config(TIMER1, TIMER_CH_0, TIMER_OC_SHADOW_DISABLE);
    timer_channel_output_clear_config(TIMER1, TIMER_CH_0, TIMER_OC_CLEAR_DISABLE);
    timer_channel_output_compare_fast_config(TIMER1, TIMER_CH_0, TIMER_OC_FAST_DISABLE);
    timer_channel_composite_pwm_mode_config(TIMER1, TIMER_CH_0, DISABLE);
    timer_output_match_pulse_select(TIMER1, TIMER_CH_0, TIMER_PULSE_OUTPUT_NORMAL);

    /* user code [timer1_init local 1] begin */

    /* user code [timer1_init local 1] end */
}

/*!
    \brief      TIMER1 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer1_deinit(void)
{
    /* user code [timer1_deinit local 0] begin */

    /* user code [timer1_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TIMER1);

    timer_deinit(TIMER1);

    /* user code [timer1_deinit local 1] begin */

    /* user code [timer1_deinit local 1] end */
}

/*!
    \brief      TIMER7 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer7_init(void)
{
    /* user code [timer7_init local 0] begin */

    /* user code [timer7_init local 0] end */

    timer_parameter_struct timer7_parameter;
    timer_oc_parameter_struct timer7_oc_parameter;
    timer_free_complementary_parameter_struct timer7_free_complementary_parameter;
    timer_break_parameter_struct timer7_break_parameter;

    rcu_periph_clock_enable(RCU_TIMER7);

    gpio_af_set(GPIOC, GPIO_AF_4, GPIO_PIN_6);
    gpio_mode_set(GPIOC, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_6);
    gpio_output_options_set(GPIOC, GPIO_OTYPE_PP, GPIO_OSPEED_60MHZ, GPIO_PIN_6);
    gpio_input_filter_set(GPIOC, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_6);

    timer_struct_para_init(&timer7_parameter);
    timer_channel_output_struct_para_init(&timer7_oc_parameter);
    timer_free_complementary_struct_para_init(&timer7_free_complementary_parameter);
    timer_break_struct_para_init(&timer7_break_parameter);

    timer_adjustment_mode_config(TIMER7, DISABLE);
    timer_auto_reload_shadow_enable(TIMER7);
    timer_counter_initial_register_config(TIMER7, DISABLE);
    timer_upif_backup_config(TIMER7, DISABLE);
    timer_master_slave_mode_config(TIMER7, TIMER_MASTER_SLAVE_MODE_ENABLE);
    timer_master_output0_trigger_source_select(TIMER7, TIMER_TRI_OUT0_SRC_UPDATE);
    timer_master_output1_trigger_source_select(TIMER7, TIMER_TRI_OUT1_SRC_RESET);
    timer7_parameter.prescaler         = 0;
    timer7_parameter.alignedmode       = TIMER_COUNTER_EDGE;
    timer7_parameter.counterdirection  = TIMER_COUNTER_UP;
    timer7_parameter.period            = 1;
    timer7_parameter.repetitioncounter = 0x00000000;
    timer7_parameter.clockdivision     = TIMER_CKDIV_DIV1;
    timer_init(TIMER7, &timer7_parameter);

    timer_slave_mode_select(TIMER7, TIMER_SLAVE_MODE_EXTERNAL0);
    timer_input_trigger_source_select(TIMER7, TIMER_SMCFG_TRGSEL_ITI1);
    timer7_oc_parameter.outputstate  = TIMER_CCX_ENABLE;
    timer7_oc_parameter.outputnstate = TIMER_CCXN_DISABLE;
    timer7_oc_parameter.ocpolarity   = TIMER_OC_POLARITY_HIGH;
    timer7_oc_parameter.ocidlestate  = TIMER_OC_IDLE_STATE_LOW;
    timer_channel_output_config(TIMER7, TIMER_CH_0, &timer7_oc_parameter);

    timer_channel_output_mode_config(TIMER7, TIMER_CH_0, TIMER_OC_MODE_PWM0);
    timer_channel_output_pulse_value_config(TIMER7, TIMER_CH_0, 1);
    timer_channel_output_shadow_config(TIMER7, TIMER_CH_0, TIMER_OC_SHADOW_DISABLE);
    timer_channel_output_clear_config(TIMER7, TIMER_CH_0, TIMER_OC_CLEAR_DISABLE);
    timer_channel_output_compare_fast_config(TIMER7, TIMER_CH_0, TIMER_OC_FAST_DISABLE);
    timer7_free_complementary_parameter.freecomstate = TIMER_FCCHP_STATE_DISABLE;
    timer_channel_free_complementary_config(TIMER7, TIMER_CH_0, &timer7_free_complementary_parameter);

    timer_channel_composite_pwm_mode_config(TIMER7, TIMER_CH_0, DISABLE);
    timer_output_match_pulse_select(TIMER7, TIMER_CH_0, TIMER_PULSE_OUTPUT_NORMAL);
    timer_multi_mode_channel_mode_config(TIMER7, TIMER_MCH_0, TIMER_MCH_MODE_COMPLEMENTARY);
    timer7_break_parameter.runoffstate     = TIMER_ROS_STATE_DISABLE;
    timer7_break_parameter.ideloffstate    = TIMER_IOS_STATE_DISABLE;
    timer7_break_parameter.deadtime        = 0;
    timer7_break_parameter.outputautostate = TIMER_OUTAUTO_DISABLE;
    timer7_break_parameter.protectmode     = TIMER_CCHP0_PROT_OFF;
    timer7_break_parameter.break0release   = TIMER_BREAK0_UNRELEASE;
    timer7_break_parameter.break1release   = TIMER_BREAK1_UNRELEASE;
    timer_break_config(TIMER7, &timer7_break_parameter);

    timer_internal_trigger_as_external_clock_config(TIMER7, TIMER_SMCFG_TRGSEL_ITI1);

    /* user code [timer7_init local 1] begin */
    /* TIMER0 output enable */
    timer_primary_output_config(TIMER7, ENABLE);

    /* user code [timer7_init local 1] end */
}

/*!
    \brief      TIMER7 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer7_deinit(void)
{
    /* user code [timer7_deinit local 0] begin */

    /* user code [timer7_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TIMER7);

    timer_deinit(TIMER7);

    /* user code [timer7_deinit local 1] begin */

    /* user code [timer7_deinit local 1] end */
}

/*!
    \brief      TRIGSEL initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_trigsel_init(void)
{
    /* user code [trigsel_init local 0] begin */

    /* user code [trigsel_init local 0] end */

    rcu_periph_clock_enable(RCU_TRIGSEL);

    trigsel_init(TRIGSEL_OUTPUT_TIMER0_ITI14, TRIGSEL_INPUT_TIMER7_TRGO0);

    /* user code [trigsel_init local 1] begin */

    /* user code [trigsel_init local 1] end */
}

/*!
    \brief      TRIGSEL deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_trigsel_deinit(void)
{
    /* user code [trigsel_deinit local 0] begin */

    /* user code [trigsel_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TRIGSEL);

    trigsel_deinit();

    /* user code [trigsel_deinit local 1] begin */

    /* user code [trigsel_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_10);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_9);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_receiver_timeout_disable(USART0);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_fifo_disable(USART0);
    usart_overrun_disable(USART0);
    usart_reception_error_dma_disable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_USART0);

    usart_deinit(USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
