/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#include "stdio.h"
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
  #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
  #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
  #error Not supported toolchain
#endif

#define ADD_SIZE 50
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
/*
    array of input values in -32767~32768
    the data is calculated by using 'x[i]=25000*(sin(2*pi*500/16000*i)+0.2*sin(2*pi*5*500/16000*i));' i goes from 51 to 100
    the useful signal frequency is 500Hz, and the noise signal frequency is 2500Hz
*/
int16_t add_data[ADD_SIZE] = {
    -14865, -14142, -15883, -21184, -27297, -30000, -27297,
    -21184, -15883, -14142, -14865, -14186, -9035,
    0,      9035,   14186,  14865,  14142,  15883,  21184,
    27297,  30000,  27297,  21184,  15883,  14142,
    14865,  14186,  9035,   0,      -9035,  -14186, -14865,
    -14142, -15883, -21184, -27297, -30000, -27297,
    -21184, -15883, -14142, -14865, -14186, -9035,  0,
    9035,   14186,  14865,  14142,
};

/* array of calculated filtered data by computer */
/* size = INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1 */
const int16_t reference_data[98] = {
    1079,   2044,   3204,   4541,   6122,   8005,   10128,  12287,
    14228,  15784,  16927,  17711,  18146,  18135,
    17514,  16178,  14178,  11694,  8918,   5948,   2775,   -615,
    -4130,  -7546,  -10600, -13121, -15086, -16554,
    -17548, -17979, -17698, -16615, -14791, -12419, -9704,  -6754,
    -3568,  -141,   3426,   6906,   10030,  12624,
    14660,  16197,  17255,  17745,  17516,  16478,  14694,  12355,
    9667,   6738,   3570,   156,    -3402,  -6876,
    -9996,  -12589, -14625, -16163, -17222, -17715, -17489, -16455,
    -14673, -12338, -9653,  -6727,  -3561,  -149,
    3407,   6879,   9999,   12590,  14625,  16162,  17222,  17714,
    17488,  16453,  14672,  12336,  9652,   6726,
    3560,   148,    -3408,  -6880,  -9999,  -12590, -14625, -16163,
    -17222, -17714, -17488, -16453, -14672, -12336,
};

/* array of calculated filtered data in Q1.15 format */
/* size = INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1 */
int16_t calculated_data[INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1] = {0};
volatile int16_t error[INPUT_DATA_SIZE + ADD_SIZE - FAC_COEFFB + 1] = {0};

int16_t add_data[ADD_SIZE];

/* read data point */
__IO int16_t *pOutput      = NULL;
__IO uint16_t pOutputSize  = 0;
__IO uint16_t curOutputCnt = 0;

/* write data point */
__IO int16_t *pInput      = NULL;
__IO uint16_t pInputSize  = 0;
__IO uint16_t curInputCnt = 0;

/* calculate success flag */
__IO uint8_t rd_complete;
__IO uint8_t wr_complete;
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint16_t i;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_fac_init();
    msd_usart0_init();

    /* user code [local 2] begin */

    /* enable interrupt */
    fac_interrupt_enable(FAC_CTL_WIE | FAC_CTL_RIE);
    /* start filter calculation */
    fac_start();

    while((wr_complete == 0) || (rd_complete == 0));
    for(i = 0; i < 98; i++) {
        error[i] = reference_data[i] - calculated_data[i];
        printf("%d\r\n", calculated_data[i]);
    }

    /* finish calculation */
    fac_finish_calculate();
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief retarget the C library printf function to the USART
    \param[in] ch: The character to be transmitted via USART.
    \param[in] f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval ch: The character that was transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
