/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#define ARRAYNUM(arr_nanme)    (uint32_t)(sizeof(arr_nanme) / sizeof(*(arr_nanme)))
#define TRANSMIT_SIZE          (ARRAYNUM(transmitter_buffer) - 1)

uint8_t transmitter_buffer[] = "\n\rUSART DMA transmint and receive test, please transimt equal to 32 Bytes data\n\r";
uint8_t receiver_buffer[32];
__IO FlagStatus tx_end = RESET;
__IO FlagStatus rx_end = RESET;

void tx_complete(hal_uart_dev_struct *uart);
void rx_complete(hal_uart_dev_struct *uart);
void error_cb(hal_uart_dev_struct *uart);
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    hal_uart_user_callback_struct user_cb;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_dma_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    /* initialize the uart user callback structure */
    hal_uart_struct_init(HAL_UART_USER_CALLBCAK_STRUCT, &user_cb);
    user_cb.error_func = error_cb;
    user_cb.complete_func = tx_complete;

    /* transimt data using DMA mode */
    hal_uart_transmit_dma(&uart0_info, transmitter_buffer, TRANSMIT_SIZE, &user_cb);
    while(RESET == tx_end) {
    }
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */
      rx_end = RESET;
      user_cb.complete_func = rx_complete;
      /* receive data using DMA mode */
      hal_uart_receive_dma(&uart0_info, receiver_buffer, 32, &user_cb);
      while(RESET == rx_end) {
      }
      printf("\n\rUSART receive successfully!\n\r");
    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
    \brief      transimt complete user callback function
    \param[in]  uart: uart device information structure
    \param[out] none
    \retval     none
*/
void tx_complete(hal_uart_dev_struct *uart)
{
    tx_end = SET;
}

/*!
    \brief      receive complete user callback function
    \param[in]  uart: uart device information structure
    \param[out] none
    \retval     none
*/
void rx_complete(hal_uart_dev_struct *uart)
{
    rx_end = SET;
}

/*!
    \brief      error user callback function
    \param[in]  uart: uart device information structure
    \param[out] none
    \retval     none
*/
void error_cb(hal_uart_dev_struct *uart)
{
    printf("\n\rUSART error state: %u\n\r", uart->error_state);
    printf("USART last error state: %u\n\r", uart->last_error);
}

/*!
    \brief      retarget the C library printf function to the USART
    \param[in]  none
    \param[out] none
    \retval     none
*/
#ifdef __GNUC__
/* With GCC, small printf (option LD Linker->Libraries->Small printf
   set to 'Yes') calls __io_putchar() */
#define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
    int __io_putchar(int ch)
    {
        hal_uart_transmit_poll(&uart0_info, (uint8_t*)&ch, 1, 0x1FFFFF);
        return ch;
    }
#else
#define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
    int fputc(int ch, FILE *f)
    {
        hal_uart_transmit_poll(&uart0_info, (uint8_t*)&ch, 1, 0x1FFFFF);
        return ch;
    }
#endif /* __GNUC__ */
/* user code [global 1] end */	
