/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#define MASTER_BOARD
#define ARRAYNUM(arr_nanme)      (uint32_t)(sizeof(arr_nanme) / sizeof(*(arr_nanme)))
/* buffer used for transmission */
uint8_t tx_buffer[] = "I2C communication based on polling on two boards";
/* size of transmission buffer */
#define TXBUFFERSIZE        (ARRAYNUM(tx_buffer) - 1)
/* size of reception buffer */
#define RXBUFFERSIZE        TXBUFFERSIZE
/* slave address */
#define I2C_SLAVE_ADDRESS   0X82
/* buffer used for reception */
uint8_t rx_buffer[RXBUFFERSIZE];
static ErrStatus memory_compare(uint8_t* src, uint8_t* dst, uint16_t length);
static void error_handler(void);
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_i2c0_init();

    /* user code [local 2] begin */
#ifdef MASTER_BOARD

    i2c0_info.slave_address.device_address = I2C_SLAVE_ADDRESS;
    /* wait for Tamper key push-button press before starting the communication */
    /* wait for Tamper key push-button press before starting the communication */
    while(RESET != hals_gpio_input_bit_get(GPIOA, GPIO_PIN_0)){
    }
    /* wait for Tamper key push-button release before starting the communication */
    while(SET != hals_gpio_input_bit_get(GPIOA, GPIO_PIN_0)){
    }

    /* the master board sends the message and expects to receive it back */
    /* the master board transmit the data stored in tx_buffer to the slave board */
    if(HAL_ERR_NONE != hal_i2c_master_transmit_poll(&i2c0_info, (uint8_t*)tx_buffer, TXBUFFERSIZE, 10000)){
        /* error_handler() function is called when error occurs */
        error_handler();
    }

    /* wait for Tamper key push-button press before starting the communication */
    while(RESET != hals_gpio_input_bit_get(GPIOA, GPIO_PIN_0)){
    }
    /* wait for Tamper key push-button release before starting the communication */
    while(SET != hals_gpio_input_bit_get(GPIOA, GPIO_PIN_0)){
    }

    /* the master board transmit the data stored in tx_buffer to the slave board */
    if(HAL_ERR_NONE != hal_i2c_master_receive_poll(&i2c0_info, (uint8_t*)rx_buffer, RXBUFFERSIZE, 10000)){
        /* error_handler() function is called when error occurs */
        error_handler();
    }

#else
    while(HAL_ERR_NONE != hal_i2c_slave_receive_poll(&i2c0_info, (uint8_t*)rx_buffer, RXBUFFERSIZE, 10000)){
        /* error_handler() function is called when error occurs */
        error_handler();
    }

    while(HAL_ERR_NONE != hal_i2c_slave_transmit_poll(&i2c0_info, (uint8_t*)tx_buffer, TXBUFFERSIZE, 10000)){
        /* error_handler() function is called when error occurs */
        error_handler();
    }

#endif /* MASTER_BOARD */
    /* compare the sent data and received data */
    if(SUCCESS != memory_compare((uint8_t*)tx_buffer,(uint8_t*)rx_buffer, RXBUFFERSIZE)){
        /* processing error */
        error_handler();
    }

    hals_gpio_bit_write(GPIOC, GPIO_PIN_11,SET);
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */

    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
    \brief      this function is called when error occurs
    \param[in]  none
    \param[out] none
    \retval     none
*/
static void error_handler(void)
{
    /* turn LED1 on */
    hals_gpio_bit_write(GPIOC, GPIO_PIN_10,SET);
    while(1){
    }
}

/*!
    \brief      memory compare function
    \param[in]  src : source data
    \param[in]  dst : destination data
    \param[in]  length : the compare data length
    \param[out] none
    \retval     ErrStatus : ERROR or SUCCESS
*/
static ErrStatus memory_compare(uint8_t* src, uint8_t* dst, uint16_t length)
{
    while(length--){
        if(*src++ != *dst++){
            return ERROR;
        }
    }
    return SUCCESS;
}
/* user code [global 1] end */	
