/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
float temperature;
float vref_value;
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_adc_init();

    /* user code [local 2] begin */
    /* enable USART */
    gd_eval_com_init(EVAL_COM);

    /* print message through EVAL_COM */
    printf("\r\n ADC Temperature and VREFINT channel sampling with polling demo! \r\n");
    /* start ADC module function */
    hal_adc_start(&adc_info);
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */
        hal_adc_inserted_conversion_poll(&adc_info, 2);

        /* value convert */
        temperature = (1.43f - ADC_RDATA * 3.3f / 4096) * 1000 / 4.3f + 25;
        vref_value = (ADC_IDATA0 * 3.3f / 4096);

        /* value print */
        printf(" \r\n ==================================\r\n");
        printf(" the current Temperature value is %2.0f degrees Celsius,\r\n", temperature);
        printf(" the current Reference voltage value VREFINT is %5.3fV. \r\n", vref_value);

        /* basetick delay for 1500ms */
        hal_sys_basetick_delay_ms(1500);
        /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/* user code [global 1] end */	
