/*
    \file  gd32c2x1_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);

    nvic_irq_enable(NonMaskableInt_IRQn, 0);
    nvic_irq_enable(HardFault_IRQn, 0);
    nvic_irq_enable(SVCall_IRQn, 0);
    nvic_irq_enable(PendSV_IRQn, 0);
    nvic_irq_enable(SysTick_IRQn, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_IRC48M);
    while (rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
    rcu_irc48m_adjust_value_set(16);

    fmc_wscnt_set(FMC_WAIT_STATE_1);
    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb_clock_config(RCU_APB_CKAHB_DIV1);

    rcu_irc48mdiv_sys_clock_config(RCU_IRC48MDIV_SYS_1);
    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC48MDIV_SYS);
    while (RCU_CKSYSSRC_IRC48MDIV_SYS != rcu_system_clock_source_get());

    rcu_usart_clock_config(IDX_USART0, RCU_USART0SRC_CKAPB);

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 1000U))
    {
        /* capture error */
        while (1);
    }

    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOD);
    rcu_periph_clock_enable(RCU_GPIOB);
    rcu_periph_clock_enable(RCU_GPIOA);

    gpio_bit_reset(GPIOA, GPIO_PIN_15);
    gpio_mode_set(GPIOA, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_15);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_15);

    gpio_bit_reset(GPIOD, GPIO_PIN_1);
    gpio_mode_set(GPIOD, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_1);
    gpio_output_options_set(GPIOD, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_1);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOD);
    rcu_periph_clock_disable(RCU_GPIOB);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      SPI0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_spi0_init(void)
{
    /* user code [spi0_init local 0] begin */

    /* user code [spi0_init local 0] end */

    spi_parameter_struct spi0_parameter;

    rcu_periph_clock_enable(RCU_SPI0);

    gpio_af_set(GPIOB, GPIO_AF_0, GPIO_PIN_3);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_3);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_3);

    gpio_af_set(GPIOA, GPIO_AF_0, GPIO_PIN_6);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_6);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_6);

    gpio_af_set(GPIOA, GPIO_AF_0, GPIO_PIN_7);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_7);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_7);

    gpio_af_set(GPIOB, GPIO_AF_0, GPIO_PIN_0);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_0);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_0);

    spi_struct_para_init(&spi0_parameter);

    spi0_parameter.device_mode = SPI_SLAVE;
    spi0_parameter.trans_mode = SPI_TRANSMODE_FULLDUPLEX;
    spi0_parameter.nss = SPI_NSS_HARD;
    spi0_parameter.endian = SPI_ENDIAN_MSB;
    spi0_parameter.clock_polarity_phase = SPI_CK_PL_HIGH_PH_2EDGE;
    spi0_parameter.frame_size = SPI_FRAMESIZE_8BIT;
    spi0_parameter.prescale = SPI_PSC_8;
    spi_init(SPI0, &spi0_parameter);

    /* user code [spi0_init local 1] begin */

    /* user code [spi0_init local 1] end */
}

/*!
    \brief      SPI0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_spi0_deinit(void)
{
    /* user code [spi0_deinit local 0] begin */

    /* user code [spi0_deinit local 0] end */
    spi_i2s_deinit(SPI0);

    rcu_periph_clock_disable(RCU_SPI0);

    /* user code [spi0_deinit local 1] begin */

    /* user code [spi0_deinit local 1] end */
}

/*!
    \brief      SPI1 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_spi1_init(void)
{
    /* user code [spi1_init local 0] begin */

    /* user code [spi1_init local 0] end */

    spi_parameter_struct spi1_parameter;

    rcu_periph_clock_enable(RCU_SPI1);

    gpio_af_set(GPIOB, GPIO_AF_0, GPIO_PIN_14);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_14);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_14);

    gpio_af_set(GPIOB, GPIO_AF_0, GPIO_PIN_13);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_13);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_13);

    gpio_af_set(GPIOB, GPIO_AF_0, GPIO_PIN_15);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_15);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_15);

    gpio_af_set(GPIOB, GPIO_AF_5, GPIO_PIN_9);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_1, GPIO_PIN_9);

    spi_struct_para_init(&spi1_parameter);

    spi1_parameter.device_mode = SPI_MASTER;
    spi1_parameter.trans_mode = SPI_TRANSMODE_FULLDUPLEX;
    spi1_parameter.nss = SPI_NSS_HARD;
    spi1_parameter.endian = SPI_ENDIAN_MSB;
    spi1_parameter.clock_polarity_phase = SPI_CK_PL_HIGH_PH_2EDGE;
    spi1_parameter.frame_size = SPI_FRAMESIZE_8BIT;
    spi1_parameter.prescale = SPI_PSC_8;
    spi_init(SPI1, &spi1_parameter);

    spi_fifo_access_size_config(SPI1, SPI_BYTE_ACCESS);
    spi_nss_output_enable(SPI1);

    /* user code [spi1_init local 1] begin */

    /* user code [spi1_init local 1] end */
}

/*!
    \brief      SPI1 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_spi1_deinit(void)
{
    /* user code [spi1_deinit local 0] begin */

    /* user code [spi1_deinit local 0] end */
    spi_i2s_deinit(SPI1);

    rcu_periph_clock_disable(RCU_SPI1);

    /* user code [spi1_deinit local 1] begin */

    /* user code [spi1_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_overrun_enable(USART0);
    usart_reception_error_dma_enable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */
    usart_deinit(USART0);

    rcu_periph_clock_disable(RCU_USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
