/*
    \file  gd32c2x1_it.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_it.h"
#include "gd32c2x1.h"
#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
#define SRAM_ECC_ERROR_HANDLE(s) \
    do {                          \
    } while(1)
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
extern volatile uint16_t address_byte_flag;
extern volatile uint16_t eeprom_address;
extern volatile uint8_t *pwbuffer, *prbuffer;
extern volatile ErrStatus status;
extern volatile uint32_t nbytes_read;
extern volatile uint8_t gaddress;
extern volatile uint16_t tx_nBytes;
extern volatile uint16_t rx_nBytes;
/* user code [Extern Variables] end */
/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */
    if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM two bits non-correction check error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCSE)) {
        SRAM_ECC_ERROR_HANDLE("RAM single bit correction check error\r\n");
    } else {
        /* if NMI exception occurs, go to infinite loop */
        /* HXTAL clock monitor NMI error or NMI pin error */
        while(1) {
            /* user code [NMI_IRQn local 1] begin */

            /* user code [NMI_IRQn local 1] end */
        }
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
	while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
	}
}

/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */
    while(1) {
    	/* user code [SVC_IRQn local 1] begin */

    	/* user code [SVC_IRQn local 1] end */
    }
}

/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */
    while(1) {
    	/* user code [PendSV_IRQn local 1] begin */

    	/* user code [PendSV_IRQn local 1] end */
    }
}

/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */
	delay_decrement();
    /* user code [SysTick_IRQn local 0] end */

    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

/*!
    \brief      I2C1 Event Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_EV_IRQHandler(void)
{
    /* user code [I2C1_EV_IRQn local 0] begin */
	i2c_event_irq_handler();
    /* user code [I2C1_EV_IRQn local 0] end */

    /* user code [I2C1_EV_IRQn local 1] begin */

    /* user code [I2C1_EV_IRQn local 1] end */
}

/*!
    \brief      I2C1 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_ER_IRQHandler(void)
{
    /* user code [I2C1_ER_IRQn local 0] begin */
	i2c_error_irq_handler();
    /* user code [I2C1_ER_IRQn local 0] end */

    /* user code [I2C1_ER_IRQn local 1] begin */

    /* user code [I2C1_ER_IRQn local 1] end */
}


/* user code [Global Functions Implementations] begin */
/*!
    \brief      handle I2C1 event interrupt request
    \param[in]  none
    \param[out] none
    \retval     none
*/
void i2c_event_irq_handler(void)
{
    if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_STPDET)) {
        i2c_interrupt_flag_clear(I2C1, I2C_INT_FLAG_STPDET);
    } else if((i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_RBNE)) && (rx_nBytes)) {
        /* read a data byte from I2C_RDATA*/
        *prbuffer++ = i2c_data_receive(I2C1);
        rx_nBytes--;
    } else if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_TI)) {
        if(1 == address_byte_flag) {
            /* send the EEPROM's internal address to write to */
            i2c_data_transmit(I2C1, gaddress);
        }
        if(tx_nBytes > 0) {
            /* send a data byte */
            i2c_data_transmit(I2C1, *pwbuffer++);
            tx_nBytes--;
        }
    } else if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_TCR)) {
        rx_nBytes = nbytes_read - 255;
        i2c_transfer_byte_number_config(I2C1, rx_nBytes);
        /* disable I2C reload mode */
        if(rx_nBytes <= 255) {
            i2c_reload_disable(I2C1);
        }
    } else if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_TC)) {
        if(1 == address_byte_flag) {
            i2c_master_addressing(I2C1, eeprom_address, I2C_MASTER_RECEIVE);
            i2c_reload_enable(I2C1);
            /* configure number of bytes to be transferred */
            i2c_transfer_byte_number_config(I2C1, 255);
            rx_nBytes = 255;
            address_byte_flag = 0;
            i2c_start_on_bus(I2C1);
        } else {
            i2c_stop_on_bus(I2C1);
            status = SUCCESS;
        }
    }
}

/*!
    \brief      handle I2C1 error interrupt request
    \param[in]  none
    \param[out] none
    \retval     none
*/
void i2c_error_irq_handler(void)
{
    /* bus error */
    if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_BERR)) {
        i2c_interrupt_flag_clear(I2C1, I2C_INT_FLAG_BERR);
    }

    /* arbitration lost */
    if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_LOSTARB)) {
        i2c_interrupt_flag_clear(I2C1, I2C_INT_FLAG_LOSTARB);
    }

    /* over-run or under-run when SCL stretch is disabled */
    if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_OUERR)) {
        i2c_interrupt_flag_clear(I2C1, I2C_INT_FLAG_OUERR);
    }

    /* PEC error */
    if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_PECERR)) {
        i2c_interrupt_flag_clear(I2C1, I2C_INT_FLAG_PECERR);
    }

    /* timeout error */
    if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_TIMEOUT)) {
        i2c_interrupt_flag_clear(I2C1, I2C_INT_FLAG_TIMEOUT);
    }

    /* SMBus alert */
    if(i2c_interrupt_flag_get(I2C1, I2C_INT_FLAG_SMBALT)) {
        i2c_interrupt_flag_clear(I2C1, I2C_INT_FLAG_SMBALT);
    }

    /* disable the I2C1 interrupt */
    i2c_interrupt_disable(I2C1, I2C_INT_ERR | I2C_INT_STPDET | I2C_INT_RBNE | I2C_INT_TC | I2C_INT_TI);
}
/* user code [Global Functions Implementations] end */

/* user code [Static Functions Implementations] begin */

/* user code [Static Functions Implementations] end */
