/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1.h"
#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */
#include <stdio.h>
#include <string.h>
/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif

#define DATANUM 16
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
uint8_t source_address[DATANUM] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
                                   0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10};
uint8_t destination_address[DATANUM];

__IO ErrStatus transferflag       = ERROR;
__IO uint32_t g_transfer_complete = 0U;
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
static ErrStatus uc_data_compare(uint8_t *src, uint8_t *dst, uint16_t length);
/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */
    memset(destination_address, 0, DATANUM);
    /* user code [local 1] end */


    msd_gpio_init();
    msd_dma_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    dma_transfer_number_config(DMA_CH0, DATANUM);
    dma_periph_address_config(DMA_CH0, (uint32_t)destination_address);
    dma_memory_address_config(DMA_CH0, (uint32_t)source_address);
    dma_channel_enable(DMA_CH0);

    /* wait for DMA transfer complete */
    while(1U != g_transfer_complete);

    /* compare the data of source_address with data of destination_address */
    transferflag = uc_data_compare(source_address, destination_address, DATANUM);

    if(SUCCESS != transferflag) {
        /* error */
        gpio_bit_set(GPIOA, GPIO_PIN_15);
    } else {
        /* success */
        gpio_bit_set(GPIOD, GPIO_PIN_1);
    }
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      data compare function
    \param[in]  src: source data
    \param[in]  dst: destination data
    \param[in]  length: the compare data length
    \param[out] none
    \retval     ErrStatus: ERROR or SUCCESS
*/
static ErrStatus uc_data_compare(uint8_t *src, uint8_t *dst, uint16_t length)
{
    while(length--) {
        if(*src++ != *dst++) {
            return ERROR;
        }
    }
    return SUCCESS;
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in] ch: The character to be transmitted via USART.
    \param[in] f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval ch: The character that was transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
