/*!
    \file    gd32m53x_libopt.h
    \brief   library optional for gd32m53x

    \version 2025-03-24, V0.2.1, firmware for GD32M53x
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32M53X_LIBOPT_H
#define GD32M53X_LIBOPT_H

#include "gd32m53x_adc.h"
#include "gd32m53x_can.h"
#include "gd32m53x_cfmu.h"
#include "gd32m53x_cmp.h"
#include "gd32m53x_cptimer.h"
#include "gd32m53x_cptimerw.h"
#include "gd32m53x_crc.h"
#include "gd32m53x_dac.h"
#include "gd32m53x_dbg.h"
#include "gd32m53x_dma.h"
#include "gd32m53x_evic.h"
#include "gd32m53x_exti.h"
#include "gd32m53x_fmc.h"
#include "gd32m53x_fwdgt.h"
#include "gd32m53x_gpio.h"
#include "gd32m53x_gptimer.h"
#include "gd32m53x_gtoc.h"
#include "gd32m53x_i2c.h"
#include "gd32m53x_misc.h"
#include "gd32m53x_pmu.h"
#include "gd32m53x_poc.h"
#include "gd32m53x_rcu.h"
#include "gd32m53x_spi.h"
#include "gd32m53x_svpwm.h"
#include "gd32m53x_syscfg.h"
#include "gd32m53x_timer.h"
#include "gd32m53x_tmu.h"
#include "gd32m53x_uart.h"
#include "gd32m53x_wwdgt.h"

#endif /* GD32M53X_LIBOPT_H */
