/*!
    \file    gd32h77x_libopt.h
    \brief   library optional for gd32h77x

    \version 2025-12-10, V0.3.0, firmware for GD32H77x
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32H77X_LIBOPT_H
#define GD32H77X_LIBOPT_H

#include "gd32h77x_adc.h"
#include "gd32h77x_axiim.h"
#include "gd32h77x_can.h"
#include "gd32h77x_cau.h"
#include "gd32h77x_cmp.h"
#include "gd32h77x_cpdm.h"
#include "gd32h77x_crc.h"
#include "gd32h77x_ctc.h"
#include "gd32h77x_dac.h"
#include "gd32h77x_dbg.h"
#include "gd32h77x_dci.h"
#include "gd32h77x_dma.h"
#if (defined(GD32H77DXW)) || (defined(GD32H77DXP)) || (defined(GD32H77DXI))
#include "gd32h77x_dsi.h"
#endif /* (defined(GD32H77DXW)) || (defined(GD32H77DXP)) || (defined(GD32H77DXI)) */
#include "gd32h77x_edim.h"
#include "gd32h77x_edim_biss.h"
#include "gd32h77x_edim_endat.h"
#include "gd32h77x_edim_afmt.h"
#include "gd32h77x_edim_tfmt.h"
#include "gd32h77x_edim_hdsl.h"
#include "gd32h77x_edout.h"
#include "gd32h77x_enet.h"
#if (defined(GD32H77EXW)) || (defined(GD32H77EXP)) || (defined(GD32H77EXI))
#include "gd32h77x_esc.h"
#endif /* (defined(GD32H77EXW)) || (defined(GD32H77EXP)) || (defined(GD32H77EXI)) */
#include "gd32h77x_exmc.h"
#include "gd32h77x_exti.h"
#include "gd32h77x_fac.h"
#include "gd32h77x_fft.h"
#include "gd32h77x_fwdgt.h"
#include "gd32h77x_gpio.h"
#include "gd32h77x_gpsi.h"
#include "gd32h77x_hau.h"
#include "gd32h77x_hpdf.h"
#include "gd32h77x_hwsem.h"
#include "gd32h77x_i2c.h"
#include "gd32h77x_ipa.h"
#include "gd32h77x_lpdts.h"
#include "gd32h77x_mdio.h"
#include "gd32h77x_mdma.h"
#include "gd32h77x_misc.h"
#include "gd32h77x_nvmc.h"
#include "gd32h77x_ospi.h"
#include "gd32h77x_ospim.h"
#include "gd32h77x_pkcau.h"
#include "gd32h77x_pmu.h"
#include "gd32h77x_rameccmu.h"
#include "gd32h77x_rcu.h"
#include "gd32h77x_rdcm.h"
#include "gd32h77x_rspdif.h"
#include "gd32h77x_rtc.h"
#include "gd32h77x_rtdec.h"
#include "gd32h77x_sai.h"
#include "gd32h77x_sdio.h"
#include "gd32h77x_spi.h"
#include "gd32h77x_syscfg.h"
#include "gd32h77x_timer.h"
#include "gd32h77x_tli.h"
#include "gd32h77x_tmu.h"
#include "gd32h77x_trigsel.h"
#include "gd32h77x_trng.h"
#include "gd32h77x_usart.h"
#include "gd32h77x_vref.h"
#include "gd32h77x_wwdgt.h"

#endif /* GD32H77X_LIBOPT_H */
