/*!
    \file    gd32w51x_b513_f5hc_libopt.h
    \brief   library optional for gd32w51x

    \version 2025-06-30, V2.0.0, firmware for GD32W51x_B513_F5HC
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef GD32W51X_B513_F5HC_LIBOPT_H
#define GD32W51X_B513_F5HC_LIBOPT_H

#include "gd32w51x_b513_f5hc_adc.h"
#include "gd32w51x_b513_f5hc_cau.h"
#include "gd32w51x_b513_f5hc_crc.h"
#include "gd32w51x_b513_f5hc_dbg.h"
#include "gd32w51x_b513_f5hc_dma.h"
#include "gd32w51x_b513_f5hc_efuse.h"
#include "gd32w51x_b513_f5hc_exti.h"
#include "gd32w51x_b513_f5hc_fmc.h"
#include "gd32w51x_b513_f5hc_fwdgt.h"
#include "gd32w51x_b513_f5hc_gpio.h"
#include "gd32w51x_b513_f5hc_hau.h"
#include "gd32w51x_b513_f5hc_i2c.h"
#include "gd32w51x_b513_f5hc_icache.h"
#include "gd32w51x_b513_f5hc_misc.h"
#include "gd32w51x_b513_f5hc_pkcau.h"
#include "gd32w51x_b513_f5hc_pmu.h"
#include "gd32w51x_b513_f5hc_qspi.h"
#include "gd32w51x_b513_f5hc_rcu.h"
#include "gd32w51x_b513_f5hc_rtc.h"
#include "gd32w51x_b513_f5hc_spi.h"
#include "gd32w51x_b513_f5hc_sqpi.h"
#include "gd32w51x_b513_f5hc_syscfg.h"
#include "gd32w51x_b513_f5hc_timer.h"
#include "gd32w51x_b513_f5hc_trng.h"
#include "gd32w51x_b513_f5hc_tzpcu.h"
#include "gd32w51x_b513_f5hc_usart.h"
#include "gd32w51x_b513_f5hc_wwdgt.h"

#if defined (GD32W515)
#include "gd32w51x_b513_f5hc_sdio.h"
#include "gd32w51x_b513_f5hc_tsi.h"
#include "gd32w51x_b513_f5hc_dci.h"
#include "gd32w51x_b513_f5hc_hpdf.h"
#endif /* defined (GD32W515) */

#if defined (GD32F5HC)
#include "gd32w51x_b513_f5hc_ctc.h"
#endif /* defined (GD32F5HC) */

#endif /* GD32W51X_B513_F5HC_LIBOPT_H */
