/*!
    \file    gd32e511_512_libopt.h
    \brief   library optional for gd32e511_512
    
    \version 2025-04-18, V0.0.0, firmware for GD32E511_512
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef GD32E511_512_LIBOPT_H
#define GD32E511_512_LIBOPT_H

#include "gd32e511_512_adc.h"
#include "gd32e511_512_cla.h"
#include "gd32e511_512_cmp.h"
#include "gd32e511_512_crc.h"
#include "gd32e511_512_dac.h"
#include "gd32e511_512_dbg.h"
#include "gd32e511_512_dma.h"
#include "gd32e511_512_exti.h"
#include "gd32e511_512_fmc.h"
#include "gd32e511_512_fwdgt.h"
#include "gd32e511_512_gpio.h"
#include "gd32e511_512_i2c.h"
#include "gd32e511_512_i3c.h"
#include "gd32e511_512_mdio.h"
#include "gd32e511_512_misc.h"
#include "gd32e511_512_opa.h"
#include "gd32e511_512_pmu.h"
#include "gd32e511_512_rcu.h"
#include "gd32e511_512_rtc.h"
#include "gd32e511_512_spi.h"
#include "gd32e511_512_syscfg.h"
#include "gd32e511_512_timer.h"
#include "gd32e511_512_usart.h"
#include "gd32e511_512_wwdgt.h"

#endif /* GD32E511_512_LIBOPT_H */
