  .syntax unified
  .cpu cortex-m33
  .fpu softvfp
  .thumb

.global  Default_Handler

/* necessary symbols defined in linker script to initialize data */
.word  _sidata
.word  _sdata
.word  _edata
.word  _sbss
.word  _ebss

  .section  .text.Reset_Handler
  .weak  Reset_Handler
  .type  Reset_Handler, %function

/* reset Handler */
Reset_Handler:
  LDR     r0, =0x1FFFF7E0
  LDR     r2, [r0]
  LDR     r0, =0xFFFF0000
  ANDS    r2, r2, r0
  LSRS    r2, r2, #16
  LSLS    r2, r2, #10
  LDR     r1, =0x20000000
  MOV     r0, #0x00
SRAM_INIT:
  STM     r1!, {r0}
  SUBS    r2, r2, #4
  CMP     r2, #0x00
  BNE     SRAM_INIT

  LDR     r0, =_sp
  MOV     sp, r0

/* copy the data segment into ram */
  MOVS    r1, #0
  B       DataInit

CopyData:
  LDR     r3, =_sidata
  LDR     r3, [r3, r1]
  STR     r3, [r0, r1]
  ADDS    r1, r1, #4

DataInit:
  LDR     r0, =_sdata
  LDR     r3, =_edata
  ADDS    r2, r0, r1
  CMP     r2, r3
  BCC     CopyData
  LDR     r2, =_sbss
  B       Zerobss

FillZerobss:
  MOVS    r3, #0
  STR     r3, [r2], #4

Zerobss:
  LDR     r3, =_ebss
  CMP     r2, r3
  BCC     FillZerobss
/* Call SystemInit function */
  BL      SystemInit
/* Call static constructors */
  BL      __libc_init_array
/* Call the main function */
  BL      main
  BX      lr

  .size   Reset_Handler, .-Reset_Handler

  .section .text.Default_Handler, "ax", %progbits
Default_Handler:
Infinite_Loop:
  B       Infinite_Loop
  .size   Default_Handler, .-Default_Handler

  .section .vectors, "a", %progbits
  .global __gVectors

__gVectors:
                    .word _sp                                     /* Top of Stack */
                    .word Reset_Handler                           /* Reset Handler */
                    .word NMI_Handler                             /* non mask-able interrupt */
                    .word HardFault_Handler                       /* hard-fault interrupt */
                    .word MemManage_Handler                       /* Cortex-M33 memory management interrupt */
                    .word BusFault_Handler                        /* Cortex-M33 bus fault interrupt */
                    .word UsageFault_Handler                      /* Cortex-M33 usage fault interrupt */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word SVC_Handler                             /* Cortex-M33 sv call interrupt */
                    .word DebugMon_Handler                        /* Cortex-M33 debug monitor interrupt */
                    .word 0                                       /* Reserved */
                    .word PendSV_Handler                          /* Cortex-M33 pend sv interrupt */
                    .word SysTick_Handler                         /* Cortex-M33 system tick interrupt */

                    /* External interrupts handler */
                    .word WWDGT_IRQHandler                        /* Vector Number 16, window watchdog timer interrupt */
                    .word LVD_IRQHandler                          /* Vector Number 17, LVD through EXTI line detection interrupt */
                    .word RTC_IRQHandler                          /* Vector Number 18, RTC global interrupt */
                    .word FMC_IRQHandler                          /* Vector Number 19, FMC interrupt */
                    .word RCU_IRQHandler                          /* Vector Number 20, RCU interrupt */
                    .word EXTI0_1_IRQHandler                      /* Vector Number 21, EXTI line0-1 interrupt */
                    .word EXTI2_3_IRQHandler                      /* Vector Number 22, EXTI line2-3 interrupt */
                    .word EXTI4_15_IRQHandler                     /* Vector Number 23, EXTI line4-15 interrupt */
                    .word 0                                       /* Reserved */
                    .word DMA_Channel0_IRQHandler                 /* Vector Number 25, DMA channel 0 global interrupt */
                    .word DMA_Channel1_2_IRQHandler               /* Vector Number 26, DMA channel 1-2 global interrupt */
                    .word DMA_Channel3_4_IRQHandler               /* Vector Number 27, DMA channel 3-4 global interrupt */
                    .word ADC_CMP_IRQHandler                      /* Vector Number 28, ADC0-1 and CMP0-1 interrupt */
                    .word TIMER0_BRK_UP_TRG_COM_IRQHandler        /* Vector Number 29, TIMER0 break, update, trigger and commutation interrupt */
                    .word TIMER0_Channel_IRQHandler               /* Vector Number 30, TIMER0 capture compare interrupt */
                    .word TIMER1_IRQHandler                       /* Vector Number 31, TIMER1 global interrupt */
                    .word TIMER2_IRQHandler                       /* Vector Number 32, TIMER2 global interrupt */
                    .word TIMER5_DAC0_1_IRQHandler                /* Vector Number 33, TIMER5 interrupt, DAC0, DAC1 global interrupt */
                    .word TIMER6_DAC2_3_IRQHandler                /* Vector Number 34, TIMER6, DAC2, DAC3 interrupt */
                    .word TIMER13_IRQHandler                      /* Vector Number 35, TIMER13 global interrupt */
                    .word TIMER14_IRQHandler                      /* Vector Number 36, TIMER14 global interrupt */
                    .word TIMER15_IRQHandler                      /* Vector Number 37, TIMER15 global interrupt */
                    .word TIMER16_IRQHandler                      /* Vector Number 38, TIMER16 global interrupt */
                    .word I2C0_EV_IRQHandler                      /* Vector Number 39, I2C0 event interrupt */
                    .word I2C1_EV_IRQHandler                      /* Vector Number 40, I2C1 event interrupt */
                    .word SPI0_IRQHandler                         /* Vector Number 41, SPI0 global interrupt */
                    .word SPI1_IRQHandler                         /* Vector Number 42, SPI1 global interrupt */
                    .word USART0_IRQHandler                       /* Vector Number 43, USART0 global interrupt */
                    .word UART3_IRQHandler                        /* Vector Number 44, UART3 global interrupt */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word I2C0_ER_IRQHandler                      /* Vector Number 48, I2C0 error interrupt */
                    .word 0                                       /* Reserved */
                    .word I2C1_ER_IRQHandler                      /* Vector Number 50, I2C1 error interrupt */
                    .word I2C2_EV_IRQHandler                      /* Vector Number 51, I2C2 event interrupt */
                    .word I2C2_ER_IRQHandler                      /* Vector Number 52, I2C2 error interrupt */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word CLA_IRQHandler                          /* Vector Number 55, CLA global interrupt */
                    .word MDIO_IRQHandler                         /* Vector Number 56, MDIO global interrupt */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word DMA_Channel5_6_IRQHandler               /* Vector Number 64, DMA channel5-6 global interrupt */
                    .word I3C_EV_IRQHandler                       /* Vector Number 65, I3C event interrupt */
                    .word I3C_ER_IRQHandler                       /* Vector Number 66, I3C error interrupt */
                    .word SPI2_IRQHandler                         /* Vector Number 67, SPI2 global interrupt */
                    .word SPI3_IRQHandler                         /* Vector Number 68, SPI3 global interrupt */
                    .word DMA_Channel7_IRQHandler                 /* Vector Number 69, DMA channel 7 global interrupt */
                    .word SRAM_ECC_IRQHandler                     /* Vector Number 70, SRAM ECC interrupt */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word 0                                       /* Reserved */
                    .word FPU_IRQHandler                          /* Vector Number 84, FPU interrupt */

  .size   __gVectors, . - __gVectors

  .weak NMI_Handler
  .thumb_set NMI_Handler,Default_Handler

  .weak HardFault_Handler
  .thumb_set HardFault_Handler,Default_Handler

  .weak MemManage_Handler
  .thumb_set MemManage_Handler,Default_Handler

  .weak BusFault_Handler
  .thumb_set BusFault_Handler,Default_Handler

  .weak UsageFault_Handler
  .thumb_set UsageFault_Handler,Default_Handler

  .weak SVC_Handler
  .thumb_set SVC_Handler,Default_Handler

  .weak DebugMon_Handler
  .thumb_set DebugMon_Handler,Default_Handler

  .weak PendSV_Handler
  .thumb_set PendSV_Handler,Default_Handler

  .weak SysTick_Handler
  .thumb_set SysTick_Handler,Default_Handler

  .weak WWDGT_IRQHandler
  .thumb_set WWDGT_IRQHandler,Default_Handler

  .weak LVD_IRQHandler
  .thumb_set LVD_IRQHandler,Default_Handler

  .weak RTC_IRQHandler
  .thumb_set RTC_IRQHandler,Default_Handler

  .weak FMC_IRQHandler
  .thumb_set FMC_IRQHandler,Default_Handler

  .weak RCU_IRQHandler
  .thumb_set RCU_IRQHandler,Default_Handler

  .weak EXTI0_1_IRQHandler
  .thumb_set EXTI0_1_IRQHandler,Default_Handler

  .weak EXTI2_3_IRQHandler
  .thumb_set EXTI2_3_IRQHandler,Default_Handler

  .weak EXTI4_15_IRQHandler
  .thumb_set EXTI4_15_IRQHandler,Default_Handler

  .weak DMA_Channel0_IRQHandler
  .thumb_set DMA_Channel0_IRQHandler,Default_Handler

  .weak DMA_Channel1_2_IRQHandler
  .thumb_set DMA_Channel1_2_IRQHandler,Default_Handler

  .weak DMA_Channel3_4_IRQHandler
  .thumb_set DMA_Channel3_4_IRQHandler,Default_Handler

  .weak ADC_CMP_IRQHandler
  .thumb_set ADC_CMP_IRQHandler,Default_Handler

  .weak TIMER0_BRK_UP_TRG_COM_IRQHandler
  .thumb_set TIMER0_BRK_UP_TRG_COM_IRQHandler,Default_Handler

  .weak TIMER0_Channel_IRQHandler
  .thumb_set TIMER0_Channel_IRQHandler,Default_Handler

  .weak TIMER1_IRQHandler
  .thumb_set TIMER1_IRQHandler,Default_Handler

  .weak TIMER2_IRQHandler
  .thumb_set TIMER2_IRQHandler,Default_Handler

  .weak TIMER5_DAC0_1_IRQHandler
  .thumb_set TIMER5_DAC0_1_IRQHandler,Default_Handler

  .weak TIMER6_DAC2_3_IRQHandler
  .thumb_set TIMER6_DAC2_3_IRQHandler,Default_Handler

  .weak TIMER13_IRQHandler
  .thumb_set TIMER13_IRQHandler,Default_Handler

  .weak TIMER14_IRQHandler
  .thumb_set TIMER14_IRQHandler,Default_Handler

  .weak TIMER15_IRQHandler
  .thumb_set TIMER15_IRQHandler,Default_Handler

  .weak TIMER16_IRQHandler
  .thumb_set TIMER16_IRQHandler,Default_Handler

  .weak I2C0_EV_IRQHandler
  .thumb_set I2C0_EV_IRQHandler,Default_Handler

  .weak I2C1_EV_IRQHandler
  .thumb_set I2C1_EV_IRQHandler,Default_Handler

  .weak SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Default_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Default_Handler

  .weak USART0_IRQHandler
  .thumb_set USART0_IRQHandler,Default_Handler

  .weak UART3_IRQHandler
  .thumb_set UART3_IRQHandler,Default_Handler

  .weak I2C0_ER_IRQHandler
  .thumb_set I2C0_ER_IRQHandler,Default_Handler

  .weak I2C1_ER_IRQHandler
  .thumb_set I2C1_ER_IRQHandler,Default_Handler

  .weak I2C2_EV_IRQHandler
  .thumb_set I2C2_EV_IRQHandler,Default_Handler

  .weak I2C2_ER_IRQHandler
  .thumb_set I2C2_ER_IRQHandler,Default_Handler

  .weak CLA_IRQHandler
  .thumb_set CLA_IRQHandler,Default_Handler

  .weak MDIO_IRQHandler
  .thumb_set MDIO_IRQHandler,Default_Handler

  .weak DMA_Channel5_6_IRQHandler
  .thumb_set DMA_Channel5_6_IRQHandler,Default_Handler

  .weak I3C_EV_IRQHandler
  .thumb_set I3C_EV_IRQHandler,Default_Handler

  .weak I3C_ER_IRQHandler
  .thumb_set I3C_ER_IRQHandler,Default_Handler

  .weak SPI2_IRQHandler
  .thumb_set SPI2_IRQHandler,Default_Handler

  .weak SPI3_IRQHandler
  .thumb_set SPI3_IRQHandler,Default_Handler

  .weak DMA_Channel7_IRQHandler
  .thumb_set DMA_Channel7_IRQHandler,Default_Handler

  .weak SRAM_ECC_IRQHandler
  .thumb_set SRAM_ECC_IRQHandler,Default_Handler

  .weak FPU_IRQHandler
  .thumb_set FPU_IRQHandler,Default_Handler

