/*!
    \file    gd32e501_libopt.h
    \brief   library optional for gd32e501
    
    \version 2020-03-02, V1.0.0, firmware for GD32E501
    \version 2020-04-10, V1.0.1, firmware for GD32E501
*/

/*
    Copyright (c) 2020, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef GD32E501_LIBOPT_H
#define GD32E501_LIBOPT_H

#include "gd32e501_adc.h"
#include "gd32e501_crc.h"
#include "gd32e501_cla.h"
#include "gd32e501_dac.h"
#include "gd32e501_dbg.h"
#include "gd32e501_dma.h"
#include "gd32e501_exti.h"
#include "gd32e501_fmc.h"
#include "gd32e501_gpio.h"
#include "gd32e501_mdio.h"
#include "gd32e501_syscfg.h"
#include "gd32e501_i2c.h"
#include "gd32e501_fwdgt.h"
#include "gd32e501_pmu.h"
#include "gd32e501_rcu.h"
#include "gd32e501_rtc.h"
#include "gd32e501_spi.h"
#include "gd32e501_timer.h"
#include "gd32e501_usart.h"
#include "gd32e501_wwdgt.h"
#include "gd32e501_misc.h"
#include "gd32e501_cmp.h"

#endif /* GD32E501_LIBOPT_H */
