[#ftl]
/*!
    \file    hs1_usb_conf.h
    \brief   USB core driver basic configuration

    \version 2024-09-01, V1.0.0, HAL firmware for GD32H7xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS1_USB_CONF_H
#define __HS1_USB_CONF_H

#ifdef __cplusplus
extern "C" {
#endif

/* External Includes*/
#include "stdlib.h"
#include "gd32h7xx_hal.h"
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Type Definitions] begin */

/* user code [Type Definitions] end */

/* Shared Macros */
/* USB Core and PHY interface configuration */
[#if EMBPHY1_HS == "EMBPHY1_HS_0"]
#define HS1_USE_ULPI_PHY
[/#if]

/****************** USB HS PHY CONFIGURATION *******************************
 *  The USB HS Core supports one on-chip High Speed PHY.
 *  The USE_EMBEDDED_PHY symbol is defined in the project compiler preprocessor
 *  when HS core is used.
*******************************************************************************/

/* on-chip full-speed USB PHY */
[#if USBHS1_USB1Type == "USBFS"]
#define HS1_USE_USB_FS

#ifdef HS1_USE_USB_FS
    #define HS1_OC_FS_PHY
#endif
[/#if]

/* on-chip high-speed USB PHY */
[#if USBHS1_USB1Type == "USBHS"]
#define HS1_USE_USB_HS

#ifdef HS1_USE_USB_HS
    #define HS1_OC_HS_PHY
#endif /* HS1_USE_USB_HS */
[/#if]

/*******************************************************************************
 *                      FIFO Size Configuration in Device mode
 *
 *  (i) Receive data FIFO size = RAM for setup packets +
 *                   OUT endpoint control information +
 *                   data OUT packets + miscellaneous
 *      Space = ONE 32-bits words
 *      --> RAM for setup packets = 10 spaces
 *          (n is the nbr of CTRL EPs the device core supports)
 *      --> OUT EP CTRL info = 1 space
 *          (one space for status information written to the FIFO along with each
 *          received packet)
 *      --> Data OUT packets = (Largest Packet Size / 4) + 1 spaces
 *          (MINIMUM to receive packets)
 *      --> OR data OUT packets  = at least 2* (Largest Packet Size / 4) + 1 spaces
 *          (if high-bandwidth EP is enabled or multiple isochronous EPs)
 *      --> Miscellaneous = 1 space per OUT EP
 *          (one space for transfer complete status information also pushed to the
 *          FIFO with each endpoint's last packet)
 *
 *  (ii) MINIMUM RAM space required for each IN EP Tx FIFO = MAX packet size for
 *       that particular IN EP. More space allocated in the IN EP Tx FIFO results
 *       in a better performance on the USB and can hide latencies on the AHB.
 *
 *  (iii) TXn min size = 16 words. (n:Transmit FIFO index)
 *
 *  (iv) When a TxFIFO is not used, the Configuration should be as follows:
 *       case 1: n > m and Txn is not used (n,m:Transmit FIFO indexes)
 *       --> Txm can use the space allocated for Txn.
 *       case 2: n < m and Txn is not used (n,m:Transmit FIFO indexes)
 *       --> Txn should be configured with the minimum space of 16 words
 *
 *  (v) The FIFO is used optimally when used TxFIFOs are allocated in the top
 *      of the FIFO.Ex: use EP1 and EP2 as IN instead of EP1 and EP3 as IN ones.
 *
 *  (vi) In HS case12 FIFO locations should be reserved for internal DMA registers
 *       so total FIFO size should be 1012 Only instead of 1024
*******************************************************************************/

#ifdef HS1_USE_ULPI_PHY
    #define HS1_USB_EXTERNAL_ULPI_PHY_ENABLED
#else
    #ifdef HS1_OC_FS_PHY
         #define HS1_USB_EMBEDDED_FS_PHY_ENABLED
    #elif defined(HS1_OC_HS_PHY)
         #define HS1_USB_EMBEDDED_HS_PHY_ENABLED
    #else
         #error "PHY is not selected"
    #endif
#endif

[#if USBHS1_ExternalPhy == "USB1 Host" || USBHS1_InternalPhy == "USB1 Host"]
#define HS1_USE_HOST_MODE
[/#if]
[#if USBHS1_ExternalPhy == "USB1 Device" || USBHS1_InternalPhy == "USB1 Device"]
#define HS1_USE_DEVICE_MODE
[/#if]
//#define HS1_USE_OTG_MODE

#ifndef HS1_OC_FS_PHY
    #ifndef HS1_OC_HS_PHY
        #error  "HS1_OC_FS_PHY or HS1_OC_HS_PHY should be defined!"
    #endif
#endif

#ifndef HS1_USE_DEVICE_MODE
    #ifndef HS1_USE_HOST_MODE
        #error  "HS1_USE_DEVICE_MODE or HS1_USE_HOST_MODE should be defined!"
    #endif
#endif

#ifndef HS1_USE_USB_HS
    #ifndef HS1_USE_USB_FS
        #error  "HS1_USE_USB_HS or HS1_USE_USB_FS should be defined!"
    #endif
#endif

/* In HS mode and when the DMA is used, all variables and data structures dealing
   with the DMA during the transaction process should be 4-bytes aligned */

#if defined (__GNUC__)         /* GNU Compiler */
    #define __ALIGN_END __attribute__ ((aligned (4)))
    #define __ALIGN_BEGIN
#else
    #define __ALIGN_END

    #if defined (__CC_ARM)     /* ARM Compiler */
        #define __ALIGN_BEGIN __align(4)
    #elif defined (__ICCARM__) /* IAR Compiler */
        #define __ALIGN_BEGIN
    #elif defined (__TASKING__)/* TASKING Compiler */
        #define __ALIGN_BEGIN __align(4)
    #endif /* __CC_ARM */
#endif /* __GNUC__ */

/* __packed keyword used to decrease the data type alignment to 1-byte */
#if defined (__GNUC__)       /* GNU Compiler */
    #ifndef __packed
        #define __packed __attribute__ ((__packed__))
    #endif
#elif defined (__TASKING__)    /* TASKING Compiler */
    #define __packed __unaligned
#endif /* __CC_ARM */
/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#ifdef __cplusplus
}
#endif

#endif /* __HS1_USB_CONF_H */
