/*!
    \file    drv_usb_hw.h
    \brief   USB hardware configuration header file

    \version 2024-09-01, V1.0.0, HAL firmware for GD32H7xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __DRV_USB_HW_H
#define __DRV_USB_HW_H

#include <stdint.h>
#include "gd32h7xx_hal.h"

/* function declarations */
/* configure USB clock */
void usb_rcu_config (void);
/* initializes delay unit using Timer2 */
void usb_timer_init (void);
/* delay in milli seconds */
void usb_mdelay (const uint32_t msec);

void pllusb_rcu_config(uint32_t usb_periph);

#if (defined USE_USBHS0_HOST_HID) || (defined USE_USBHS0_HOST_MSC) || \
    (defined USE_USBHS1_HOST_HID) || (defined USE_USBHS1_HOST_MSC)
/* configure systick */
void systick_config(void);
#if (defined USE_USBHS0_HOST_HID) || (defined USE_USBHS0_HOST_MSC)
/* configure USB VBus */
void hs0_usb_vbus_config (void);
/* drive USB VBus */
void hs0_usb_vbus_drive (uint8_t State);
#endif /* HS0_USE_HOST_MODE */
#if (defined USE_USBHS1_HOST_HID) || (defined USE_USBHS1_HOST_MSC)
/* configure USB VBus */
void hs1_usb_vbus_config (void);
/* drive USB VBus */
void hs1_usb_vbus_drive (uint8_t State);
#endif /* HS1_USE_HOST_MODE */
#endif /* HS0_USE_HOST_MODE || HS1_USE_HOST_MODE */

#endif /* __DRV_USB_HW_H */
